// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Amazon Web Services credentials for API authentication.
 */
internal class Credentials private constructor(builder: Builder) {
    /**
     * The access key ID that identifies the temporary security credentials.
     */
    public val accessKeyId: kotlin.String = requireNotNull(builder.accessKeyId) { "A non-null value must be provided for accessKeyId" }
    /**
     * The date on which the current credentials expire.
     */
    public val expiration: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.expiration) { "A non-null value must be provided for expiration" }
    /**
     * The secret access key that can be used to sign requests.
     */
    public val secretAccessKey: kotlin.String = requireNotNull(builder.secretAccessKey) { "A non-null value must be provided for secretAccessKey" }
    /**
     * The token that users must pass to the service API to use the temporary credentials.
     */
    public val sessionToken: kotlin.String = requireNotNull(builder.sessionToken) { "A non-null value must be provided for sessionToken" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Credentials(")
        append("accessKeyId=$accessKeyId,")
        append("expiration=$expiration,")
        append("secretAccessKey=*** Sensitive Data Redacted ***,")
        append("sessionToken=$sessionToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId.hashCode()
        result = 31 * result + (expiration.hashCode())
        result = 31 * result + (secretAccessKey.hashCode())
        result = 31 * result + (sessionToken.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Credentials

        if (accessKeyId != other.accessKeyId) return false
        if (expiration != other.expiration) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (sessionToken != other.sessionToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The access key ID that identifies the temporary security credentials.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * The date on which the current credentials expire.
         */
        public var expiration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The secret access key that can be used to sign requests.
         */
        public var secretAccessKey: kotlin.String? = null
        /**
         * The token that users must pass to the service API to use the temporary credentials.
         */
        public var sessionToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials) : this() {
            this.accessKeyId = x.accessKeyId
            this.expiration = x.expiration
            this.secretAccessKey = x.secretAccessKey
            this.sessionToken = x.sessionToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials = Credentials(this)

        internal fun correctErrors(): Builder {
            if (accessKeyId == null) accessKeyId = ""
            if (expiration == null) expiration = Instant.fromEpochSeconds(0)
            if (secretAccessKey == null) secretAccessKey = ""
            if (sessionToken == null) sessionToken = ""
            return this
        }
    }
}
