/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.arns;

import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B1\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0006H\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001a"}, d2={"Laws/sdk/kotlin/runtime/arns/Arn;", "", "builder", "Laws/sdk/kotlin/runtime/arns/Arn$Builder;", "(Laws/sdk/kotlin/runtime/arns/Arn$Builder;)V", "partition", "", "service", "region", "accountId", "resource", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAccountId", "()Ljava/lang/String;", "getPartition", "getRegion", "getResource", "getService", "equals", "", "other", "hashCode", "", "toString", "Builder", "Companion", "aws-config"})
@SourceDebugExtension(value={"SMAP\nArn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Arn.kt\naws/sdk/kotlin/runtime/arns/Arn\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
public final class Arn {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String partition;
    @NotNull
    private final String service;
    @Nullable
    private final String region;
    @Nullable
    private final String accountId;
    @NotNull
    private final String resource;

    public Arn(@NotNull String partition, @NotNull String service, @Nullable String region2, @Nullable String accountId, @NotNull String resource) {
        Intrinsics.checkNotNullParameter((Object)partition, (String)"partition");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        this.partition = partition;
        this.service = service;
        this.region = region2;
        this.accountId = accountId;
        this.resource = resource;
        if (!(this.region == null || !StringsKt.isBlank((CharSequence)this.region))) {
            boolean $i$a$-require-Arn$32 = false;
            String $i$a$-require-Arn$32 = "ARN region must not be blank";
            throw new IllegalArgumentException($i$a$-require-Arn$32.toString());
        }
        if (!(this.accountId == null || !StringsKt.isBlank((CharSequence)this.accountId))) {
            boolean bl = false;
            String string = "ARN accountId must not be blank";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getPartition() {
        return this.partition;
    }

    @NotNull
    public final String getService() {
        return this.service;
    }

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    @Nullable
    public final String getAccountId() {
        return this.accountId;
    }

    @NotNull
    public final String getResource() {
        return this.resource;
    }

    public Arn(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        String string = builder.getPartition();
        Intrinsics.checkNotNull((Object)string);
        String string2 = builder.getService();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = builder.getRegion();
        String string4 = builder.getAccountId();
        String string5 = builder.getResource();
        Intrinsics.checkNotNull((Object)string5);
        this(string, string2, string3, string4, string5);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u242.append("arn:" + this.partition + ':' + this.service + ':');
        if (this.region != null) {
            $this$toString_u24lambda_u242.append(this.region);
        }
        $this$toString_u24lambda_u242.append(":");
        if (this.accountId != null) {
            $this$toString_u24lambda_u242.append(this.accountId);
        }
        $this$toString_u24lambda_u242.append(':' + this.resource);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Arn)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.partition, (Object)((Arn)other).partition)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.service, (Object)((Arn)other).service)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.region, (Object)((Arn)other).region)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.accountId, (Object)((Arn)other).accountId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.resource, (Object)((Arn)other).resource);
    }

    public int hashCode() {
        int result = this.partition.hashCode();
        result = 31 * result + this.service.hashCode();
        String string = this.region;
        result = 31 * result + (string != null ? string.hashCode() : 0);
        String string2 = this.accountId;
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        result = 31 * result + this.resource.hashCode();
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0001R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u0017"}, d2={"Laws/sdk/kotlin/runtime/arns/Arn$Builder;", "", "()V", "accountId", "", "getAccountId", "()Ljava/lang/String;", "setAccountId", "(Ljava/lang/String;)V", "partition", "getPartition", "setPartition", "region", "getRegion", "setRegion", "resource", "getResource", "setResource", "service", "getService", "setService", "build", "Laws/sdk/kotlin/runtime/arns/Arn;", "aws-config"})
    @SourceDebugExtension(value={"SMAP\nArn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Arn.kt\naws/sdk/kotlin/runtime/arns/Arn$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
    public static final class Builder {
        @Nullable
        private String partition;
        @Nullable
        private String service;
        @Nullable
        private String region;
        @Nullable
        private String accountId;
        @Nullable
        private String resource;

        @Nullable
        public final String getPartition() {
            return this.partition;
        }

        public final void setPartition(@Nullable String string) {
            this.partition = string;
        }

        @Nullable
        public final String getService() {
            return this.service;
        }

        public final void setService(@Nullable String string) {
            this.service = string;
        }

        @Nullable
        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(@Nullable String string) {
            this.region = string;
        }

        @Nullable
        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(@Nullable String string) {
            this.accountId = string;
        }

        @Nullable
        public final String getResource() {
            return this.resource;
        }

        public final void setResource(@Nullable String string) {
            this.resource = string;
        }

        @PublishedApi
        @NotNull
        public final Arn build() {
            CharSequence charSequence = this.partition;
            if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) {
                boolean $i$a$-require-Arn$Builder$build$32 = false;
                String $i$a$-require-Arn$Builder$build$32 = "ARN partition must not be null or blank";
                throw new IllegalArgumentException($i$a$-require-Arn$Builder$build$32.toString());
            }
            charSequence = this.service;
            if (!(!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)))) {
                boolean $i$a$-require-Arn$Builder$build$42 = false;
                String $i$a$-require-Arn$Builder$build$42 = "ARN service must not be null or blank";
                throw new IllegalArgumentException($i$a$-require-Arn$Builder$build$42.toString());
            }
            if (this.resource == null) {
                boolean bl = false;
                String string = "ARN resource must not be null";
                throw new IllegalArgumentException(string.toString());
            }
            return new Arn(this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0086\n\u00f8\u0001\u0000J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\r"}, d2={"Laws/sdk/kotlin/runtime/arns/Arn$Companion;", "", "()V", "invoke", "Laws/sdk/kotlin/runtime/arns/Arn;", "block", "Lkotlin/Function1;", "Laws/sdk/kotlin/runtime/arns/Arn$Builder;", "", "Lkotlin/ExtensionFunctionType;", "parse", "arn", "", "aws-config"})
    @SourceDebugExtension(value={"SMAP\nArn.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Arn.kt\naws/sdk/kotlin/runtime/arns/Arn$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n33#1:117\n1#2:116\n*S KotlinDebug\n*F\n+ 1 Arn.kt\naws/sdk/kotlin/runtime/arns/Arn$Companion\n*L\n45#1:117\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Arn invoke(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$invoke = false;
            Builder builder = new Builder();
            block.invoke((Object)builder);
            return builder.build();
        }

        @NotNull
        public final Arn parse(@NotNull String arn) {
            String p0;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)arn, (String)"arn");
            char[] cArray = new char[]{':'};
            List parts = StringsKt.split$default((CharSequence)arn, (char[])cArray, (boolean)false, (int)6, (int)2, null);
            if (!(parts.size() == 6)) {
                boolean $i$a$-require-Arn$Companion$parse$52 = false;
                String $i$a$-require-Arn$Companion$parse$52 = "Malformed ARN (" + arn + ") does not have the expected number of components";
                throw new IllegalArgumentException($i$a$-require-Arn$Companion$parse$52.toString());
            }
            if (!Intrinsics.areEqual(parts.get(0), (Object)"arn")) {
                boolean $i$a$-require-Arn$Companion$parse$62 = false;
                String $i$a$-require-Arn$Companion$parse$62 = "Malformed ARN - does not start with `arn:`";
                throw new IllegalArgumentException($i$a$-require-Arn$Companion$parse$62.toString());
            }
            if (!(!StringsKt.isBlank((CharSequence)((CharSequence)parts.get(1))))) {
                boolean $i$a$-require-Arn$Companion$parse$72 = false;
                String $i$a$-require-Arn$Companion$parse$72 = "Malformed ARN - no AWS partition specified";
                throw new IllegalArgumentException($i$a$-require-Arn$Companion$parse$72.toString());
            }
            if (!(!StringsKt.isBlank((CharSequence)((CharSequence)parts.get(2))))) {
                boolean $i$a$-require-Arn$Companion$parse$82 = false;
                String $i$a$-require-Arn$Companion$parse$82 = "Malformed ARN - no AWS service specified";
                throw new IllegalArgumentException($i$a$-require-Arn$Companion$parse$82.toString());
            }
            Companion this_$iv = Companion;
            boolean $i$f$invoke = false;
            Builder $this$parse_u24lambda_u245 = builder = new Builder();
            boolean bl = false;
            $this$parse_u24lambda_u245.setPartition((String)parts.get(1));
            $this$parse_u24lambda_u245.setService((String)parts.get(2));
            Object e = parts.get(3);
            String string = (String)e;
            Builder builder2 = $this$parse_u24lambda_u245;
            boolean bl2 = false;
            builder2.setRegion((String)(Boolean.valueOf(!StringsKt.isBlank((CharSequence)p0)) != false ? e : null));
            e = parts.get(4);
            p0 = (String)e;
            builder2 = $this$parse_u24lambda_u245;
            boolean bl3 = false;
            builder2.setAccountId((String)(Boolean.valueOf(!StringsKt.isBlank((CharSequence)p0)) != false ? e : null));
            $this$parse_u24lambda_u245.setResource((String)parts.get(5));
            return builder.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

