// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * AWS credentials structure containing temporary access credentials The scoped-down, 15 minute duration AWS credentials. Scoping down will be based on CLI policy (CLI team needs to create it). Similar to cloud shell implementation.
 */
internal class AccessToken private constructor(builder: Builder) {
    /**
     * AWS access key ID for temporary credentials
     */
    public val accessKeyId: kotlin.String = requireNotNull(builder.accessKeyId) { "A non-null value must be provided for accessKeyId" }
    /**
     * AWS secret access key for temporary credentials
     */
    public val secretAccessKey: kotlin.String = requireNotNull(builder.secretAccessKey) { "A non-null value must be provided for secretAccessKey" }
    /**
     * AWS session token for temporary credentials
     */
    public val sessionToken: kotlin.String = requireNotNull(builder.sessionToken) { "A non-null value must be provided for sessionToken" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model.AccessToken = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessToken(")
        append("*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId.hashCode()
        result = 31 * result + (this.secretAccessKey.hashCode())
        result = 31 * result + (this.sessionToken.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessToken

        if (accessKeyId != other.accessKeyId) return false
        if (secretAccessKey != other.secretAccessKey) return false
        if (sessionToken != other.sessionToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model.AccessToken = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * AWS access key ID for temporary credentials
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * AWS secret access key for temporary credentials
         */
        public var secretAccessKey: kotlin.String? = null
        /**
         * AWS session token for temporary credentials
         */
        public var sessionToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model.AccessToken) : this() {
            this.accessKeyId = x.accessKeyId
            this.secretAccessKey = x.secretAccessKey
            this.sessionToken = x.sessionToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model.AccessToken = AccessToken(this)

        internal fun correctErrors(): Builder {
            if (accessKeyId == null) accessKeyId = ""
            if (secretAccessKey == null) secretAccessKey = ""
            if (sessionToken == null) sessionToken = ""
            return this
        }
    }
}
