// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model

import aws.smithy.kotlin.runtime.SdkDsl


/**
 * Request body payload for CreateOAuth2Token operation The operation type is determined by the grant_type parameter: - grant_type=authorization_code: Requires code, redirect_uri, code_verifier - grant_type=refresh_token: Requires refresh_token
 */
internal class CreateOAuth2TokenRequestBody private constructor(builder: Builder) {
    /**
     * The client identifier (ARN) used during Sign-In onboarding Required for both authorization code and refresh token flows
     */
    public val clientId: kotlin.String = requireNotNull(builder.clientId) { "A non-null value must be provided for clientId" }
    /**
     * The authorization code received from /v1/authorize Required only when grant_type=authorization_code
     */
    public val code: kotlin.String? = builder.code
    /**
     * PKCE code verifier to prove possession of the original code challenge Required only when grant_type=authorization_code
     */
    public val codeVerifier: kotlin.String? = builder.codeVerifier
    /**
     * OAuth 2.0 grant type - determines which flow is used Must be "authorization_code" or "refresh_token"
     */
    public val grantType: kotlin.String = requireNotNull(builder.grantType) { "A non-null value must be provided for grantType" }
    /**
     * The redirect URI that must match the original authorization request Required only when grant_type=authorization_code
     */
    public val redirectUri: kotlin.String? = builder.redirectUri
    /**
     * The refresh token returned from auth_code redemption Required only when grant_type=refresh_token
     */
    public val refreshToken: kotlin.String? = builder.refreshToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model.CreateOAuth2TokenRequestBody = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateOAuth2TokenRequestBody(")
        append("clientId=$clientId,")
        append("code=$code,")
        append("codeVerifier=$codeVerifier,")
        append("grantType=$grantType,")
        append("redirectUri=$redirectUri,")
        append("refreshToken=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientId.hashCode()
        result = 31 * result + (this.code?.hashCode() ?: 0)
        result = 31 * result + (this.codeVerifier?.hashCode() ?: 0)
        result = 31 * result + (this.grantType.hashCode())
        result = 31 * result + (this.redirectUri?.hashCode() ?: 0)
        result = 31 * result + (this.refreshToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateOAuth2TokenRequestBody

        if (clientId != other.clientId) return false
        if (code != other.code) return false
        if (codeVerifier != other.codeVerifier) return false
        if (grantType != other.grantType) return false
        if (redirectUri != other.redirectUri) return false
        if (refreshToken != other.refreshToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model.CreateOAuth2TokenRequestBody = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The client identifier (ARN) used during Sign-In onboarding Required for both authorization code and refresh token flows
         */
        public var clientId: kotlin.String? = null
        /**
         * The authorization code received from /v1/authorize Required only when grant_type=authorization_code
         */
        public var code: kotlin.String? = null
        /**
         * PKCE code verifier to prove possession of the original code challenge Required only when grant_type=authorization_code
         */
        public var codeVerifier: kotlin.String? = null
        /**
         * OAuth 2.0 grant type - determines which flow is used Must be "authorization_code" or "refresh_token"
         */
        public var grantType: kotlin.String? = null
        /**
         * The redirect URI that must match the original authorization request Required only when grant_type=authorization_code
         */
        public var redirectUri: kotlin.String? = null
        /**
         * The refresh token returned from auth_code redemption Required only when grant_type=refresh_token
         */
        public var refreshToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model.CreateOAuth2TokenRequestBody) : this() {
            this.clientId = x.clientId
            this.code = x.code
            this.codeVerifier = x.codeVerifier
            this.grantType = x.grantType
            this.redirectUri = x.redirectUri
            this.refreshToken = x.refreshToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.runtime.auth.credentials.internal.signin.model.CreateOAuth2TokenRequestBody = CreateOAuth2TokenRequestBody(this)

        internal fun correctErrors(): Builder {
            if (clientId == null) clientId = ""
            if (grantType == null) grantType = ""
            return this
        }
    }
}
