// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinRuntimeAuthCredentialsInternalStsModelAssumedRoleUserDslBuilderRef = aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser
private val awsSdkKotlinRuntimeAuthCredentialsInternalStsModelCredentialsDslBuilderRef = aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials

/**
 * Contains the response to a successful AssumeRoleWithWebIdentity request, including temporary Amazon Web Services credentials that can be used to make Amazon Web Services requests.
 */
internal class AssumeRoleWithWebIdentityResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the `RoleSessionName` that you specified when you called `AssumeRole`.
     */
    public val assumedRoleUser: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser? = builder.assumedRoleUser
    /**
     * The intended audience (also known as client ID) of the web identity token. This is traditionally the client identifier issued to the application that requested the web identity token.
     */
    public val audience: kotlin.String? = builder.audience
    /**
     * The temporary security credentials, which include an access key ID, a secret access key, and a security token.
     *
     * The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.
     */
    public val credentials: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials? = builder.credentials
    /**
     * A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.
     */
    public val packedPolicySize: kotlin.Int? = builder.packedPolicySize
    /**
     * The issuing authority of the web identity token presented. For OpenID Connect ID tokens, this contains the value of the `iss` field. For OAuth 2.0 access tokens, this contains the value of the `ProviderId` parameter that was passed in the `AssumeRoleWithWebIdentity` request.
     */
    public val provider: kotlin.String? = builder.provider
    /**
     * The value of the source identity that is returned in the JSON web token (JWT) from the identity provider.
     *
     * You can require users to set a source identity value when they assume a role. You do this by using the `sts:SourceIdentity` condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across [chained role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html#id_roles_terms-and-concepts) sessions. You can configure your identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling `AssumeRoleWithWebIdentity`. You do this by adding a claim to the JSON web token. To learn more about OIDC tokens and claims, see [Using Tokens with User Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html) in the *Amazon Cognito Developer Guide*. For more information about using source identity, see [Monitor and control actions taken with assumed roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html) in the *IAM User Guide*.
     *
     * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
     */
    public val sourceIdentity: kotlin.String? = builder.sourceIdentity
    /**
     * The unique user identifier that is returned by the identity provider. This identifier is associated with the `WebIdentityToken` that was submitted with the `AssumeRoleWithWebIdentity` call. The identifier is typically unique to the user and the application that acquired the `WebIdentityToken` (pairwise identifier). For OpenID Connect ID tokens, this field contains the value returned by the identity provider as the token's `sub` (Subject) claim.
     */
    public val subjectFromWebIdentityToken: kotlin.String? = builder.subjectFromWebIdentityToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleWithWebIdentityResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssumeRoleWithWebIdentityResponse(")
        append("assumedRoleUser=$assumedRoleUser,")
        append("audience=$audience,")
        append("credentials=$credentials,")
        append("packedPolicySize=$packedPolicySize,")
        append("provider=$provider,")
        append("sourceIdentity=$sourceIdentity,")
        append("subjectFromWebIdentityToken=$subjectFromWebIdentityToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assumedRoleUser?.hashCode() ?: 0
        result = 31 * result + (this.audience?.hashCode() ?: 0)
        result = 31 * result + (this.credentials?.hashCode() ?: 0)
        result = 31 * result + (this.packedPolicySize ?: 0)
        result = 31 * result + (this.provider?.hashCode() ?: 0)
        result = 31 * result + (this.sourceIdentity?.hashCode() ?: 0)
        result = 31 * result + (this.subjectFromWebIdentityToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssumeRoleWithWebIdentityResponse

        if (assumedRoleUser != other.assumedRoleUser) return false
        if (audience != other.audience) return false
        if (credentials != other.credentials) return false
        if (packedPolicySize != other.packedPolicySize) return false
        if (provider != other.provider) return false
        if (sourceIdentity != other.sourceIdentity) return false
        if (subjectFromWebIdentityToken != other.subjectFromWebIdentityToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleWithWebIdentityResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the `RoleSessionName` that you specified when you called `AssumeRole`.
         */
        public var assumedRoleUser: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser? = null
        /**
         * The intended audience (also known as client ID) of the web identity token. This is traditionally the client identifier issued to the application that requested the web identity token.
         */
        public var audience: kotlin.String? = null
        /**
         * The temporary security credentials, which include an access key ID, a secret access key, and a security token.
         *
         * The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.
         */
        public var credentials: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials? = null
        /**
         * A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.
         */
        public var packedPolicySize: kotlin.Int? = null
        /**
         * The issuing authority of the web identity token presented. For OpenID Connect ID tokens, this contains the value of the `iss` field. For OAuth 2.0 access tokens, this contains the value of the `ProviderId` parameter that was passed in the `AssumeRoleWithWebIdentity` request.
         */
        public var provider: kotlin.String? = null
        /**
         * The value of the source identity that is returned in the JSON web token (JWT) from the identity provider.
         *
         * You can require users to set a source identity value when they assume a role. You do this by using the `sts:SourceIdentity` condition key in a role trust policy. That way, actions that are taken with the role are associated with that user. After the source identity is set, the value cannot be changed. It is present in the request for all actions that are taken by the role and persists across [chained role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html#id_roles_terms-and-concepts) sessions. You can configure your identity provider to use an attribute associated with your users, like user name or email, as the source identity when calling `AssumeRoleWithWebIdentity`. You do this by adding a claim to the JSON web token. To learn more about OIDC tokens and claims, see [Using Tokens with User Pools](https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html) in the *Amazon Cognito Developer Guide*. For more information about using source identity, see [Monitor and control actions taken with assumed roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html) in the *IAM User Guide*.
         *
         * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
         */
        public var sourceIdentity: kotlin.String? = null
        /**
         * The unique user identifier that is returned by the identity provider. This identifier is associated with the `WebIdentityToken` that was submitted with the `AssumeRoleWithWebIdentity` call. The identifier is typically unique to the user and the application that acquired the `WebIdentityToken` (pairwise identifier). For OpenID Connect ID tokens, this field contains the value returned by the identity provider as the token's `sub` (Subject) claim.
         */
        public var subjectFromWebIdentityToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleWithWebIdentityResponse) : this() {
            this.assumedRoleUser = x.assumedRoleUser
            this.audience = x.audience
            this.credentials = x.credentials
            this.packedPolicySize = x.packedPolicySize
            this.provider = x.provider
            this.sourceIdentity = x.sourceIdentity
            this.subjectFromWebIdentityToken = x.subjectFromWebIdentityToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleWithWebIdentityResponse = AssumeRoleWithWebIdentityResponse(this)

        /**
         * construct an [aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser] inside the given [block]
         */
        public fun assumedRoleUser(block: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser.Builder.() -> kotlin.Unit) {
            this.assumedRoleUser = awsSdkKotlinRuntimeAuthCredentialsInternalStsModelAssumedRoleUserDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials] inside the given [block]
         */
        public fun credentials(block: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials.Builder.() -> kotlin.Unit) {
            this.credentials = awsSdkKotlinRuntimeAuthCredentialsInternalStsModelCredentialsDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
