/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.auth.credentials;

import aws.sdk.kotlin.runtime.auth.credentials.ECKeyData;
import aws.sdk.kotlin.runtime.auth.credentials.InvalidLoginTokenException;
import aws.sdk.kotlin.runtime.auth.credentials.LoginToken;
import aws.sdk.kotlin.runtime.auth.credentials.LoginTokenProviderKt;
import aws.sdk.kotlin.runtime.auth.credentials.ProviderConfigurationException;
import aws.sdk.kotlin.runtime.auth.credentials.SsoTokenProviderKt;
import aws.sdk.kotlin.runtime.config.profile.AwsConfigLoaderKt;
import aws.smithy.kotlin.runtime.hashing.EcdsaKt;
import aws.smithy.kotlin.runtime.hashing.Sha256Kt;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamReader;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamReaderKt;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamWriter;
import aws.smithy.kotlin.runtime.serde.json.JsonStreamWriterKt;
import aws.smithy.kotlin.runtime.serde.json.JsonToken;
import aws.smithy.kotlin.runtime.text.encoding.Base64Kt;
import aws.smithy.kotlin.runtime.text.encoding.HexKt;
import aws.smithy.kotlin.runtime.time.Clock;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import aws.smithy.kotlin.runtime.util.PlatformProvider;
import aws.smithy.kotlin.runtime.util.Uuid;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0002\u001a\u0018\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003H\u0002\u001a&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0080@\u00a2\u0006\u0002\u0010\u0012\u001a\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"DEFAULT_SIGNIN_TOKEN_REFRESH_BUFFER_SECONDS", "", "PROVIDER_NAME", "", "parseECKeyPem", "Laws/sdk/kotlin/runtime/auth/credentials/ECKeyData;", "pem", "padTo32", "", "generateDpopProof", "privateKeyPem", "endpoint", "readLoginTokenFromCache", "Laws/sdk/kotlin/runtime/auth/credentials/LoginToken;", "cacheKey", "platformProvider", "Laws/smithy/kotlin/runtime/util/PlatformProvider;", "cacheDirectory", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/util/PlatformProvider;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getLoginCacheFilename", "deserializeLoginToken", "json", "serializeLoginToken", "token", "aws-config"})
@SourceDebugExtension(value={"SMAP\nLoginTokenProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginTokenProvider.kt\naws/sdk/kotlin/runtime/auth/credentials/LoginTokenProviderKt\n+ 2 JsonStreamReader.kt\naws/smithy/kotlin/runtime/serde/json/JsonStreamReaderKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,453:1\n42#2,14:454\n42#2,14:468\n42#2,14:482\n42#2,14:496\n42#2,14:510\n42#2,14:524\n42#2,14:538\n42#2,14:552\n42#2,14:566\n42#2,14:580\n42#2,14:594\n42#2,14:608\n1#3:622\n*S KotlinDebug\n*F\n+ 1 LoginTokenProvider.kt\naws/sdk/kotlin/runtime/auth/credentials/LoginTokenProviderKt\n*L\n373#1:454,14\n380#1:468,14\n385#1:482,14\n386#1:496,14\n387#1:510,14\n388#1:524,14\n389#1:538,14\n396#1:552,14\n397#1:566,14\n398#1:580,14\n399#1:594,14\n400#1:608,14\n*E\n"})
public final class LoginTokenProviderKt {
    private static final int DEFAULT_SIGNIN_TOKEN_REFRESH_BUFFER_SECONDS = 300;
    @NotNull
    private static final String PROVIDER_NAME = "LOGIN";

    private static final ECKeyData parseECKeyPem(String pem) {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)pem, (String)"-----BEGIN EC PRIVATE KEY-----", (String)"", (boolean)false, (int)4, null), (String)"-----END EC PRIVATE KEY-----", (String)"", (boolean)false, (int)4, null);
        Regex regex = new Regex("\\s");
        String string = "";
        String base64 = StringsKt.replace$default((String)StringsKt.replace$default((String)regex.replace(charSequence, string), (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
        byte[] der = Base64Kt.decodeBase64Bytes((String)base64);
        byte[] d = ArraysKt.copyOfRange((byte[])der, (int)7, (int)39);
        int publicKeyStart = -1;
        int n = der.length;
        for (int i = 40; i < n; ++i) {
            if (der[i] != 4) continue;
            publicKeyStart = i + 1;
            break;
        }
        int remainingBytes = der.length - publicKeyStart;
        int coordLen = remainingBytes / 2;
        byte[] x = LoginTokenProviderKt.padTo32(ArraysKt.copyOfRange((byte[])der, (int)publicKeyStart, (int)(publicKeyStart + coordLen)));
        byte[] y = LoginTokenProviderKt.padTo32(ArraysKt.copyOfRange((byte[])der, (int)(publicKeyStart + coordLen), (int)(publicKeyStart + 2 * coordLen)));
        return new ECKeyData(d, x, y);
    }

    private static final byte[] padTo32(byte[] $this$padTo32) {
        if ($this$padTo32.length > 32) {
            throw new IllegalStateException(("Unexpected byte array of size " + $this$padTo32.length + "; expected 32 bytes or less").toString());
        }
        return ArraysKt.plus((byte[])new byte[32 - $this$padTo32.length], (byte[])$this$padTo32);
    }

    private static final String generateDpopProof(String privateKeyPem, String endpoint) {
        JsonStreamWriter jsonStreamWriter;
        ECKeyData ecKeyData = LoginTokenProviderKt.parseECKeyPem(privateKeyPem);
        Base64 base64UrlNoPadding = Base64.Default.getUrlSafe().withPadding(Base64.PaddingOption.ABSENT_OPTIONAL);
        JsonStreamWriter $this$generateDpopProof_u24lambda_u240 = jsonStreamWriter = JsonStreamWriterKt.jsonStreamWriter$default((boolean)false, (int)1, null);
        boolean bl = false;
        $this$generateDpopProof_u24lambda_u240.beginObject();
        $this$generateDpopProof_u24lambda_u240.writeName("typ");
        $this$generateDpopProof_u24lambda_u240.writeValue("dpop+jwt");
        $this$generateDpopProof_u24lambda_u240.writeName("alg");
        $this$generateDpopProof_u24lambda_u240.writeValue("ES256");
        $this$generateDpopProof_u24lambda_u240.writeName("jwk");
        $this$generateDpopProof_u24lambda_u240.beginObject();
        $this$generateDpopProof_u24lambda_u240.writeName("kty");
        $this$generateDpopProof_u24lambda_u240.writeValue("EC");
        $this$generateDpopProof_u24lambda_u240.writeName("x");
        $this$generateDpopProof_u24lambda_u240.writeValue(Base64.encode$default((Base64)base64UrlNoPadding, (byte[])ecKeyData.getX(), (int)0, (int)0, (int)6, null));
        $this$generateDpopProof_u24lambda_u240.writeName("y");
        $this$generateDpopProof_u24lambda_u240.writeValue(Base64.encode$default((Base64)base64UrlNoPadding, (byte[])ecKeyData.getY(), (int)0, (int)0, (int)6, null));
        $this$generateDpopProof_u24lambda_u240.writeName("crv");
        $this$generateDpopProof_u24lambda_u240.writeValue("P-256");
        $this$generateDpopProof_u24lambda_u240.endObject();
        $this$generateDpopProof_u24lambda_u240.endObject();
        byte[] header = jsonStreamWriter.getBytes();
        JsonStreamWriter $this$generateDpopProof_u24lambda_u241 = $this$generateDpopProof_u24lambda_u240 = JsonStreamWriterKt.jsonStreamWriter$default((boolean)false, (int)1, null);
        boolean bl2 = false;
        $this$generateDpopProof_u24lambda_u241.beginObject();
        $this$generateDpopProof_u24lambda_u241.writeName("jti");
        $this$generateDpopProof_u24lambda_u241.writeValue(Uuid.Companion.random().toString());
        $this$generateDpopProof_u24lambda_u241.writeName("htm");
        $this$generateDpopProof_u24lambda_u241.writeValue("POST");
        $this$generateDpopProof_u24lambda_u241.writeName("htu");
        $this$generateDpopProof_u24lambda_u241.writeValue(endpoint);
        $this$generateDpopProof_u24lambda_u241.writeName("iat");
        $this$generateDpopProof_u24lambda_u241.writeValue(Clock.System.INSTANCE.now().getEpochSeconds());
        $this$generateDpopProof_u24lambda_u241.endObject();
        byte[] payload = $this$generateDpopProof_u24lambda_u240.getBytes();
        Intrinsics.checkNotNull((Object)header);
        String headerEncoded = Base64.encode$default((Base64)base64UrlNoPadding, (byte[])header, (int)0, (int)0, (int)6, null);
        Intrinsics.checkNotNull((Object)payload);
        String payloadEncoded = Base64.encode$default((Base64)base64UrlNoPadding, (byte[])payload, (int)0, (int)0, (int)6, null);
        String message = headerEncoded + '.' + payloadEncoded;
        byte[] privateKeyBytes = ecKeyData.getD();
        byte[] signature = EcdsaKt.ecdsaSecp256r1Rs((byte[])privateKeyBytes, (byte[])StringsKt.encodeToByteArray((String)message));
        return message + '.' + Base64.encode$default((Base64)base64UrlNoPadding, (byte[])signature, (int)0, (int)0, (int)6, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readLoginTokenFromCache(@NotNull String cacheKey, @NotNull PlatformProvider platformProvider, @NotNull String cacheDirectory, @NotNull Continuation<? super LoginToken> $completion) {
        if (!($completion instanceof readLoginTokenFromCache.1)) ** GOTO lbl-1000
        var11_4 = $completion;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LoginTokenProviderKt.readLoginTokenFromCache(null, null, null, (Continuation<? super LoginToken>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                key = LoginTokenProviderKt.getLoginCacheFilename(cacheKey);
                $this$readLoginTokenFromCache_u24lambda_u242 = platformProvider;
                $i$a$-with-LoginTokenProviderKt$readLoginTokenFromCache$bytes$1 = 0;
                defaultCacheLocation = AwsConfigLoaderKt.normalizePath(cacheDirectory, $this$readLoginTokenFromCache_u24lambda_u242);
                var9_15 = new String[]{defaultCacheLocation, key};
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)cacheKey);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)platformProvider);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)cacheDirectory);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)key);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$readLoginTokenFromCache_u24lambda_u242);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)defaultCacheLocation);
                $continuation.I$0 = $i$a$-with-LoginTokenProviderKt$readLoginTokenFromCache$bytes$1;
                $continuation.label = 1;
                v0 = $this$readLoginTokenFromCache_u24lambda_u242.readFileOrNull(SsoTokenProviderKt.filepath($this$readLoginTokenFromCache_u24lambda_u242, var9_15), (Continuation)$continuation);
                if (v0 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl39
            }
            case 1: {
                $i$a$-with-LoginTokenProviderKt$readLoginTokenFromCache$bytes$1 = $continuation.I$0;
                defaultCacheLocation = (String)$continuation.L$5;
                $this$readLoginTokenFromCache_u24lambda_u242 = (PlatformProvider)$continuation.L$4;
                key = (String)$continuation.L$3;
                cacheDirectory = (String)$continuation.L$2;
                platformProvider = (PlatformProvider)$continuation.L$1;
                cacheKey = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl39:
                // 2 sources

                v1 = (byte[])v0;
                if (v1 == null) {
                    throw new ProviderConfigurationException("Invalid or missing login session cache. Run `aws login` to initiate a new session", null, 2, null);
                }
                bytes = v1;
                return LoginTokenProviderKt.deserializeLoginToken(bytes);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final String getLoginCacheFilename(@NotNull String cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        String sha256HexDigest = HexKt.encodeToHex((byte[])Sha256Kt.sha256((byte[])StringsKt.encodeToByteArray((String)((Object)StringsKt.trim((CharSequence)cacheKey)).toString())));
        return sha256HexDigest + ".json";
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final LoginToken deserializeLoginToken(@NotNull byte[] json) {
        void var7_8;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JsonStreamReader lexer = JsonStreamReaderKt.jsonStreamReader((byte[])json);
        String sessionToken = null;
        String accessKeyId = null;
        String secretAccessKey = null;
        String accountId = null;
        String tokenType = null;
        Object var7_7 = null;
        String refreshToken2 = null;
        String idToken = null;
        String clientId = null;
        String dpopKey = null;
        boolean hasAccessToken = false;
        try {
            JsonToken token2;
            JsonToken token$iv;
            JsonStreamReader $this$nextTokenOf$iv = lexer;
            boolean $i$f$nextTokenOf = false;
            JsonToken token$iv$iv = token$iv = $this$nextTokenOf$iv.nextToken();
            boolean $i$f$requireToken = false;
            if (token$iv$iv.getClass() != JsonToken.BeginObject.class) {
                throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.BeginObject.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv.getClass()));
            }
            JsonToken jsonToken = token$iv;
            if (jsonToken == null) {
                throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.BeginObject");
            }
            JsonToken cfr_ignored_0 = (JsonToken)((JsonToken.BeginObject)jsonToken);
            block32: while (!((token2 = lexer.nextToken()) instanceof JsonToken.EndObject)) {
                if (!(token2 instanceof JsonToken.Name)) throw new IllegalStateException("expected either key or end of object".toString());
                switch (((JsonToken.Name)token2).getValue()) {
                    case "accessToken": {
                        JsonToken nestedToken;
                        JsonToken token$iv2;
                        hasAccessToken = true;
                        JsonStreamReader $this$nextTokenOf$iv2 = lexer;
                        boolean $i$f$nextTokenOf2 = false;
                        JsonToken token$iv$iv2 = token$iv2 = $this$nextTokenOf$iv2.nextToken();
                        boolean $i$f$requireToken2 = false;
                        if (token$iv$iv2.getClass() != JsonToken.BeginObject.class) {
                            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.BeginObject.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv2.getClass()));
                        }
                        JsonToken jsonToken2 = token$iv2;
                        if (jsonToken2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.BeginObject");
                        }
                        JsonToken cfr_ignored_1 = (JsonToken)((JsonToken.BeginObject)jsonToken2);
                        block33: while (!((nestedToken = lexer.nextToken()) instanceof JsonToken.EndObject)) {
                            if (!(nestedToken instanceof JsonToken.Name)) throw new IllegalStateException("expected key or end of object in accessToken".toString());
                            switch (((JsonToken.Name)nestedToken).getValue()) {
                                case "accessKeyId": {
                                    JsonToken token$iv3;
                                    JsonStreamReader $this$nextTokenOf$iv3 = lexer;
                                    boolean $i$f$nextTokenOf3 = false;
                                    JsonToken token$iv$iv3 = token$iv3 = $this$nextTokenOf$iv3.nextToken();
                                    boolean $i$f$requireToken3 = false;
                                    if (token$iv$iv3.getClass() != JsonToken.String.class) {
                                        throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv3.getClass()));
                                    }
                                    JsonToken jsonToken3 = token$iv3;
                                    if (jsonToken3 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                                    }
                                    accessKeyId = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken3))).getValue();
                                    continue block33;
                                }
                                case "secretAccessKey": {
                                    JsonToken token$iv4;
                                    JsonStreamReader $this$nextTokenOf$iv3 = lexer;
                                    boolean $i$f$nextTokenOf4 = false;
                                    JsonToken token$iv$iv3 = token$iv4 = $this$nextTokenOf$iv3.nextToken();
                                    boolean $i$f$requireToken3 = false;
                                    if (token$iv$iv3.getClass() != JsonToken.String.class) {
                                        throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv3.getClass()));
                                    }
                                    JsonToken jsonToken4 = token$iv4;
                                    if (jsonToken4 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                                    }
                                    secretAccessKey = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken4))).getValue();
                                    continue block33;
                                }
                                case "sessionToken": {
                                    JsonToken token$iv5;
                                    JsonStreamReader $this$nextTokenOf$iv3 = lexer;
                                    boolean $i$f$nextTokenOf5 = false;
                                    JsonToken token$iv$iv3 = token$iv5 = $this$nextTokenOf$iv3.nextToken();
                                    boolean $i$f$requireToken3 = false;
                                    if (token$iv$iv3.getClass() != JsonToken.String.class) {
                                        throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv3.getClass()));
                                    }
                                    JsonToken jsonToken5 = token$iv5;
                                    if (jsonToken5 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                                    }
                                    sessionToken = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken5))).getValue();
                                    continue block33;
                                }
                                case "expiresAt": {
                                    JsonToken token$iv6;
                                    JsonStreamReader $this$nextTokenOf$iv3 = lexer;
                                    boolean $i$f$nextTokenOf6 = false;
                                    JsonToken token$iv$iv3 = token$iv6 = $this$nextTokenOf$iv3.nextToken();
                                    boolean $i$f$requireToken3 = false;
                                    if (token$iv$iv3.getClass() != JsonToken.String.class) {
                                        throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv3.getClass()));
                                    }
                                    JsonToken jsonToken6 = token$iv6;
                                    if (jsonToken6 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                                    }
                                    String string = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken6))).getValue();
                                    continue block33;
                                }
                                case "accountId": {
                                    JsonToken token$iv7;
                                    JsonStreamReader $this$nextTokenOf$iv3 = lexer;
                                    boolean $i$f$nextTokenOf7 = false;
                                    JsonToken token$iv$iv3 = token$iv7 = $this$nextTokenOf$iv3.nextToken();
                                    boolean $i$f$requireToken3 = false;
                                    if (token$iv$iv3.getClass() != JsonToken.String.class) {
                                        throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv3.getClass()));
                                    }
                                    JsonToken jsonToken7 = token$iv7;
                                    if (jsonToken7 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                                    }
                                    accountId = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken7))).getValue();
                                    continue block33;
                                }
                            }
                            lexer.skipNext();
                        }
                        continue block32;
                    }
                    case "tokenType": {
                        JsonToken token$iv8;
                        JsonStreamReader $this$nextTokenOf$iv2 = lexer;
                        boolean $i$f$nextTokenOf8 = false;
                        JsonToken token$iv$iv2 = token$iv8 = $this$nextTokenOf$iv2.nextToken();
                        boolean $i$f$requireToken2 = false;
                        if (token$iv$iv2.getClass() != JsonToken.String.class) {
                            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv2.getClass()));
                        }
                        JsonToken jsonToken8 = token$iv8;
                        if (jsonToken8 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                        }
                        tokenType = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken8))).getValue();
                        continue block32;
                    }
                    case "refreshToken": {
                        JsonToken token$iv9;
                        JsonStreamReader $this$nextTokenOf$iv2 = lexer;
                        boolean $i$f$nextTokenOf9 = false;
                        JsonToken token$iv$iv2 = token$iv9 = $this$nextTokenOf$iv2.nextToken();
                        boolean $i$f$requireToken2 = false;
                        if (token$iv$iv2.getClass() != JsonToken.String.class) {
                            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv2.getClass()));
                        }
                        JsonToken jsonToken9 = token$iv9;
                        if (jsonToken9 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                        }
                        refreshToken2 = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken9))).getValue();
                        continue block32;
                    }
                    case "idToken": {
                        JsonToken token$iv10;
                        JsonStreamReader $this$nextTokenOf$iv2 = lexer;
                        boolean $i$f$nextTokenOf10 = false;
                        JsonToken token$iv$iv2 = token$iv10 = $this$nextTokenOf$iv2.nextToken();
                        boolean $i$f$requireToken2 = false;
                        if (token$iv$iv2.getClass() != JsonToken.String.class) {
                            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv2.getClass()));
                        }
                        JsonToken jsonToken10 = token$iv10;
                        if (jsonToken10 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                        }
                        idToken = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken10))).getValue();
                        continue block32;
                    }
                    case "clientId": {
                        JsonToken token$iv11;
                        JsonStreamReader $this$nextTokenOf$iv2 = lexer;
                        boolean $i$f$nextTokenOf11 = false;
                        JsonToken token$iv$iv2 = token$iv11 = $this$nextTokenOf$iv2.nextToken();
                        boolean $i$f$requireToken2 = false;
                        if (token$iv$iv2.getClass() != JsonToken.String.class) {
                            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv2.getClass()));
                        }
                        JsonToken jsonToken11 = token$iv11;
                        if (jsonToken11 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                        }
                        clientId = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken11))).getValue();
                        continue block32;
                    }
                    case "dpopKey": {
                        JsonToken token$iv12;
                        JsonStreamReader $this$nextTokenOf$iv2 = lexer;
                        boolean $i$f$nextTokenOf12 = false;
                        JsonToken token$iv$iv2 = token$iv12 = $this$nextTokenOf$iv2.nextToken();
                        boolean $i$f$requireToken2 = false;
                        if (token$iv$iv2.getClass() != JsonToken.String.class) {
                            throw new DeserializationException("expected " + Reflection.getOrCreateKotlinClass(JsonToken.String.class) + "; found " + Reflection.getOrCreateKotlinClass(token$iv$iv2.getClass()));
                        }
                        JsonToken jsonToken12 = token$iv12;
                        if (jsonToken12 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type aws.smithy.kotlin.runtime.serde.json.JsonToken.String");
                        }
                        dpopKey = ((JsonToken.String)((JsonToken)((JsonToken.String)jsonToken12))).getValue();
                        continue block32;
                    }
                }
                lexer.skipNext();
            }
        }
        catch (Exception ex) {
            throw new InvalidLoginTokenException("invalid cached login token", ex);
        }
        if (!hasAccessToken) {
            throw new InvalidLoginTokenException("missing `accessToken`", null, 2, null);
        }
        if (accessKeyId == null) {
            throw new InvalidLoginTokenException("missing `accessKeyId`", null, 2, null);
        }
        if (secretAccessKey == null) {
            throw new InvalidLoginTokenException("missing `secretAccessKey`", null, 2, null);
        }
        if (sessionToken == null) {
            throw new InvalidLoginTokenException("missing `sessionToken`", null, 2, null);
        }
        if (accountId == null) {
            throw new InvalidLoginTokenException("missing `accountId`", null, 2, null);
        }
        Instant instant = var7_8;
        if (instant == null) throw new InvalidLoginTokenException("missing `expiresAt`", null, 2, null);
        void it = instant;
        boolean bl = false;
        Instant instant2 = Instant.Companion.fromIso8601((String)it);
        instant = instant2;
        if (instant2 == null) {
            throw new InvalidLoginTokenException("missing `expiresAt`", null, 2, null);
        }
        Instant expiresAt = instant;
        if (clientId == null) {
            throw new InvalidLoginTokenException("missing `clientId`", null, 2, null);
        }
        if (refreshToken2 == null) {
            throw new InvalidLoginTokenException("missing `refreshToken`", null, 2, null);
        }
        if (dpopKey != null) return new LoginToken(accessKeyId, secretAccessKey, sessionToken, accountId, tokenType, expiresAt, refreshToken2, idToken, clientId, dpopKey);
        throw new InvalidLoginTokenException("missing `dpopKey`", null, 2, null);
    }

    @NotNull
    public static final byte[] serializeLoginToken(@NotNull LoginToken token2) {
        JsonStreamWriter jsonStreamWriter;
        Intrinsics.checkNotNullParameter((Object)token2, (String)"token");
        JsonStreamWriter $this$serializeLoginToken_u24lambda_u244 = jsonStreamWriter = JsonStreamWriterKt.jsonStreamWriter((boolean)true);
        boolean bl = false;
        $this$serializeLoginToken_u24lambda_u244.beginObject();
        $this$serializeLoginToken_u24lambda_u244.writeName("accessToken");
        $this$serializeLoginToken_u24lambda_u244.beginObject();
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "accessKeyId", token2.getAccessKeyId());
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "secretAccessKey", token2.getSecretAccessKey());
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "sessionToken", token2.getSessionToken());
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "accountId", token2.getAccountId());
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "expiresAt", token2.getExpiresAt().format(TimestampFormat.ISO_8601));
        $this$serializeLoginToken_u24lambda_u244.endObject();
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "tokenType", token2.getTokenType());
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "refreshToken", token2.getRefreshToken());
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "idToken", token2.getIdToken());
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "clientId", token2.getClientId());
        SsoTokenProviderKt.writeNotNull($this$serializeLoginToken_u24lambda_u244, "dpopKey", token2.getDpopKey());
        $this$serializeLoginToken_u24lambda_u244.endObject();
        byte[] byArray = jsonStreamWriter.getBytes();
        if (byArray == null) {
            throw new IllegalStateException("serializing LoginToken failed".toString());
        }
        return byArray;
    }

    public static final /* synthetic */ String access$generateDpopProof(String privateKeyPem, String endpoint) {
        return LoginTokenProviderKt.generateDpopProof(privateKeyPem, endpoint);
    }
}

