// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.model



/**
 * Contains the content of a document.
 */
public sealed class DocumentSource {
    /**
     * The raw bytes for the document. If you use an Amazon Web Services SDK, you don't need to encode the bytes in base64.
     */
    public data class Bytes(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.bedrockruntime.model.DocumentSource() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as Bytes

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }

    /**
     * The structured content of the document source, which may include various content blocks such as text, images, or other document elements.
     */
    public data class Content(val value: kotlin.collections.List<aws.sdk.kotlin.services.bedrockruntime.model.DocumentContentBlock>) : aws.sdk.kotlin.services.bedrockruntime.model.DocumentSource() {
    }

    /**
     * The location of a document object in an Amazon S3 bucket. To see which models support S3 uploads, see [Supported models and features for Converse](https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-supported-models-features.html).
     */
    public data class S3Location(val value: aws.sdk.kotlin.services.bedrockruntime.model.S3Location) : aws.sdk.kotlin.services.bedrockruntime.model.DocumentSource() {
    }

    /**
     * The text content of the document source.
     */
    public data class Text(val value: kotlin.String) : aws.sdk.kotlin.services.bedrockruntime.model.DocumentSource() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.bedrockruntime.model.DocumentSource() {
    }

    /**
     * Casts this [DocumentSource] as a [Bytes] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [DocumentSource] is not a
     * [Bytes].
     */
    public fun asBytes(): kotlin.ByteArray = (this as DocumentSource.Bytes).value

    /**
     * Casts this [DocumentSource] as a [Bytes] and retrieves its [kotlin.ByteArray] value. Returns null if the [DocumentSource] is not a [Bytes].
     */
    public fun asBytesOrNull(): kotlin.ByteArray? = (this as? DocumentSource.Bytes)?.value

    /**
     * Casts this [DocumentSource] as a [Content] and retrieves its [kotlin.collections.List<aws.sdk.kotlin.services.bedrockruntime.model.DocumentContentBlock>] value. Throws an exception if the [DocumentSource] is not a
     * [Content].
     */
    public fun asContent(): kotlin.collections.List<aws.sdk.kotlin.services.bedrockruntime.model.DocumentContentBlock> = (this as DocumentSource.Content).value

    /**
     * Casts this [DocumentSource] as a [Content] and retrieves its [kotlin.collections.List<aws.sdk.kotlin.services.bedrockruntime.model.DocumentContentBlock>] value. Returns null if the [DocumentSource] is not a [Content].
     */
    public fun asContentOrNull(): kotlin.collections.List<aws.sdk.kotlin.services.bedrockruntime.model.DocumentContentBlock>? = (this as? DocumentSource.Content)?.value

    /**
     * Casts this [DocumentSource] as a [S3Location] and retrieves its [aws.sdk.kotlin.services.bedrockruntime.model.S3Location] value. Throws an exception if the [DocumentSource] is not a
     * [S3Location].
     */
    public fun asS3Location(): aws.sdk.kotlin.services.bedrockruntime.model.S3Location = (this as DocumentSource.S3Location).value

    /**
     * Casts this [DocumentSource] as a [S3Location] and retrieves its [aws.sdk.kotlin.services.bedrockruntime.model.S3Location] value. Returns null if the [DocumentSource] is not a [S3Location].
     */
    public fun asS3LocationOrNull(): aws.sdk.kotlin.services.bedrockruntime.model.S3Location? = (this as? DocumentSource.S3Location)?.value

    /**
     * Casts this [DocumentSource] as a [Text] and retrieves its [kotlin.String] value. Throws an exception if the [DocumentSource] is not a
     * [Text].
     */
    public fun asText(): kotlin.String = (this as DocumentSource.Text).value

    /**
     * Casts this [DocumentSource] as a [Text] and retrieves its [kotlin.String] value. Returns null if the [DocumentSource] is not a [Text].
     */
    public fun asTextOrNull(): kotlin.String? = (this as? DocumentSource.Text)?.value
}
