// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration information for a guardrail that you use with the ConverseStream action.
 */
public class GuardrailStreamConfiguration private constructor(builder: Builder) {
    /**
     * The identifier for the guardrail.
     */
    public val guardrailIdentifier: kotlin.String = requireNotNull(builder.guardrailIdentifier) { "A non-null value must be provided for guardrailIdentifier" }
    /**
     * The version of the guardrail.
     */
    public val guardrailVersion: kotlin.String = requireNotNull(builder.guardrailVersion) { "A non-null value must be provided for guardrailVersion" }
    /**
     * The processing mode.
     *
     * The processing mode. For more information, see *Configure streaming response behavior* in the *Amazon Bedrock User Guide*.
     */
    public val streamProcessingMode: aws.sdk.kotlin.services.bedrockruntime.model.GuardrailStreamProcessingMode = builder.streamProcessingMode
    /**
     * The trace behavior for the guardrail.
     */
    public val trace: aws.sdk.kotlin.services.bedrockruntime.model.GuardrailTrace = builder.trace

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockruntime.model.GuardrailStreamConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GuardrailStreamConfiguration(")
        append("guardrailIdentifier=$guardrailIdentifier,")
        append("guardrailVersion=$guardrailVersion,")
        append("streamProcessingMode=$streamProcessingMode,")
        append("trace=$trace")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = guardrailIdentifier.hashCode()
        result = 31 * result + (guardrailVersion.hashCode())
        result = 31 * result + (streamProcessingMode.hashCode())
        result = 31 * result + (trace.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GuardrailStreamConfiguration

        if (guardrailIdentifier != other.guardrailIdentifier) return false
        if (guardrailVersion != other.guardrailVersion) return false
        if (streamProcessingMode != other.streamProcessingMode) return false
        if (trace != other.trace) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockruntime.model.GuardrailStreamConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The identifier for the guardrail.
         */
        public var guardrailIdentifier: kotlin.String? = null
        /**
         * The version of the guardrail.
         */
        public var guardrailVersion: kotlin.String? = null
        /**
         * The processing mode.
         *
         * The processing mode. For more information, see *Configure streaming response behavior* in the *Amazon Bedrock User Guide*.
         */
        public var streamProcessingMode: aws.sdk.kotlin.services.bedrockruntime.model.GuardrailStreamProcessingMode = aws.sdk.kotlin.services.bedrockruntime.model.GuardrailStreamProcessingMode.fromValue("sync")
        /**
         * The trace behavior for the guardrail.
         */
        public var trace: aws.sdk.kotlin.services.bedrockruntime.model.GuardrailTrace = aws.sdk.kotlin.services.bedrockruntime.model.GuardrailTrace.fromValue("disabled")

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockruntime.model.GuardrailStreamConfiguration) : this() {
            this.guardrailIdentifier = x.guardrailIdentifier
            this.guardrailVersion = x.guardrailVersion
            this.streamProcessingMode = x.streamProcessingMode
            this.trace = x.trace
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockruntime.model.GuardrailStreamConfiguration = GuardrailStreamConfiguration(this)

        internal fun correctErrors(): Builder {
            if (guardrailIdentifier == null) guardrailIdentifier = ""
            if (guardrailVersion == null) guardrailVersion = ""
            return this
        }
    }
}
