// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.model



/**
 * The source for an image.
 */
public sealed class ImageSource {
    /**
     * The raw image bytes for the image. If you use an AWS SDK, you don't need to encode the image bytes in base64.
     */
    public data class Bytes(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.bedrockruntime.model.ImageSource() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as Bytes

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }

    /**
     * The location of an image object in an Amazon S3 bucket. To see which models support S3 uploads, see [Supported models and features for Converse](https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-supported-models-features.html).
     */
    public data class S3Location(val value: aws.sdk.kotlin.services.bedrockruntime.model.S3Location) : aws.sdk.kotlin.services.bedrockruntime.model.ImageSource() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.bedrockruntime.model.ImageSource() {
    }

    /**
     * Casts this [ImageSource] as a [Bytes] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [ImageSource] is not a
     * [Bytes].
     */
    public fun asBytes(): kotlin.ByteArray = (this as ImageSource.Bytes).value

    /**
     * Casts this [ImageSource] as a [Bytes] and retrieves its [kotlin.ByteArray] value. Returns null if the [ImageSource] is not a [Bytes].
     */
    public fun asBytesOrNull(): kotlin.ByteArray? = (this as? ImageSource.Bytes)?.value

    /**
     * Casts this [ImageSource] as a [S3Location] and retrieves its [aws.sdk.kotlin.services.bedrockruntime.model.S3Location] value. Throws an exception if the [ImageSource] is not a
     * [S3Location].
     */
    public fun asS3Location(): aws.sdk.kotlin.services.bedrockruntime.model.S3Location = (this as ImageSource.S3Location).value

    /**
     * Casts this [ImageSource] as a [S3Location] and retrieves its [aws.sdk.kotlin.services.bedrockruntime.model.S3Location] value. Returns null if the [ImageSource] is not a [S3Location].
     */
    public fun asS3LocationOrNull(): aws.sdk.kotlin.services.bedrockruntime.model.S3Location? = (this as? ImageSource.S3Location)?.value
}
