// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Base inference parameters to pass to a model in a call to [Converse](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html) or [ConverseStream](https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html). For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
 *
 * If you need to pass additional parameters that the model supports, use the `additionalModelRequestFields` request field in the call to `Converse` or `ConverseStream`. For more information, see [Model parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
 */
public class InferenceConfiguration private constructor(builder: Builder) {
    /**
     * The maximum number of tokens to allow in the generated response. The default value is the maximum allowed value for the model that you are using. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
     */
    public val maxTokens: kotlin.Int? = builder.maxTokens
    /**
     * A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.
     */
    public val stopSequences: List<String>? = builder.stopSequences
    /**
     * The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.
     *
     * The default value is the default value for the model that you are using. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
     */
    public val temperature: kotlin.Float? = builder.temperature
    /**
     * The percentage of most-likely candidates that the model considers for the next token. For example, if you choose a value of 0.8 for `topP`, the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.
     *
     * The default value is the default value for the model that you are using. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
     */
    public val topP: kotlin.Float? = builder.topP

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockruntime.model.InferenceConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InferenceConfiguration(")
        append("maxTokens=$maxTokens,")
        append("stopSequences=$stopSequences,")
        append("temperature=$temperature,")
        append("topP=$topP")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = maxTokens ?: 0
        result = 31 * result + (stopSequences?.hashCode() ?: 0)
        result = 31 * result + (temperature?.hashCode() ?: 0)
        result = 31 * result + (topP?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InferenceConfiguration

        if (maxTokens != other.maxTokens) return false
        if (stopSequences != other.stopSequences) return false
        if (!(temperature?.equals(other.temperature) ?: (other.temperature == null))) return false
        if (!(topP?.equals(other.topP) ?: (other.topP == null))) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockruntime.model.InferenceConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of tokens to allow in the generated response. The default value is the maximum allowed value for the model that you are using. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
         */
        public var maxTokens: kotlin.Int? = null
        /**
         * A list of stop sequences. A stop sequence is a sequence of characters that causes the model to stop generating the response.
         */
        public var stopSequences: List<String>? = null
        /**
         * The likelihood of the model selecting higher-probability options while generating a response. A lower value makes the model more likely to choose higher-probability options, while a higher value makes the model more likely to choose lower-probability options.
         *
         * The default value is the default value for the model that you are using. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
         */
        public var temperature: kotlin.Float? = null
        /**
         * The percentage of most-likely candidates that the model considers for the next token. For example, if you choose a value of 0.8 for `topP`, the model selects from the top 80% of the probability distribution of tokens that could be next in the sequence.
         *
         * The default value is the default value for the model that you are using. For more information, see [Inference parameters for foundation models](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
         */
        public var topP: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockruntime.model.InferenceConfiguration) : this() {
            this.maxTokens = x.maxTokens
            this.stopSequences = x.stopSequences
            this.temperature = x.temperature
            this.topP = x.topP
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockruntime.model.InferenceConfiguration = InferenceConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
