// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.model

import aws.smithy.kotlin.runtime.SdkDsl

public class InvokeModelResponse private constructor(builder: Builder) {
    /**
     * Inference response from the model in the format specified in the `contentType` header. To see the format and content of the request and response bodies for different models, refer to [Inference parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
     */
    public val body: kotlin.ByteArray = requireNotNull(builder.body) { "A non-null value must be provided for body" }
    /**
     * The MIME type of the inference result.
     */
    public val contentType: kotlin.String = requireNotNull(builder.contentType) { "A non-null value must be provided for contentType" }
    /**
     * Model performance settings for the request.
     */
    public val performanceConfigLatency: aws.sdk.kotlin.services.bedrockruntime.model.PerformanceConfigLatency? = builder.performanceConfigLatency

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.bedrockruntime.model.InvokeModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InvokeModelResponse(")
        append("body=*** Sensitive Data Redacted ***,")
        append("contentType=$contentType,")
        append("performanceConfigLatency=$performanceConfigLatency")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body.contentHashCode()
        result = 31 * result + (contentType.hashCode())
        result = 31 * result + (performanceConfigLatency?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InvokeModelResponse

        if (!body.contentEquals(other.body)) return false
        if (contentType != other.contentType) return false
        if (performanceConfigLatency != other.performanceConfigLatency) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.bedrockruntime.model.InvokeModelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Inference response from the model in the format specified in the `contentType` header. To see the format and content of the request and response bodies for different models, refer to [Inference parameters](https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html).
         */
        public var body: kotlin.ByteArray? = null
        /**
         * The MIME type of the inference result.
         */
        public var contentType: kotlin.String? = null
        /**
         * Model performance settings for the request.
         */
        public var performanceConfigLatency: aws.sdk.kotlin.services.bedrockruntime.model.PerformanceConfigLatency? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.bedrockruntime.model.InvokeModelResponse) : this() {
            this.body = x.body
            this.contentType = x.contentType
            this.performanceConfigLatency = x.performanceConfigLatency
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.bedrockruntime.model.InvokeModelResponse = InvokeModelResponse(this)

        internal fun correctErrors(): Builder {
            if (body == null) body = ByteArray(0)
            if (contentType == null) contentType = ""
            return this
        }
    }
}
