// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.model



/**
 * Contains content regarding the reasoning that is carried out by the model with respect to the content in the content block. Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance the accuracy of its final response.
 */
public sealed class ReasoningContentBlock {
    /**
     * The reasoning that the model used to return the output.
     */
    public data class ReasoningText(val value: aws.sdk.kotlin.services.bedrockruntime.model.ReasoningTextBlock) : aws.sdk.kotlin.services.bedrockruntime.model.ReasoningContentBlock() {
        override fun toString(): kotlin.String = "ReasoningContentBlock(*** Sensitive Data Redacted ***)"
    }

    /**
     * The content in the reasoning that was encrypted by the model provider for safety reasons. The encryption doesn't affect the quality of responses.
     */
    public data class RedactedContent(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.bedrockruntime.model.ReasoningContentBlock() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as RedactedContent

            if (!value.contentEquals(other.value)) return false

            return true
        }
        override fun toString(): kotlin.String = "ReasoningContentBlock(*** Sensitive Data Redacted ***)"
    }

    public object SdkUnknown : aws.sdk.kotlin.services.bedrockruntime.model.ReasoningContentBlock() {
        override fun toString(): kotlin.String = "ReasoningContentBlock(*** Sensitive Data Redacted ***)"
    }

    /**
     * Casts this [ReasoningContentBlock] as a [ReasoningText] and retrieves its [aws.sdk.kotlin.services.bedrockruntime.model.ReasoningTextBlock] value. Throws an exception if the [ReasoningContentBlock] is not a
     * [ReasoningText].
     */
    public fun asReasoningText(): aws.sdk.kotlin.services.bedrockruntime.model.ReasoningTextBlock = (this as ReasoningContentBlock.ReasoningText).value

    /**
     * Casts this [ReasoningContentBlock] as a [ReasoningText] and retrieves its [aws.sdk.kotlin.services.bedrockruntime.model.ReasoningTextBlock] value. Returns null if the [ReasoningContentBlock] is not a [ReasoningText].
     */
    public fun asReasoningTextOrNull(): aws.sdk.kotlin.services.bedrockruntime.model.ReasoningTextBlock? = (this as? ReasoningContentBlock.ReasoningText)?.value

    /**
     * Casts this [ReasoningContentBlock] as a [RedactedContent] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [ReasoningContentBlock] is not a
     * [RedactedContent].
     */
    public fun asRedactedContent(): kotlin.ByteArray = (this as ReasoningContentBlock.RedactedContent).value

    /**
     * Casts this [ReasoningContentBlock] as a [RedactedContent] and retrieves its [kotlin.ByteArray] value. Returns null if the [ReasoningContentBlock] is not a [RedactedContent].
     */
    public fun asRedactedContentOrNull(): kotlin.ByteArray? = (this as? ReasoningContentBlock.RedactedContent)?.value
}
