// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.model



/**
 * Contains content regarding the reasoning that is carried out by the model with respect to the content in the content block. Reasoning refers to a Chain of Thought (CoT) that the model generates to enhance the accuracy of its final response.
 */
public sealed class ReasoningContentBlockDelta {
    /**
     * The content in the reasoning that was encrypted by the model provider for safety reasons. The encryption doesn't affect the quality of responses.
     */
    public data class RedactedContent(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.bedrockruntime.model.ReasoningContentBlockDelta() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as RedactedContent

            if (!value.contentEquals(other.value)) return false

            return true
        }
        override fun toString(): kotlin.String = "ReasoningContentBlockDelta(*** Sensitive Data Redacted ***)"
    }

    /**
     * A token that verifies that the reasoning text was generated by the model. If you pass a reasoning block back to the API in a multi-turn conversation, include the text and its signature unmodified.
     */
    public data class Signature(val value: kotlin.String) : aws.sdk.kotlin.services.bedrockruntime.model.ReasoningContentBlockDelta() {
        override fun toString(): kotlin.String = "ReasoningContentBlockDelta(*** Sensitive Data Redacted ***)"
    }

    /**
     * The reasoning that the model used to return the output.
     */
    public data class Text(val value: kotlin.String) : aws.sdk.kotlin.services.bedrockruntime.model.ReasoningContentBlockDelta() {
        override fun toString(): kotlin.String = "ReasoningContentBlockDelta(*** Sensitive Data Redacted ***)"
    }

    public object SdkUnknown : aws.sdk.kotlin.services.bedrockruntime.model.ReasoningContentBlockDelta() {
        override fun toString(): kotlin.String = "ReasoningContentBlockDelta(*** Sensitive Data Redacted ***)"
    }

    /**
     * Casts this [ReasoningContentBlockDelta] as a [RedactedContent] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [ReasoningContentBlockDelta] is not a
     * [RedactedContent].
     */
    public fun asRedactedContent(): kotlin.ByteArray = (this as ReasoningContentBlockDelta.RedactedContent).value

    /**
     * Casts this [ReasoningContentBlockDelta] as a [RedactedContent] and retrieves its [kotlin.ByteArray] value. Returns null if the [ReasoningContentBlockDelta] is not a [RedactedContent].
     */
    public fun asRedactedContentOrNull(): kotlin.ByteArray? = (this as? ReasoningContentBlockDelta.RedactedContent)?.value

    /**
     * Casts this [ReasoningContentBlockDelta] as a [Signature] and retrieves its [kotlin.String] value. Throws an exception if the [ReasoningContentBlockDelta] is not a
     * [Signature].
     */
    public fun asSignature(): kotlin.String = (this as ReasoningContentBlockDelta.Signature).value

    /**
     * Casts this [ReasoningContentBlockDelta] as a [Signature] and retrieves its [kotlin.String] value. Returns null if the [ReasoningContentBlockDelta] is not a [Signature].
     */
    public fun asSignatureOrNull(): kotlin.String? = (this as? ReasoningContentBlockDelta.Signature)?.value

    /**
     * Casts this [ReasoningContentBlockDelta] as a [Text] and retrieves its [kotlin.String] value. Throws an exception if the [ReasoningContentBlockDelta] is not a
     * [Text].
     */
    public fun asText(): kotlin.String = (this as ReasoningContentBlockDelta.Text).value

    /**
     * Casts this [ReasoningContentBlockDelta] as a [Text] and retrieves its [kotlin.String] value. Returns null if the [ReasoningContentBlockDelta] is not a [Text].
     */
    public fun asTextOrNull(): kotlin.String? = (this as? ReasoningContentBlockDelta.Text)?.value
}
