// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.model



/**
 * A video source. You can upload a smaller video as a base64-encoded string as long as the encoded file is less than 25MB. You can also transfer videos up to 1GB in size from an S3 bucket.
 */
public sealed class VideoSource {
    /**
     * Video content encoded in base64.
     */
    public data class Bytes(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.bedrockruntime.model.VideoSource() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as Bytes

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }

    /**
     * The location of a video object in an Amazon S3 bucket. To see which models support S3 uploads, see [Supported models and features for Converse](https://docs.aws.amazon.com/bedrock/latest/userguide/conversation-inference-supported-models-features.html).
     */
    public data class S3Location(val value: aws.sdk.kotlin.services.bedrockruntime.model.S3Location) : aws.sdk.kotlin.services.bedrockruntime.model.VideoSource() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.bedrockruntime.model.VideoSource() {
    }

    /**
     * Casts this [VideoSource] as a [Bytes] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [VideoSource] is not a
     * [Bytes].
     */
    public fun asBytes(): kotlin.ByteArray = (this as VideoSource.Bytes).value

    /**
     * Casts this [VideoSource] as a [Bytes] and retrieves its [kotlin.ByteArray] value. Returns null if the [VideoSource] is not a [Bytes].
     */
    public fun asBytesOrNull(): kotlin.ByteArray? = (this as? VideoSource.Bytes)?.value

    /**
     * Casts this [VideoSource] as a [S3Location] and retrieves its [aws.sdk.kotlin.services.bedrockruntime.model.S3Location] value. Throws an exception if the [VideoSource] is not a
     * [S3Location].
     */
    public fun asS3Location(): aws.sdk.kotlin.services.bedrockruntime.model.S3Location = (this as VideoSource.S3Location).value

    /**
     * Casts this [VideoSource] as a [S3Location] and retrieves its [aws.sdk.kotlin.services.bedrockruntime.model.S3Location] value. Returns null if the [VideoSource] is not a [S3Location].
     */
    public fun asS3LocationOrNull(): aws.sdk.kotlin.services.bedrockruntime.model.S3Location? = (this as? VideoSource.S3Location)?.value
}
