// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.paginators

import aws.sdk.kotlin.services.bedrockruntime.BedrockRuntimeClient
import aws.sdk.kotlin.services.bedrockruntime.model.AsyncInvokeSummary
import aws.sdk.kotlin.services.bedrockruntime.model.ListAsyncInvokesRequest
import aws.sdk.kotlin.services.bedrockruntime.model.ListAsyncInvokesResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAsyncInvokesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAsyncInvokesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAsyncInvokesResponse]
 */
public fun BedrockRuntimeClient.listAsyncInvokesPaginated(initialRequest: ListAsyncInvokesRequest = ListAsyncInvokesRequest { }): Flow<ListAsyncInvokesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAsyncInvokesPaginated.listAsyncInvokes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAsyncInvokesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAsyncInvokesResponse]
 */
public fun BedrockRuntimeClient.listAsyncInvokesPaginated(block: ListAsyncInvokesRequest.Builder.() -> Unit): Flow<ListAsyncInvokesResponse> =
    listAsyncInvokesPaginated(ListAsyncInvokesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAsyncInvokesPaginated]
 * to access the nested member [AsyncInvokeSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AsyncInvokeSummary]
 */
@JvmName("listAsyncInvokesResponseAsyncInvokeSummary")
public fun Flow<ListAsyncInvokesResponse>.asyncInvokeSummaries(): Flow<AsyncInvokeSummary> =
    transform() { response ->
        response.asyncInvokeSummaries?.forEach {
            emit(it)
        }
    }
