// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.serde

import aws.sdk.kotlin.services.bedrockruntime.model.ApplyGuardrailResponse
import aws.sdk.kotlin.services.bedrockruntime.model.BedrockRuntimeException
import aws.sdk.kotlin.services.bedrockruntime.model.GuardrailAction
import aws.sdk.kotlin.services.bedrockruntime.model.GuardrailAssessment
import aws.sdk.kotlin.services.bedrockruntime.model.GuardrailCoverage
import aws.sdk.kotlin.services.bedrockruntime.model.GuardrailOutputContent
import aws.sdk.kotlin.services.bedrockruntime.model.GuardrailUsage
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ApplyGuardrailOperationDeserializer: HttpDeserializer.NonStreaming<ApplyGuardrailResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ApplyGuardrailResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwApplyGuardrailError(context, call, payload)
        }
        val builder = ApplyGuardrailResponse.Builder()

        if (payload != null) {
            deserializeApplyGuardrailOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwApplyGuardrailError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeApplyGuardrailOperationBody(builder: ApplyGuardrailResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("action"))
    val ACTIONREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("actionReason"))
    val ASSESSMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("assessments"))
    val GUARDRAILCOVERAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("guardrailCoverage"))
    val OUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputs"))
    val USAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("usage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTION_DESCRIPTOR)
        field(ACTIONREASON_DESCRIPTOR)
        field(ASSESSMENTS_DESCRIPTOR)
        field(GUARDRAILCOVERAGE_DESCRIPTOR)
        field(OUTPUTS_DESCRIPTOR)
        field(USAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTION_DESCRIPTOR.index -> builder.action = deserializeString().let { GuardrailAction.fromValue(it) }
                ACTIONREASON_DESCRIPTOR.index -> builder.actionReason = deserializeString()
                ASSESSMENTS_DESCRIPTOR.index -> builder.assessments =
                    deserializer.deserializeList(ASSESSMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<GuardrailAssessment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGuardrailAssessmentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                GUARDRAILCOVERAGE_DESCRIPTOR.index -> builder.guardrailCoverage = deserializeGuardrailCoverageDocument(deserializer)
                OUTPUTS_DESCRIPTOR.index -> builder.outputs =
                    deserializer.deserializeList(OUTPUTS_DESCRIPTOR) {
                        val col0 = mutableListOf<GuardrailOutputContent>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGuardrailOutputContentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                USAGE_DESCRIPTOR.index -> builder.usage = deserializeGuardrailUsageDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
