// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.serde

import aws.sdk.kotlin.services.bedrockruntime.model.ApplyGuardrailRequest
import aws.sdk.kotlin.services.bedrockruntime.model.GuardrailContentBlock
import aws.sdk.kotlin.services.bedrockruntime.model.GuardrailContentSource
import aws.sdk.kotlin.services.bedrockruntime.model.GuardrailOutputScope
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ApplyGuardrailOperationSerializer: HttpSerializer.NonStreaming<ApplyGuardrailRequest> {
    override fun serialize(context: ExecutionContext, input: ApplyGuardrailRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.guardrailIdentifier) { "guardrailIdentifier is bound to the URI and must not be null" }
            requireNotNull(input.guardrailVersion) { "guardrailVersion is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("guardrail"))
                add(PercentEncoding.SmithyLabel.encode(input.guardrailIdentifier))
                add(PercentEncoding.Path.encode("version"))
                add(PercentEncoding.SmithyLabel.encode(input.guardrailVersion))
                add(PercentEncoding.Path.encode("apply"))
            }
        }

        val payload = serializeApplyGuardrailOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeApplyGuardrailOperationBody(context: ExecutionContext, input: ApplyGuardrailRequest): ByteArray {
    val serializer = JsonSerializer()
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("content"))
    val OUTPUTSCOPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("outputScope"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("source"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTENT_DESCRIPTOR)
        field(OUTPUTSCOPE_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.content != null) {
            listField(CONTENT_DESCRIPTOR) {
                for (el0 in input.content) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeGuardrailContentBlockDocument))
                }
            }
        }
        input.outputScope?.let { field(OUTPUTSCOPE_DESCRIPTOR, it.value) }
        input.source?.let { field(SOURCE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
