// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.serde

import aws.sdk.kotlin.services.bedrockruntime.model.BedrockRuntimeException
import aws.sdk.kotlin.services.bedrockruntime.model.ConverseMetrics
import aws.sdk.kotlin.services.bedrockruntime.model.ConverseOutput
import aws.sdk.kotlin.services.bedrockruntime.model.ConverseResponse
import aws.sdk.kotlin.services.bedrockruntime.model.ConverseTrace
import aws.sdk.kotlin.services.bedrockruntime.model.PerformanceConfiguration
import aws.sdk.kotlin.services.bedrockruntime.model.StopReason
import aws.sdk.kotlin.services.bedrockruntime.model.TokenUsage
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.content.Document
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ConverseOperationDeserializer: HttpDeserializer.NonStreaming<ConverseResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ConverseResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwConverseError(context, call, payload)
        }
        val builder = ConverseResponse.Builder()

        if (payload != null) {
            deserializeConverseOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwConverseError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ModelErrorException" -> ModelErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ModelNotReadyException" -> ModelNotReadyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ModelTimeoutException" -> ModelTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeConverseOperationBody(builder: ConverseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDITIONALMODELRESPONSEFIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Document, JsonSerialName("additionalModelResponseFields"))
    val METRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("metrics"))
    val OUTPUT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("output"))
    val PERFORMANCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("performanceConfig"))
    val STOPREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("stopReason"))
    val TRACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("trace"))
    val USAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("usage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALMODELRESPONSEFIELDS_DESCRIPTOR)
        field(METRICS_DESCRIPTOR)
        field(OUTPUT_DESCRIPTOR)
        field(PERFORMANCECONFIG_DESCRIPTOR)
        field(STOPREASON_DESCRIPTOR)
        field(TRACE_DESCRIPTOR)
        field(USAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDITIONALMODELRESPONSEFIELDS_DESCRIPTOR.index -> builder.additionalModelResponseFields = deserializeDocument()
                METRICS_DESCRIPTOR.index -> builder.metrics = deserializeConverseMetricsDocument(deserializer)
                OUTPUT_DESCRIPTOR.index -> builder.output = deserializeConverseOutputDocument(deserializer)
                PERFORMANCECONFIG_DESCRIPTOR.index -> builder.performanceConfig = deserializePerformanceConfigurationDocument(deserializer)
                STOPREASON_DESCRIPTOR.index -> builder.stopReason = deserializeString().let { StopReason.fromValue(it) }
                TRACE_DESCRIPTOR.index -> builder.trace = deserializeConverseTraceDocument(deserializer)
                USAGE_DESCRIPTOR.index -> builder.usage = deserializeTokenUsageDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
