// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.serde

import aws.sdk.kotlin.services.bedrockruntime.model.ConverseRequest
import aws.sdk.kotlin.services.bedrockruntime.model.GuardrailConfiguration
import aws.sdk.kotlin.services.bedrockruntime.model.InferenceConfiguration
import aws.sdk.kotlin.services.bedrockruntime.model.Message
import aws.sdk.kotlin.services.bedrockruntime.model.PerformanceConfiguration
import aws.sdk.kotlin.services.bedrockruntime.model.PromptVariableValues
import aws.sdk.kotlin.services.bedrockruntime.model.SystemContentBlock
import aws.sdk.kotlin.services.bedrockruntime.model.ToolConfiguration
import aws.smithy.kotlin.runtime.content.Document
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class ConverseOperationSerializer: HttpSerializer.NonStreaming<ConverseRequest> {
    override fun serialize(context: ExecutionContext, input: ConverseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.modelId) { "modelId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("model"))
                add(PercentEncoding.SmithyLabel.encode(input.modelId))
                add(PercentEncoding.Path.encode("converse"))
            }
        }

        val payload = serializeConverseOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeConverseOperationBody(context: ExecutionContext, input: ConverseRequest): ByteArray {
    val serializer = JsonSerializer()
    val ADDITIONALMODELREQUESTFIELDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Document, JsonSerialName("additionalModelRequestFields"))
    val ADDITIONALMODELRESPONSEFIELDPATHS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("additionalModelResponseFieldPaths"))
    val GUARDRAILCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("guardrailConfig"))
    val INFERENCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("inferenceConfig"))
    val MESSAGES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("messages"))
    val PERFORMANCECONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("performanceConfig"))
    val PROMPTVARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("promptVariables"))
    val REQUESTMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestMetadata"))
    val SYSTEM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("system"))
    val TOOLCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("toolConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALMODELREQUESTFIELDS_DESCRIPTOR)
        field(ADDITIONALMODELRESPONSEFIELDPATHS_DESCRIPTOR)
        field(GUARDRAILCONFIG_DESCRIPTOR)
        field(INFERENCECONFIG_DESCRIPTOR)
        field(MESSAGES_DESCRIPTOR)
        field(PERFORMANCECONFIG_DESCRIPTOR)
        field(PROMPTVARIABLES_DESCRIPTOR)
        field(REQUESTMETADATA_DESCRIPTOR)
        field(SYSTEM_DESCRIPTOR)
        field(TOOLCONFIG_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.additionalModelRequestFields?.let { field(ADDITIONALMODELREQUESTFIELDS_DESCRIPTOR, it) }
        if (input.additionalModelResponseFieldPaths != null) {
            listField(ADDITIONALMODELRESPONSEFIELDPATHS_DESCRIPTOR) {
                for (el0 in input.additionalModelResponseFieldPaths) {
                    serializeString(el0)
                }
            }
        }
        input.guardrailConfig?.let { field(GUARDRAILCONFIG_DESCRIPTOR, it, ::serializeGuardrailConfigurationDocument) }
        input.inferenceConfig?.let { field(INFERENCECONFIG_DESCRIPTOR, it, ::serializeInferenceConfigurationDocument) }
        if (input.messages != null) {
            listField(MESSAGES_DESCRIPTOR) {
                for (el0 in input.messages) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeMessageDocument))
                }
            }
        }
        input.performanceConfig?.let { field(PERFORMANCECONFIG_DESCRIPTOR, it, ::serializePerformanceConfigurationDocument) }
        if (input.promptVariables != null) {
            mapField(PROMPTVARIABLES_DESCRIPTOR) {
                input.promptVariables.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializePromptVariableValuesDocument)) }
            }
        }
        if (input.requestMetadata != null) {
            mapField(REQUESTMETADATA_DESCRIPTOR) {
                input.requestMetadata.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        if (input.system != null) {
            listField(SYSTEM_DESCRIPTOR) {
                for (el0 in input.system) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSystemContentBlockDocument))
                }
            }
        }
        input.toolConfig?.let { field(TOOLCONFIG_DESCRIPTOR, it, ::serializeToolConfigurationDocument) }
    }
    return serializer.toByteArray()
}
