// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.serde

import aws.sdk.kotlin.services.bedrockruntime.model.InvokeModelRequest
import aws.sdk.kotlin.services.bedrockruntime.model.PerformanceConfigLatency
import aws.sdk.kotlin.services.bedrockruntime.model.Trace
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class InvokeModelOperationSerializer: HttpSerializer.NonStreaming<InvokeModelRequest> {
    override fun serialize(context: ExecutionContext, input: InvokeModelRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.modelId) { "modelId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("model"))
                add(PercentEncoding.SmithyLabel.encode(input.modelId))
                add(PercentEncoding.Path.encode("invoke"))
            }
        }

        builder.headers {
            if (input.accept != null) append("Accept", input.accept)
            if (input.contentType != null) append("Content-Type", input.contentType)
            if (input.guardrailIdentifier != null) append("X-Amzn-Bedrock-GuardrailIdentifier", input.guardrailIdentifier)
            if (input.guardrailVersion != null) append("X-Amzn-Bedrock-GuardrailVersion", input.guardrailVersion)
            if (input.performanceConfigLatency != null) append("X-Amzn-Bedrock-PerformanceConfig-Latency", input.performanceConfigLatency.value)
            if (input.trace != null) append("X-Amzn-Bedrock-Trace", input.trace.value)
        }

        if (input.body != null) {
            builder.body = HttpBody.fromBytes(input.body)
        }
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        if (input.body == null) {
            builder.headers.setMissing("Content-Type", "application/octet-stream")
        }
        return builder
    }
}
