// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.bedrockruntime.serde

import aws.sdk.kotlin.services.bedrockruntime.model.BedrockRuntimeException
import aws.sdk.kotlin.services.bedrockruntime.model.InvokeModelWithResponseStreamResponse
import aws.sdk.kotlin.services.bedrockruntime.model.PerformanceConfigLatency
import aws.sdk.kotlin.services.bedrockruntime.model.ResponseStream
import aws.smithy.kotlin.runtime.ClientException
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.MessageType
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.decodeFrames
import aws.smithy.kotlin.runtime.awsprotocol.eventstream.type
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.toSdkByteReadChannel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map


internal class InvokeModelWithResponseStreamOperationDeserializer: HttpDeserializer.Streaming<InvokeModelWithResponseStreamResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): InvokeModelWithResponseStreamResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            val payload = response.body.readAll()
            throwInvokeModelWithResponseStreamError(context, call, payload)
        }
        val builder = InvokeModelWithResponseStreamResponse.Builder()

        builder.contentType = response.headers["X-Amzn-Bedrock-Content-Type"]
        builder.performanceConfigLatency = response.headers["X-Amzn-Bedrock-PerformanceConfig-Latency"]?.let { PerformanceConfigLatency.fromValue(it) }

        deserializeInvokeModelWithResponseStreamOperationBody(builder, call)
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwInvokeModelWithResponseStreamError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BedrockRuntimeException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ModelErrorException" -> ModelErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ModelNotReadyException" -> ModelNotReadyExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ModelStreamErrorException" -> ModelStreamErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ModelTimeoutException" -> ModelTimeoutExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> BedrockRuntimeException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

internal suspend fun deserializeInvokeModelWithResponseStreamOperationBody(builder: InvokeModelWithResponseStreamResponse.Builder, call: HttpCall) {
    val chan = call.response.body.toSdkByteReadChannel(call) ?: return
    val frames = decodeFrames(chan)
    val events = frames
        .map { message ->
            when (val mt = message.type()) {
                is MessageType.Event -> when (mt.shapeType) {
                    "chunk" -> {
                        val e = deserializePayloadPartPayload(message.payload)
                        ResponseStream.Chunk(e)
                    }
                    else -> ResponseStream.SdkUnknown
                }
                is MessageType.Exception -> when (mt.shapeType) {
                    "internalServerException" -> {
                        val err = deserializeInternalServerExceptionPayload(message.payload)
                        throw err
                    }
                    "modelStreamErrorException" -> {
                        val err = deserializeModelStreamErrorExceptionPayload(message.payload)
                        throw err
                    }
                    "validationException" -> {
                        val err = deserializeValidationExceptionPayload(message.payload)
                        throw err
                    }
                    "throttlingException" -> {
                        val err = deserializeThrottlingExceptionPayload(message.payload)
                        throw err
                    }
                    "modelTimeoutException" -> {
                        val err = deserializeModelTimeoutExceptionPayload(message.payload)
                        throw err
                    }
                    "serviceUnavailableException" -> {
                        val err = deserializeServiceUnavailableExceptionPayload(message.payload)
                        throw err
                    }
                    else -> throw BedrockRuntimeException("error processing event stream, unrecognized errorType: ${mt.shapeType}")
                }
                is MessageType.Error -> throw BedrockRuntimeException("error processing event stream: errorCode=${mt.errorCode}; message=${mt.message}")
                is MessageType.SdkUnknown -> throw ClientException("unrecognized event stream message `:message-type`: ${mt.messageType}")
            }
        }

    builder.body = events
}
