// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateWorkspaceRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify `ORGANIZATION`, you must specify which organizational units the workspace can access in the `workspaceOrganizationalUnits` parameter.
     */
    public val accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType = requireNotNull(builder.accountAccessType) { "A non-null value must be provided for accountAccessType" }
    /**
     * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using the Grafana console within a workspace. For more information, see [User authentication in Amazon Managed Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
     */
    public val authenticationProviders: List<AuthenticationProviderTypes> = requireNotNull(builder.authenticationProviders) { "A non-null value must be provided for authenticationProviders" }
    /**
     * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
     */
    public val configuration: kotlin.String? = builder.configuration
    /**
     * Specifies the version of Grafana to support in the new workspace. If not specified, defaults to the latest version (for example, 9.4).
     *
     * To get a list of supported versions, use the `ListVersions` operation.
     */
    public val grafanaVersion: kotlin.String? = builder.grafanaVersion
    /**
     * Configuration for network access to your workspace.
     *
     * When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace. Standard Grafana authentication and authorization will still be required.
     *
     * If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed. Standard Grafana authentication and authorization will still be required.
     */
    public val networkAccessControl: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration? = builder.networkAccessControl
    /**
     * The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data sources and notification channels in other accounts in an organization.
     */
    public val organizationRoleName: kotlin.String? = builder.organizationRoleName
    /**
     * When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services CloudFormation, you must manage IAM roles and provision the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.
     *
     * You must also specify a `workspaceRoleArn` for a role that you will manage for the workspace to use when accessing those datasources and notification channels.
     *
     * The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is supported only in the Amazon Managed Grafana console, where this value may be set to `SERVICE_MANAGED`.
     *
     * Use only the `CUSTOMER_MANAGED` permission type when creating a workspace with the API, CLI or Amazon Web Services CloudFormation.
     *
     * For more information, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html).
     */
    public val permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType = requireNotNull(builder.permissionType) { "A non-null value must be provided for permissionType" }
    /**
     * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The list of tags associated with the workspace.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
     *
     * Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.grafana.model.VpcConfiguration? = builder.vpcConfiguration
    /**
     * This parameter is for internal use only, and should not be used.
     */
    public val workspaceDataSources: List<DataSourceType>? = builder.workspaceDataSources
    /**
     * A description for the workspace. This is used only to help you identify this workspace.
     *
     * Pattern: `^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$`
     */
    public val workspaceDescription: kotlin.String? = builder.workspaceDescription
    /**
     * The name for the workspace. It does not have to be unique.
     */
    public val workspaceName: kotlin.String? = builder.workspaceName
    /**
     * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.
     */
    public val workspaceNotificationDestinations: List<NotificationDestinationType>? = builder.workspaceNotificationDestinations
    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
     */
    public val workspaceOrganizationalUnits: List<String>? = builder.workspaceOrganizationalUnits
    /**
     * Specified the IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from, including both data sources and notification channels. You are responsible for managing the permissions for this role as new data sources or notification channels are added.
     */
    public val workspaceRoleArn: kotlin.String? = builder.workspaceRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateWorkspaceRequest(")
        append("accountAccessType=$accountAccessType,")
        append("authenticationProviders=$authenticationProviders,")
        append("clientToken=$clientToken,")
        append("configuration=$configuration,")
        append("grafanaVersion=$grafanaVersion,")
        append("networkAccessControl=$networkAccessControl,")
        append("organizationRoleName=*** Sensitive Data Redacted ***,")
        append("permissionType=$permissionType,")
        append("stackSetName=$stackSetName,")
        append("tags=$tags,")
        append("vpcConfiguration=$vpcConfiguration,")
        append("workspaceDataSources=$workspaceDataSources,")
        append("workspaceDescription=*** Sensitive Data Redacted ***,")
        append("workspaceName=*** Sensitive Data Redacted ***,")
        append("workspaceNotificationDestinations=$workspaceNotificationDestinations,")
        append("workspaceOrganizationalUnits=*** Sensitive Data Redacted ***,")
        append("workspaceRoleArn=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountAccessType.hashCode()
        result = 31 * result + (authenticationProviders.hashCode())
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (grafanaVersion?.hashCode() ?: 0)
        result = 31 * result + (networkAccessControl?.hashCode() ?: 0)
        result = 31 * result + (organizationRoleName?.hashCode() ?: 0)
        result = 31 * result + (permissionType.hashCode())
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workspaceDataSources?.hashCode() ?: 0)
        result = 31 * result + (workspaceDescription?.hashCode() ?: 0)
        result = 31 * result + (workspaceName?.hashCode() ?: 0)
        result = 31 * result + (workspaceNotificationDestinations?.hashCode() ?: 0)
        result = 31 * result + (workspaceOrganizationalUnits?.hashCode() ?: 0)
        result = 31 * result + (workspaceRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateWorkspaceRequest

        if (accountAccessType != other.accountAccessType) return false
        if (authenticationProviders != other.authenticationProviders) return false
        if (clientToken != other.clientToken) return false
        if (configuration != other.configuration) return false
        if (grafanaVersion != other.grafanaVersion) return false
        if (networkAccessControl != other.networkAccessControl) return false
        if (organizationRoleName != other.organizationRoleName) return false
        if (permissionType != other.permissionType) return false
        if (stackSetName != other.stackSetName) return false
        if (tags != other.tags) return false
        if (vpcConfiguration != other.vpcConfiguration) return false
        if (workspaceDataSources != other.workspaceDataSources) return false
        if (workspaceDescription != other.workspaceDescription) return false
        if (workspaceName != other.workspaceName) return false
        if (workspaceNotificationDestinations != other.workspaceNotificationDestinations) return false
        if (workspaceOrganizationalUnits != other.workspaceOrganizationalUnits) return false
        if (workspaceRoleArn != other.workspaceRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify `ORGANIZATION`, you must specify which organizational units the workspace can access in the `workspaceOrganizationalUnits` parameter.
         */
        public var accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType? = null
        /**
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center, or both to authenticate users for using the Grafana console within a workspace. For more information, see [User authentication in Amazon Managed Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
         */
        public var authenticationProviders: List<AuthenticationProviderTypes>? = null
        /**
         * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The configuration string for the workspace that you create. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
         */
        public var configuration: kotlin.String? = null
        /**
         * Specifies the version of Grafana to support in the new workspace. If not specified, defaults to the latest version (for example, 9.4).
         *
         * To get a list of supported versions, use the `ListVersions` operation.
         */
        public var grafanaVersion: kotlin.String? = null
        /**
         * Configuration for network access to your workspace.
         *
         * When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace. Standard Grafana authentication and authorization will still be required.
         *
         * If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed. Standard Grafana authentication and authorization will still be required.
         */
        public var networkAccessControl: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration? = null
        /**
         * The name of an IAM role that already exists to use with Organizations to access Amazon Web Services data sources and notification channels in other accounts in an organization.
         */
        public var organizationRoleName: kotlin.String? = null
        /**
         * When creating a workspace through the Amazon Web Services API, CLI or Amazon Web Services CloudFormation, you must manage IAM roles and provision the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.
         *
         * You must also specify a `workspaceRoleArn` for a role that you will manage for the workspace to use when accessing those datasources and notification channels.
         *
         * The ability for Amazon Managed Grafana to create and update IAM roles on behalf of the user is supported only in the Amazon Managed Grafana console, where this value may be set to `SERVICE_MANAGED`.
         *
         * Use only the `CUSTOMER_MANAGED` permission type when creating a workspace with the API, CLI or Amazon Web Services CloudFormation.
         *
         * For more information, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html).
         */
        public var permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType? = null
        /**
         * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * The list of tags associated with the workspace.
         */
        public var tags: Map<String, String>? = null
        /**
         * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
         *
         * Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.grafana.model.VpcConfiguration? = null
        /**
         * This parameter is for internal use only, and should not be used.
         */
        public var workspaceDataSources: List<DataSourceType>? = null
        /**
         * A description for the workspace. This is used only to help you identify this workspace.
         *
         * Pattern: `^[\\p{L}\\p{Z}\\p{N}\\p{P}]{0,2048}$`
         */
        public var workspaceDescription: kotlin.String? = null
        /**
         * The name for the workspace. It does not have to be unique.
         */
        public var workspaceName: kotlin.String? = null
        /**
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.
         */
        public var workspaceNotificationDestinations: List<NotificationDestinationType>? = null
        /**
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
         */
        public var workspaceOrganizationalUnits: List<String>? = null
        /**
         * Specified the IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from, including both data sources and notification channels. You are responsible for managing the permissions for this role as new data sources or notification channels are added.
         */
        public var workspaceRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest) : this() {
            this.accountAccessType = x.accountAccessType
            this.authenticationProviders = x.authenticationProviders
            this.clientToken = x.clientToken
            this.configuration = x.configuration
            this.grafanaVersion = x.grafanaVersion
            this.networkAccessControl = x.networkAccessControl
            this.organizationRoleName = x.organizationRoleName
            this.permissionType = x.permissionType
            this.stackSetName = x.stackSetName
            this.tags = x.tags
            this.vpcConfiguration = x.vpcConfiguration
            this.workspaceDataSources = x.workspaceDataSources
            this.workspaceDescription = x.workspaceDescription
            this.workspaceName = x.workspaceName
            this.workspaceNotificationDestinations = x.workspaceNotificationDestinations
            this.workspaceOrganizationalUnits = x.workspaceOrganizationalUnits
            this.workspaceRoleArn = x.workspaceRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest = CreateWorkspaceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration] inside the given [block]
         */
        public fun networkAccessControl(block: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration.Builder.() -> kotlin.Unit) {
            this.networkAccessControl = aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.grafana.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.grafana.model.VpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (accountAccessType == null) accountAccessType = AccountAccessType.SdkUnknown("no value provided")
            if (authenticationProviders == null) authenticationProviders = emptyList()
            if (permissionType == null) permissionType = PermissionType.SdkUnknown("no value provided")
            return this
        }
    }
}
