// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration settings for in-bound network access to your workspace.
 *
 * When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace. Standard Grafana authentication and authorization are still required.
 *
 * Access is granted to a caller that is in either the IP address list or the VPC endpoint list - they do not need to be in both.
 *
 * If this is not configured, or is removed, then all IP addresses and VPC endpoints are allowed. Standard Grafana authentication and authorization are still required.
 *
 * While both `prefixListIds` and `vpceIds` are required, you can pass in an empty array of strings for either parameter if you do not want to allow any of that type.
 *
 * If both are passed as empty arrays, no traffic is allowed to the workspace, because only *explicitly* allowed connections are accepted.
 */
public class NetworkAccessConfiguration private constructor(builder: Builder) {
    /**
     * An array of prefix list IDs. A prefix list is a list of CIDR ranges of IP addresses. The IP addresses specified are allowed to access your workspace. If the list is not included in the configuration (passed an empty array) then no IP addresses are allowed to access the workspace. You create a prefix list using the Amazon VPC console.
     *
     * Prefix list IDs have the format `pl-<i>1a2b3c4d</i> `.
     *
     * For more information about prefix lists, see [Group CIDR blocks using managed prefix lists](https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html)in the *Amazon Virtual Private Cloud User Guide*.
     */
    public val prefixListIds: List<String> = requireNotNull(builder.prefixListIds) { "A non-null value must be provided for prefixListIds" }
    /**
     * An array of Amazon VPC endpoint IDs for the workspace. You can create VPC endpoints to your Amazon Managed Grafana workspace for access from within a VPC. If a `NetworkAccessConfiguration` is specified then only VPC endpoints specified here are allowed to access the workspace. If you pass in an empty array of strings, then no VPCs are allowed to access the workspace.
     *
     * VPC endpoint IDs have the format `vpce-<i>1a2b3c4d</i> `.
     *
     * For more information about creating an interface VPC endpoint, see [Interface VPC endpoints](https://docs.aws.amazon.com/grafana/latest/userguide/VPC-endpoints) in the *Amazon Managed Grafana User Guide*.
     *
     * The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the `com.amazonaws.[region].grafana-workspace` service endpoint). Other VPC endpoints are ignored.
     */
    public val vpceIds: List<String> = requireNotNull(builder.vpceIds) { "A non-null value must be provided for vpceIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkAccessConfiguration(")
        append("prefixListIds=$prefixListIds,")
        append("vpceIds=$vpceIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = prefixListIds.hashCode()
        result = 31 * result + (vpceIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkAccessConfiguration

        if (prefixListIds != other.prefixListIds) return false
        if (vpceIds != other.vpceIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An array of prefix list IDs. A prefix list is a list of CIDR ranges of IP addresses. The IP addresses specified are allowed to access your workspace. If the list is not included in the configuration (passed an empty array) then no IP addresses are allowed to access the workspace. You create a prefix list using the Amazon VPC console.
         *
         * Prefix list IDs have the format `pl-<i>1a2b3c4d</i> `.
         *
         * For more information about prefix lists, see [Group CIDR blocks using managed prefix lists](https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html)in the *Amazon Virtual Private Cloud User Guide*.
         */
        public var prefixListIds: List<String>? = null
        /**
         * An array of Amazon VPC endpoint IDs for the workspace. You can create VPC endpoints to your Amazon Managed Grafana workspace for access from within a VPC. If a `NetworkAccessConfiguration` is specified then only VPC endpoints specified here are allowed to access the workspace. If you pass in an empty array of strings, then no VPCs are allowed to access the workspace.
         *
         * VPC endpoint IDs have the format `vpce-<i>1a2b3c4d</i> `.
         *
         * For more information about creating an interface VPC endpoint, see [Interface VPC endpoints](https://docs.aws.amazon.com/grafana/latest/userguide/VPC-endpoints) in the *Amazon Managed Grafana User Guide*.
         *
         * The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the `com.amazonaws.[region].grafana-workspace` service endpoint). Other VPC endpoints are ignored.
         */
        public var vpceIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration) : this() {
            this.prefixListIds = x.prefixListIds
            this.vpceIds = x.vpceIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration = NetworkAccessConfiguration(this)

        internal fun correctErrors(): Builder {
            if (prefixListIds == null) prefixListIds = emptyList()
            if (vpceIds == null) vpceIds = emptyList()
            return this
        }
    }
}
