// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains the instructions for one Grafana role permission update in a [UpdatePermissions](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html) operation.
 */
public class UpdateInstruction private constructor(builder: Builder) {
    /**
     * Specifies whether this update is to add or revoke role permissions.
     */
    public val action: aws.sdk.kotlin.services.grafana.model.UpdateAction = requireNotNull(builder.action) { "A non-null value must be provided for action" }
    /**
     * The role to add or revoke for the user or the group specified in `users`.
     */
    public val role: aws.sdk.kotlin.services.grafana.model.Role = requireNotNull(builder.role) { "A non-null value must be provided for role" }
    /**
     * A structure that specifies the user or group to add or revoke the role for.
     */
    public val users: List<User> = requireNotNull(builder.users) { "A non-null value must be provided for users" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.UpdateInstruction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateInstruction(")
        append("action=$action,")
        append("role=$role,")
        append("users=$users")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = action.hashCode()
        result = 31 * result + (role.hashCode())
        result = 31 * result + (users.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateInstruction

        if (action != other.action) return false
        if (role != other.role) return false
        if (users != other.users) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.UpdateInstruction = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether this update is to add or revoke role permissions.
         */
        public var action: aws.sdk.kotlin.services.grafana.model.UpdateAction? = null
        /**
         * The role to add or revoke for the user or the group specified in `users`.
         */
        public var role: aws.sdk.kotlin.services.grafana.model.Role? = null
        /**
         * A structure that specifies the user or group to add or revoke the role for.
         */
        public var users: List<User>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.UpdateInstruction) : this() {
            this.action = x.action
            this.role = x.role
            this.users = x.users
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.UpdateInstruction = UpdateInstruction(this)

        internal fun correctErrors(): Builder {
            if (action == null) action = UpdateAction.SdkUnknown("no value provided")
            if (role == null) role = Role.SdkUnknown("no value provided")
            if (users == null) users = emptyList()
            return this
        }
    }
}
