// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateWorkspaceConfigurationRequest private constructor(builder: Builder) {
    /**
     * The new configuration string for the workspace. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
     */
    public val configuration: kotlin.String = requireNotNull(builder.configuration) { "A non-null value must be provided for configuration" }
    /**
     * Specifies the version of Grafana to support in the workspace. If not specified, keeps the current version of the workspace.
     *
     * Can only be used to upgrade (for example, from 8.4 to 9.4), not downgrade (for example, from 9.4 to 8.4).
     *
     * To know what versions are available to upgrade to for a specific workspace, see the [ListVersions](https://docs.aws.amazon.com/grafana/latest/APIReference/API_ListVersions.html) operation.
     */
    public val grafanaVersion: kotlin.String? = builder.grafanaVersion
    /**
     * The ID of the workspace to update.
     */
    public val workspaceId: kotlin.String = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateWorkspaceConfigurationRequest(")
        append("configuration=$configuration,")
        append("grafanaVersion=$grafanaVersion,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration.hashCode()
        result = 31 * result + (grafanaVersion?.hashCode() ?: 0)
        result = 31 * result + (workspaceId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateWorkspaceConfigurationRequest

        if (configuration != other.configuration) return false
        if (grafanaVersion != other.grafanaVersion) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceConfigurationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The new configuration string for the workspace. For more information about the format and configuration options available, see [Working in your Grafana workspace](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-configure-workspace.html).
         */
        public var configuration: kotlin.String? = null
        /**
         * Specifies the version of Grafana to support in the workspace. If not specified, keeps the current version of the workspace.
         *
         * Can only be used to upgrade (for example, from 8.4 to 9.4), not downgrade (for example, from 9.4 to 8.4).
         *
         * To know what versions are available to upgrade to for a specific workspace, see the [ListVersions](https://docs.aws.amazon.com/grafana/latest/APIReference/API_ListVersions.html) operation.
         */
        public var grafanaVersion: kotlin.String? = null
        /**
         * The ID of the workspace to update.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceConfigurationRequest) : this() {
            this.configuration = x.configuration
            this.grafanaVersion = x.grafanaVersion
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceConfigurationRequest = UpdateWorkspaceConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            if (configuration == null) configuration = ""
            if (workspaceId == null) workspaceId = ""
            return this
        }
    }
}
