// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains some information about one workspace in the account.
 */
public class WorkspaceSummary private constructor(builder: Builder) {
    /**
     * A structure containing information about the authentication methods used in the workspace.
     */
    public val authentication: aws.sdk.kotlin.services.grafana.model.AuthenticationSummary? = builder.authentication
    /**
     * The date that the workspace was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.created) { "A non-null value must be provided for created" }
    /**
     * The customer-entered description of the workspace.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The URL endpoint to use to access the Grafana console in the workspace.
     */
    public val endpoint: kotlin.String = requireNotNull(builder.endpoint) { "A non-null value must be provided for endpoint" }
    /**
     * The token that ties this workspace to a Grafana Labs account. For more information, see [Register with Grafana Labs](https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html#AMG-workspace-register-enterprise).
     */
    public val grafanaToken: kotlin.String? = builder.grafanaToken
    /**
     * The Grafana version that the workspace is running.
     */
    public val grafanaVersion: kotlin.String = requireNotNull(builder.grafanaVersion) { "A non-null value must be provided for grafanaVersion" }
    /**
     * The unique ID of the workspace.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Specifies whether this workspace has a full Grafana Enterprise license.
     *
     * Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
     */
    public val licenseType: aws.sdk.kotlin.services.grafana.model.LicenseType? = builder.licenseType
    /**
     * The most recent date that the workspace was modified.
     */
    public val modified: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.modified) { "A non-null value must be provided for modified" }
    /**
     * The name of the workspace.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, which allows Amazon Managed Grafana to use these channels.
     */
    public val notificationDestinations: List<NotificationDestinationType>? = builder.notificationDestinations
    /**
     * The current status of the workspace.
     */
    public val status: aws.sdk.kotlin.services.grafana.model.WorkspaceStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * The list of tags associated with the workspace.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.WorkspaceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceSummary(")
        append("authentication=$authentication,")
        append("created=$created,")
        append("description=*** Sensitive Data Redacted ***,")
        append("endpoint=$endpoint,")
        append("grafanaToken=$grafanaToken,")
        append("grafanaVersion=$grafanaVersion,")
        append("id=$id,")
        append("licenseType=$licenseType,")
        append("modified=$modified,")
        append("name=*** Sensitive Data Redacted ***,")
        append("notificationDestinations=$notificationDestinations,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authentication?.hashCode() ?: 0
        result = 31 * result + (created.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpoint.hashCode())
        result = 31 * result + (grafanaToken?.hashCode() ?: 0)
        result = 31 * result + (grafanaVersion.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (licenseType?.hashCode() ?: 0)
        result = 31 * result + (modified.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (notificationDestinations?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceSummary

        if (authentication != other.authentication) return false
        if (created != other.created) return false
        if (description != other.description) return false
        if (endpoint != other.endpoint) return false
        if (grafanaToken != other.grafanaToken) return false
        if (grafanaVersion != other.grafanaVersion) return false
        if (id != other.id) return false
        if (licenseType != other.licenseType) return false
        if (modified != other.modified) return false
        if (name != other.name) return false
        if (notificationDestinations != other.notificationDestinations) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.WorkspaceSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A structure containing information about the authentication methods used in the workspace.
         */
        public var authentication: aws.sdk.kotlin.services.grafana.model.AuthenticationSummary? = null
        /**
         * The date that the workspace was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The customer-entered description of the workspace.
         */
        public var description: kotlin.String? = null
        /**
         * The URL endpoint to use to access the Grafana console in the workspace.
         */
        public var endpoint: kotlin.String? = null
        /**
         * The token that ties this workspace to a Grafana Labs account. For more information, see [Register with Grafana Labs](https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html#AMG-workspace-register-enterprise).
         */
        public var grafanaToken: kotlin.String? = null
        /**
         * The Grafana version that the workspace is running.
         */
        public var grafanaVersion: kotlin.String? = null
        /**
         * The unique ID of the workspace.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies whether this workspace has a full Grafana Enterprise license.
         *
         * Amazon Managed Grafana workspaces no longer support Grafana Enterprise free trials.
         */
        public var licenseType: aws.sdk.kotlin.services.grafana.model.LicenseType? = null
        /**
         * The most recent date that the workspace was modified.
         */
        public var modified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the workspace.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, which allows Amazon Managed Grafana to use these channels.
         */
        public var notificationDestinations: List<NotificationDestinationType>? = null
        /**
         * The current status of the workspace.
         */
        public var status: aws.sdk.kotlin.services.grafana.model.WorkspaceStatus? = null
        /**
         * The list of tags associated with the workspace.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.WorkspaceSummary) : this() {
            this.authentication = x.authentication
            this.created = x.created
            this.description = x.description
            this.endpoint = x.endpoint
            this.grafanaToken = x.grafanaToken
            this.grafanaVersion = x.grafanaVersion
            this.id = x.id
            this.licenseType = x.licenseType
            this.modified = x.modified
            this.name = x.name
            this.notificationDestinations = x.notificationDestinations
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.WorkspaceSummary = WorkspaceSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.AuthenticationSummary] inside the given [block]
         */
        public fun authentication(block: aws.sdk.kotlin.services.grafana.model.AuthenticationSummary.Builder.() -> kotlin.Unit) {
            this.authentication = aws.sdk.kotlin.services.grafana.model.AuthenticationSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (created == null) created = Instant.fromEpochSeconds(0)
            if (endpoint == null) endpoint = ""
            if (grafanaVersion == null) grafanaVersion = ""
            if (id == null) id = ""
            if (modified == null) modified = Instant.fromEpochSeconds(0)
            if (status == null) status = WorkspaceStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
