// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.serde

import aws.sdk.kotlin.services.grafana.model.AccountAccessType
import aws.sdk.kotlin.services.grafana.model.DataSourceType
import aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration
import aws.sdk.kotlin.services.grafana.model.NotificationDestinationType
import aws.sdk.kotlin.services.grafana.model.PermissionType
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest
import aws.sdk.kotlin.services.grafana.model.VpcConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateWorkspaceOperationSerializer: HttpSerializer.NonStreaming<UpdateWorkspaceRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateWorkspaceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("workspaces"))
                add(PercentEncoding.SmithyLabel.encode("${input.workspaceId}"))
            }
        }

        val payload = serializeUpdateWorkspaceOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateWorkspaceOperationBody(context: ExecutionContext, input: UpdateWorkspaceRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCOUNTACCESSTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accountAccessType"))
    val NETWORKACCESSCONTROL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("networkAccessControl"))
    val ORGANIZATIONROLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("organizationRoleName"))
    val PERMISSIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("permissionType"))
    val REMOVENETWORKACCESSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("removeNetworkAccessConfiguration"))
    val REMOVEVPCCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("removeVpcConfiguration"))
    val STACKSETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stackSetName"))
    val VPCCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vpcConfiguration"))
    val WORKSPACEDATASOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("workspaceDataSources"))
    val WORKSPACEDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workspaceDescription"))
    val WORKSPACENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workspaceName"))
    val WORKSPACENOTIFICATIONDESTINATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("workspaceNotificationDestinations"))
    val WORKSPACEORGANIZATIONALUNITS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("workspaceOrganizationalUnits"))
    val WORKSPACEROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workspaceRoleArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTACCESSTYPE_DESCRIPTOR)
        field(NETWORKACCESSCONTROL_DESCRIPTOR)
        field(ORGANIZATIONROLENAME_DESCRIPTOR)
        field(PERMISSIONTYPE_DESCRIPTOR)
        field(REMOVENETWORKACCESSCONFIGURATION_DESCRIPTOR)
        field(REMOVEVPCCONFIGURATION_DESCRIPTOR)
        field(STACKSETNAME_DESCRIPTOR)
        field(VPCCONFIGURATION_DESCRIPTOR)
        field(WORKSPACEDATASOURCES_DESCRIPTOR)
        field(WORKSPACEDESCRIPTION_DESCRIPTOR)
        field(WORKSPACENAME_DESCRIPTOR)
        field(WORKSPACENOTIFICATIONDESTINATIONS_DESCRIPTOR)
        field(WORKSPACEORGANIZATIONALUNITS_DESCRIPTOR)
        field(WORKSPACEROLEARN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accountAccessType?.let { field(ACCOUNTACCESSTYPE_DESCRIPTOR, it.value) }
        input.networkAccessControl?.let { field(NETWORKACCESSCONTROL_DESCRIPTOR, it, ::serializeNetworkAccessConfigurationDocument) }
        input.organizationRoleName?.let { field(ORGANIZATIONROLENAME_DESCRIPTOR, it) }
        input.permissionType?.let { field(PERMISSIONTYPE_DESCRIPTOR, it.value) }
        input.removeNetworkAccessConfiguration?.let { field(REMOVENETWORKACCESSCONFIGURATION_DESCRIPTOR, it) }
        input.removeVpcConfiguration?.let { field(REMOVEVPCCONFIGURATION_DESCRIPTOR, it) }
        input.stackSetName?.let { field(STACKSETNAME_DESCRIPTOR, it) }
        input.vpcConfiguration?.let { field(VPCCONFIGURATION_DESCRIPTOR, it, ::serializeVpcConfigurationDocument) }
        if (input.workspaceDataSources != null) {
            listField(WORKSPACEDATASOURCES_DESCRIPTOR) {
                for (el0 in input.workspaceDataSources) {
                    serializeString(el0.value)
                }
            }
        }
        input.workspaceDescription?.let { field(WORKSPACEDESCRIPTION_DESCRIPTOR, it) }
        input.workspaceName?.let { field(WORKSPACENAME_DESCRIPTOR, it) }
        if (input.workspaceNotificationDestinations != null) {
            listField(WORKSPACENOTIFICATIONDESTINATIONS_DESCRIPTOR) {
                for (el0 in input.workspaceNotificationDestinations) {
                    serializeString(el0.value)
                }
            }
        }
        if (input.workspaceOrganizationalUnits != null) {
            listField(WORKSPACEORGANIZATIONALUNITS_DESCRIPTOR) {
                for (el0 in input.workspaceOrganizationalUnits) {
                    serializeString(el0)
                }
            }
        }
        input.workspaceRoleArn?.let { field(WORKSPACEROLEARN_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
