// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog

import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.interceptors.AwsSpanInterceptor
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.servicecatalog.auth.ServiceCatalogAuthSchemeProviderAdapter
import aws.sdk.kotlin.services.servicecatalog.auth.ServiceCatalogIdentityProviderConfigAdapter
import aws.sdk.kotlin.services.servicecatalog.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.servicecatalog.model.*
import aws.sdk.kotlin.services.servicecatalog.serde.*
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.awsprotocol.AwsAttributes
import aws.smithy.kotlin.runtime.awsprotocol.json.AwsJsonProtocol
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.collections.putIfAbsent
import aws.smithy.kotlin.runtime.collections.putIfAbsentNotNull
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.SigV4AuthScheme
import aws.smithy.kotlin.runtime.http.operation.OperationAuthConfig
import aws.smithy.kotlin.runtime.http.operation.OperationMetrics
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.telemetry
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext

internal class DefaultServiceCatalogClient(override val config: ServiceCatalogClient.Config) : ServiceCatalogClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClient)
    private val identityProviderConfig = ServiceCatalogIdentityProviderConfigAdapter(config)
    private val configuredAuthSchemes = with(config.authSchemes.associateBy(AuthScheme::schemeId).toMutableMap()){
        getOrPut(AuthSchemeId.AwsSigV4){
            SigV4AuthScheme(DefaultAwsSigner, "servicecatalog")
        }
        toMap()
    }
    private val authSchemeAdapter = ServiceCatalogAuthSchemeProviderAdapter(config)
    private val telemetryScope = "aws.sdk.kotlin.services.servicecatalog"
    private val opMetrics = OperationMetrics(telemetryScope, config.telemetryProvider)

    init {
        managedResources.addIfManaged(config.httpClient)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion), config.applicationId)

    /**
     * Accepts an offer to share the specified portfolio.
     */
    override suspend fun acceptPortfolioShare(input: AcceptPortfolioShareRequest): AcceptPortfolioShareResponse {
        val op = SdkHttpOperation.build<AcceptPortfolioShareRequest, AcceptPortfolioShareResponse> {
            serializeWith = AcceptPortfolioShareOperationSerializer()
            deserializeWith = AcceptPortfolioShareOperationDeserializer()
            operationName = "AcceptPortfolioShare"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified budget with the specified resource.
     */
    override suspend fun associateBudgetWithResource(input: AssociateBudgetWithResourceRequest): AssociateBudgetWithResourceResponse {
        val op = SdkHttpOperation.build<AssociateBudgetWithResourceRequest, AssociateBudgetWithResourceResponse> {
            serializeWith = AssociateBudgetWithResourceOperationSerializer()
            deserializeWith = AssociateBudgetWithResourceOperationDeserializer()
            operationName = "AssociateBudgetWithResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified principal ARN with the specified portfolio.
     *
     * If you share the portfolio with principal name sharing enabled, the `PrincipalARN` association is included in the share.
     *
     * The `PortfolioID`, `PrincipalARN`, and `PrincipalType` parameters are required.
     *
     * You can associate a maximum of 10 Principals with a portfolio using `PrincipalType` as `IAM_PATTERN`.
     *
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that portfolio is then shared with other accounts. For a user in a recipient account who is *not* an Service Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role that matches a principal name association for the portfolio. Although this user may not know which principal names are associated through Service Catalog, they may be able to guess the user. If this potential escalation path is a concern, then Service Catalog recommends using `PrincipalType` as `IAM`. With this configuration, the `PrincipalARN` must already exist in the recipient account before it can be associated.
     */
    override suspend fun associatePrincipalWithPortfolio(input: AssociatePrincipalWithPortfolioRequest): AssociatePrincipalWithPortfolioResponse {
        val op = SdkHttpOperation.build<AssociatePrincipalWithPortfolioRequest, AssociatePrincipalWithPortfolioResponse> {
            serializeWith = AssociatePrincipalWithPortfolioOperationSerializer()
            deserializeWith = AssociatePrincipalWithPortfolioOperationDeserializer()
            operationName = "AssociatePrincipalWithPortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates the specified product with the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun associateProductWithPortfolio(input: AssociateProductWithPortfolioRequest): AssociateProductWithPortfolioResponse {
        val op = SdkHttpOperation.build<AssociateProductWithPortfolioRequest, AssociateProductWithPortfolioResponse> {
            serializeWith = AssociateProductWithPortfolioOperationSerializer()
            deserializeWith = AssociateProductWithPortfolioOperationDeserializer()
            operationName = "AssociateProductWithPortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates a self-service action with a provisioning artifact.
     */
    override suspend fun associateServiceActionWithProvisioningArtifact(input: AssociateServiceActionWithProvisioningArtifactRequest): AssociateServiceActionWithProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<AssociateServiceActionWithProvisioningArtifactRequest, AssociateServiceActionWithProvisioningArtifactResponse> {
            serializeWith = AssociateServiceActionWithProvisioningArtifactOperationSerializer()
            deserializeWith = AssociateServiceActionWithProvisioningArtifactOperationDeserializer()
            operationName = "AssociateServiceActionWithProvisioningArtifact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associate the specified TagOption with the specified portfolio or product.
     */
    override suspend fun associateTagOptionWithResource(input: AssociateTagOptionWithResourceRequest): AssociateTagOptionWithResourceResponse {
        val op = SdkHttpOperation.build<AssociateTagOptionWithResourceRequest, AssociateTagOptionWithResourceResponse> {
            serializeWith = AssociateTagOptionWithResourceOperationSerializer()
            deserializeWith = AssociateTagOptionWithResourceOperationDeserializer()
            operationName = "AssociateTagOptionWithResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Associates multiple self-service actions with provisioning artifacts.
     */
    override suspend fun batchAssociateServiceActionWithProvisioningArtifact(input: BatchAssociateServiceActionWithProvisioningArtifactRequest): BatchAssociateServiceActionWithProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<BatchAssociateServiceActionWithProvisioningArtifactRequest, BatchAssociateServiceActionWithProvisioningArtifactResponse> {
            serializeWith = BatchAssociateServiceActionWithProvisioningArtifactOperationSerializer()
            deserializeWith = BatchAssociateServiceActionWithProvisioningArtifactOperationDeserializer()
            operationName = "BatchAssociateServiceActionWithProvisioningArtifact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     */
    override suspend fun batchDisassociateServiceActionFromProvisioningArtifact(input: BatchDisassociateServiceActionFromProvisioningArtifactRequest): BatchDisassociateServiceActionFromProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<BatchDisassociateServiceActionFromProvisioningArtifactRequest, BatchDisassociateServiceActionFromProvisioningArtifactResponse> {
            serializeWith = BatchDisassociateServiceActionFromProvisioningArtifactOperationSerializer()
            deserializeWith = BatchDisassociateServiceActionFromProvisioningArtifactOperationDeserializer()
            operationName = "BatchDisassociateServiceActionFromProvisioningArtifact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Copies the specified source product to the specified target product or a new product.
     *
     * You can copy a product to the same account or another account. You can copy a product to the same Region or another Region. If you copy a product to another account, you must first share the product in a portfolio using CreatePortfolioShare.
     *
     * This operation is performed asynchronously. To track the progress of the operation, use DescribeCopyProductStatus.
     */
    override suspend fun copyProduct(input: CopyProductRequest): CopyProductResponse {
        val op = SdkHttpOperation.build<CopyProductRequest, CopyProductResponse> {
            serializeWith = CopyProductOperationSerializer()
            deserializeWith = CopyProductOperationDeserializer()
            operationName = "CopyProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun createConstraint(input: CreateConstraintRequest): CreateConstraintResponse {
        val op = SdkHttpOperation.build<CreateConstraintRequest, CreateConstraintResponse> {
            serializeWith = CreateConstraintOperationSerializer()
            deserializeWith = CreateConstraintOperationDeserializer()
            operationName = "CreateConstraint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun createPortfolio(input: CreatePortfolioRequest): CreatePortfolioResponse {
        val op = SdkHttpOperation.build<CreatePortfolioRequest, CreatePortfolioResponse> {
            serializeWith = CreatePortfolioOperationSerializer()
            deserializeWith = CreatePortfolioOperationDeserializer()
            operationName = "CreatePortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. You can share portfolios to an organization, an organizational unit, or a specific account.
     *
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     *
     * `AWSOrganizationsAccess` must be enabled in order to create a portfolio share to an organization node.
     *
     * You can't share a shared resource, including portfolios that contain a shared product.
     *
     * If the portfolio share with the specified account or organization node already exists, this action will have no effect and will not return an error. To update an existing share, you must use the ` UpdatePortfolioShare` API instead.
     *
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that portfolio is then shared with other accounts. For a user in a recipient account who is *not* an Service Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role that matches a principal name association for the portfolio. Although this user may not know which principal names are associated through Service Catalog, they may be able to guess the user. If this potential escalation path is a concern, then Service Catalog recommends using `PrincipalType` as `IAM`. With this configuration, the `PrincipalARN` must already exist in the recipient account before it can be associated.
     */
    override suspend fun createPortfolioShare(input: CreatePortfolioShareRequest): CreatePortfolioShareResponse {
        val op = SdkHttpOperation.build<CreatePortfolioShareRequest, CreatePortfolioShareResponse> {
            serializeWith = CreatePortfolioShareOperationSerializer()
            deserializeWith = CreatePortfolioShareOperationDeserializer()
            operationName = "CreatePortfolioShare"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a product.
     *
     * A delegated admin is authorized to invoke this command.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    override suspend fun createProduct(input: CreateProductRequest): CreateProductResponse {
        val op = SdkHttpOperation.build<CreateProductRequest, CreateProductResponse> {
            serializeWith = CreateProductOperationSerializer()
            deserializeWith = CreateProductOperationDeserializer()
            operationName = "CreateProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a plan.
     *
     * A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating a provisioned product) when the plan is executed.
     *
     * You can create one plan for each provisioned product. To create a plan for an existing provisioned product, the product status must be AVAILABLE or TAINTED.
     *
     * To view the resource changes in the change set, use DescribeProvisionedProductPlan. To create or modify the provisioned product, use ExecuteProvisionedProductPlan.
     */
    override suspend fun createProvisionedProductPlan(input: CreateProvisionedProductPlanRequest): CreateProvisionedProductPlanResponse {
        val op = SdkHttpOperation.build<CreateProvisionedProductPlanRequest, CreateProvisionedProductPlanResponse> {
            serializeWith = CreateProvisionedProductPlanOperationSerializer()
            deserializeWith = CreateProvisionedProductPlanOperationDeserializer()
            operationName = "CreateProvisionedProductPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot create a provisioning artifact for a product that was shared with you.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    override suspend fun createProvisioningArtifact(input: CreateProvisioningArtifactRequest): CreateProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<CreateProvisioningArtifactRequest, CreateProvisioningArtifactResponse> {
            serializeWith = CreateProvisioningArtifactOperationSerializer()
            deserializeWith = CreateProvisioningArtifactOperationDeserializer()
            operationName = "CreateProvisioningArtifact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a self-service action.
     */
    override suspend fun createServiceAction(input: CreateServiceActionRequest): CreateServiceActionResponse {
        val op = SdkHttpOperation.build<CreateServiceActionRequest, CreateServiceActionResponse> {
            serializeWith = CreateServiceActionOperationSerializer()
            deserializeWith = CreateServiceActionOperationDeserializer()
            operationName = "CreateServiceAction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a TagOption.
     */
    override suspend fun createTagOption(input: CreateTagOptionRequest): CreateTagOptionResponse {
        val op = SdkHttpOperation.build<CreateTagOptionRequest, CreateTagOptionResponse> {
            serializeWith = CreateTagOptionOperationSerializer()
            deserializeWith = CreateTagOptionOperationDeserializer()
            operationName = "CreateTagOption"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun deleteConstraint(input: DeleteConstraintRequest): DeleteConstraintResponse {
        val op = SdkHttpOperation.build<DeleteConstraintRequest, DeleteConstraintResponse> {
            serializeWith = DeleteConstraintOperationSerializer()
            deserializeWith = DeleteConstraintOperationDeserializer()
            operationName = "DeleteConstraint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified portfolio.
     *
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or shared accounts.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun deletePortfolio(input: DeletePortfolioRequest): DeletePortfolioResponse {
        val op = SdkHttpOperation.build<DeletePortfolioRequest, DeletePortfolioResponse> {
            serializeWith = DeletePortfolioOperationSerializer()
            deserializeWith = DeletePortfolioOperationDeserializer()
            operationName = "DeletePortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization node can only be deleted by the management account of an organization or by a delegated administrator.
     *
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     */
    override suspend fun deletePortfolioShare(input: DeletePortfolioShareRequest): DeletePortfolioShareResponse {
        val op = SdkHttpOperation.build<DeletePortfolioShareRequest, DeletePortfolioShareResponse> {
            serializeWith = DeletePortfolioShareOperationSerializer()
            deserializeWith = DeletePortfolioShareOperationDeserializer()
            operationName = "DeletePortfolioShare"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified product.
     *
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun deleteProduct(input: DeleteProductRequest): DeleteProductResponse {
        val op = SdkHttpOperation.build<DeleteProductRequest, DeleteProductResponse> {
            serializeWith = DeleteProductOperationSerializer()
            deserializeWith = DeleteProductOperationDeserializer()
            operationName = "DeleteProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified plan.
     */
    override suspend fun deleteProvisionedProductPlan(input: DeleteProvisionedProductPlanRequest): DeleteProvisionedProductPlanResponse {
        val op = SdkHttpOperation.build<DeleteProvisionedProductPlanRequest, DeleteProvisionedProductPlanResponse> {
            serializeWith = DeleteProvisionedProductPlanOperationSerializer()
            deserializeWith = DeleteProvisionedProductPlanOperationDeserializer()
            operationName = "DeleteProvisionedProductPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     */
    override suspend fun deleteProvisioningArtifact(input: DeleteProvisioningArtifactRequest): DeleteProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<DeleteProvisioningArtifactRequest, DeleteProvisioningArtifactResponse> {
            serializeWith = DeleteProvisioningArtifactOperationSerializer()
            deserializeWith = DeleteProvisioningArtifactOperationDeserializer()
            operationName = "DeleteProvisioningArtifact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a self-service action.
     */
    override suspend fun deleteServiceAction(input: DeleteServiceActionRequest): DeleteServiceActionResponse {
        val op = SdkHttpOperation.build<DeleteServiceActionRequest, DeleteServiceActionResponse> {
            serializeWith = DeleteServiceActionOperationSerializer()
            deserializeWith = DeleteServiceActionOperationDeserializer()
            operationName = "DeleteServiceAction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified TagOption.
     *
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     */
    override suspend fun deleteTagOption(input: DeleteTagOptionRequest): DeleteTagOptionResponse {
        val op = SdkHttpOperation.build<DeleteTagOptionRequest, DeleteTagOptionResponse> {
            serializeWith = DeleteTagOptionOperationSerializer()
            deserializeWith = DeleteTagOptionOperationDeserializer()
            operationName = "DeleteTagOption"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified constraint.
     */
    override suspend fun describeConstraint(input: DescribeConstraintRequest): DescribeConstraintResponse {
        val op = SdkHttpOperation.build<DescribeConstraintRequest, DescribeConstraintResponse> {
            serializeWith = DescribeConstraintOperationSerializer()
            deserializeWith = DescribeConstraintOperationDeserializer()
            operationName = "DescribeConstraint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of the specified copy product operation.
     */
    override suspend fun describeCopyProductStatus(input: DescribeCopyProductStatusRequest): DescribeCopyProductStatusResponse {
        val op = SdkHttpOperation.build<DescribeCopyProductStatusRequest, DescribeCopyProductStatusResponse> {
            serializeWith = DescribeCopyProductStatusOperationSerializer()
            deserializeWith = DescribeCopyProductStatusOperationDeserializer()
            operationName = "DescribeCopyProductStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun describePortfolio(input: DescribePortfolioRequest): DescribePortfolioResponse {
        val op = SdkHttpOperation.build<DescribePortfolioRequest, DescribePortfolioResponse> {
            serializeWith = DescribePortfolioOperationSerializer()
            deserializeWith = DescribePortfolioOperationDeserializer()
            operationName = "DescribePortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account in the organization or by a delegated admin.
     */
    override suspend fun describePortfolioShareStatus(input: DescribePortfolioShareStatusRequest): DescribePortfolioShareStatusResponse {
        val op = SdkHttpOperation.build<DescribePortfolioShareStatusRequest, DescribePortfolioShareStatusResponse> {
            serializeWith = DescribePortfolioShareStatusOperationSerializer()
            deserializeWith = DescribePortfolioShareStatusOperationDeserializer()
            operationName = "DescribePortfolioShareStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     *
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether the recipient entity has imported the share, and whether TagOptions are included with the share.
     *
     * The `PortfolioId` and `Type` parameters are both required.
     */
    override suspend fun describePortfolioShares(input: DescribePortfolioSharesRequest): DescribePortfolioSharesResponse {
        val op = SdkHttpOperation.build<DescribePortfolioSharesRequest, DescribePortfolioSharesResponse> {
            serializeWith = DescribePortfolioSharesOperationSerializer()
            deserializeWith = DescribePortfolioSharesOperationDeserializer()
            operationName = "DescribePortfolioShares"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified product.
     *
     *  Running this operation with administrator access results in a failure. DescribeProductAsAdmin should be used instead.
     */
    override suspend fun describeProduct(input: DescribeProductRequest): DescribeProductResponse {
        val op = SdkHttpOperation.build<DescribeProductRequest, DescribeProductResponse> {
            serializeWith = DescribeProductOperationSerializer()
            deserializeWith = DescribeProductOperationDeserializer()
            operationName = "DescribeProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified product. This operation is run with administrator access.
     */
    override suspend fun describeProductAsAdmin(input: DescribeProductAsAdminRequest): DescribeProductAsAdminResponse {
        val op = SdkHttpOperation.build<DescribeProductAsAdminRequest, DescribeProductAsAdminResponse> {
            serializeWith = DescribeProductAsAdminOperationSerializer()
            deserializeWith = DescribeProductAsAdminOperationDeserializer()
            operationName = "DescribeProductAsAdmin"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified product.
     */
    override suspend fun describeProductView(input: DescribeProductViewRequest): DescribeProductViewResponse {
        val op = SdkHttpOperation.build<DescribeProductViewRequest, DescribeProductViewResponse> {
            serializeWith = DescribeProductViewOperationSerializer()
            deserializeWith = DescribeProductViewOperationDeserializer()
            operationName = "DescribeProductView"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified provisioned product.
     */
    override suspend fun describeProvisionedProduct(input: DescribeProvisionedProductRequest): DescribeProvisionedProductResponse {
        val op = SdkHttpOperation.build<DescribeProvisionedProductRequest, DescribeProvisionedProductResponse> {
            serializeWith = DescribeProvisionedProductOperationSerializer()
            deserializeWith = DescribeProvisionedProductOperationDeserializer()
            operationName = "DescribeProvisionedProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the resource changes for the specified plan.
     */
    override suspend fun describeProvisionedProductPlan(input: DescribeProvisionedProductPlanRequest): DescribeProvisionedProductPlanResponse {
        val op = SdkHttpOperation.build<DescribeProvisionedProductPlanRequest, DescribeProvisionedProductPlanResponse> {
            serializeWith = DescribeProvisionedProductPlanOperationSerializer()
            deserializeWith = DescribeProvisionedProductPlanOperationDeserializer()
            operationName = "DescribeProvisionedProductPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     */
    override suspend fun describeProvisioningArtifact(input: DescribeProvisioningArtifactRequest): DescribeProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<DescribeProvisioningArtifactRequest, DescribeProvisioningArtifactResponse> {
            serializeWith = DescribeProvisioningArtifactOperationSerializer()
            deserializeWith = DescribeProvisioningArtifactOperationDeserializer()
            operationName = "DescribeProvisioningArtifact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the configuration required to provision the specified product using the specified provisioning artifact.
     *
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key. The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to ProvisionProduct, do not include conflicted TagOption keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*". Tag the provisioned product with the value `sc-tagoption-conflict-portfolioId-productId`.
     */
    override suspend fun describeProvisioningParameters(input: DescribeProvisioningParametersRequest): DescribeProvisioningParametersResponse {
        val op = SdkHttpOperation.build<DescribeProvisioningParametersRequest, DescribeProvisioningParametersResponse> {
            serializeWith = DescribeProvisioningParametersOperationSerializer()
            deserializeWith = DescribeProvisioningParametersOperationDeserializer()
            operationName = "DescribeProvisioningParameters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified request operation.
     *
     * Use this operation after calling a request operation (for example, ProvisionProduct, TerminateProvisionedProduct, or UpdateProvisionedProduct).
     *
     * If a provisioned product was transferred to a new owner using UpdateProvisionedProductProperties, the new owner will be able to describe all past records for that product. The previous owner will no longer be able to describe the records, but will be able to use ListRecordHistory to see the product's history from when he was the owner.
     */
    override suspend fun describeRecord(input: DescribeRecordRequest): DescribeRecordResponse {
        val op = SdkHttpOperation.build<DescribeRecordRequest, DescribeRecordResponse> {
            serializeWith = DescribeRecordOperationSerializer()
            deserializeWith = DescribeRecordOperationDeserializer()
            operationName = "DescribeRecord"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Describes a self-service action.
     */
    override suspend fun describeServiceAction(input: DescribeServiceActionRequest): DescribeServiceActionResponse {
        val op = SdkHttpOperation.build<DescribeServiceActionRequest, DescribeServiceActionResponse> {
            serializeWith = DescribeServiceActionOperationSerializer()
            deserializeWith = DescribeServiceActionOperationDeserializer()
            operationName = "DescribeServiceAction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.
     */
    override suspend fun describeServiceActionExecutionParameters(input: DescribeServiceActionExecutionParametersRequest): DescribeServiceActionExecutionParametersResponse {
        val op = SdkHttpOperation.build<DescribeServiceActionExecutionParametersRequest, DescribeServiceActionExecutionParametersResponse> {
            serializeWith = DescribeServiceActionExecutionParametersOperationSerializer()
            deserializeWith = DescribeServiceActionExecutionParametersOperationDeserializer()
            operationName = "DescribeServiceActionExecutionParameters"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the specified TagOption.
     */
    override suspend fun describeTagOption(input: DescribeTagOptionRequest): DescribeTagOptionResponse {
        val op = SdkHttpOperation.build<DescribeTagOptionRequest, DescribeTagOptionResponse> {
            serializeWith = DescribeTagOptionOperationSerializer()
            deserializeWith = DescribeTagOptionOperationDeserializer()
            operationName = "DescribeTagOption"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disable portfolio sharing through the Organizations service. This command will not delete your current shares, but prevents you from creating new shares throughout your organization. Current shares are not kept in sync with your organization structure if the structure changes after calling this API. Only the management account in the organization can call this API.
     *
     * You cannot call this API if there are active delegated administrators in the organization.
     *
     * Note that a delegated administrator is not authorized to invoke `DisableAWSOrganizationsAccess`.
     *
     * If you share an Service Catalog portfolio in an organization within Organizations, and then disable Organizations access for Service Catalog, the portfolio access permissions will not sync with the latest changes to the organization structure. Specifically, accounts that you removed from the organization after disabling Service Catalog access will retain access to the previously shared portfolio.
     */
    override suspend fun disableAwsOrganizationsAccess(input: DisableAwsOrganizationsAccessRequest): DisableAwsOrganizationsAccessResponse {
        val op = SdkHttpOperation.build<DisableAwsOrganizationsAccessRequest, DisableAwsOrganizationsAccessResponse> {
            serializeWith = DisableAWSOrganizationsAccessOperationSerializer()
            deserializeWith = DisableAWSOrganizationsAccessOperationDeserializer()
            operationName = "DisableAWSOrganizationsAccess"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified budget from the specified resource.
     */
    override suspend fun disassociateBudgetFromResource(input: DisassociateBudgetFromResourceRequest): DisassociateBudgetFromResourceResponse {
        val op = SdkHttpOperation.build<DisassociateBudgetFromResourceRequest, DisassociateBudgetFromResourceResponse> {
            serializeWith = DisassociateBudgetFromResourceOperationSerializer()
            deserializeWith = DisassociateBudgetFromResourceOperationDeserializer()
            operationName = "DisassociateBudgetFromResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a previously associated principal ARN from a specified portfolio.
     *
     * The `PrincipalType` and `PrincipalARN` must match the `AssociatePrincipalWithPortfolio` call request details. For example, to disassociate an association created with a `PrincipalARN` of `PrincipalType` IAM you must use the `PrincipalType` IAM when calling `DisassociatePrincipalFromPortfolio`.
     *
     * For portfolios that have been shared with principal name sharing enabled: after disassociating a principal, share recipient accounts will no longer be able to provision products in this portfolio using a role matching the name of the associated principal.
     *
     * For more information, review [associate-principal-with-portfolio](https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options) in the Amazon Web Services CLI Command Reference.
     *
     * If you disassociate a principal from a portfolio, with PrincipalType as `IAM`, the same principal will still have access to the portfolio if it matches one of the associated principals of type `IAM_PATTERN`. To fully remove access for a principal, verify all the associated Principals of type `IAM_PATTERN`, and then ensure you disassociate any `IAM_PATTERN` principals that match the principal whose access you are removing.
     */
    override suspend fun disassociatePrincipalFromPortfolio(input: DisassociatePrincipalFromPortfolioRequest): DisassociatePrincipalFromPortfolioResponse {
        val op = SdkHttpOperation.build<DisassociatePrincipalFromPortfolioRequest, DisassociatePrincipalFromPortfolioResponse> {
            serializeWith = DisassociatePrincipalFromPortfolioOperationSerializer()
            deserializeWith = DisassociatePrincipalFromPortfolioOperationDeserializer()
            operationName = "DisassociatePrincipalFromPortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified product from the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    override suspend fun disassociateProductFromPortfolio(input: DisassociateProductFromPortfolioRequest): DisassociateProductFromPortfolioResponse {
        val op = SdkHttpOperation.build<DisassociateProductFromPortfolioRequest, DisassociateProductFromPortfolioResponse> {
            serializeWith = DisassociateProductFromPortfolioOperationSerializer()
            deserializeWith = DisassociateProductFromPortfolioOperationDeserializer()
            operationName = "DisassociateProductFromPortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     */
    override suspend fun disassociateServiceActionFromProvisioningArtifact(input: DisassociateServiceActionFromProvisioningArtifactRequest): DisassociateServiceActionFromProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<DisassociateServiceActionFromProvisioningArtifactRequest, DisassociateServiceActionFromProvisioningArtifactResponse> {
            serializeWith = DisassociateServiceActionFromProvisioningArtifactOperationSerializer()
            deserializeWith = DisassociateServiceActionFromProvisioningArtifactOperationDeserializer()
            operationName = "DisassociateServiceActionFromProvisioningArtifact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates the specified TagOption from the specified resource.
     */
    override suspend fun disassociateTagOptionFromResource(input: DisassociateTagOptionFromResourceRequest): DisassociateTagOptionFromResourceResponse {
        val op = SdkHttpOperation.build<DisassociateTagOptionFromResourceRequest, DisassociateTagOptionFromResourceResponse> {
            serializeWith = DisassociateTagOptionFromResourceOperationSerializer()
            deserializeWith = DisassociateTagOptionFromResourceOperationDeserializer()
            operationName = "DisassociateTagOptionFromResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Enable portfolio sharing feature through Organizations. This API will allow Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This API can only be called by the management account in the organization.
     *
     * When you call this API, Service Catalog calls `organizations:EnableAWSServiceAccess` on your behalf so that your shares stay in sync with any changes in your Organizations structure.
     *
     * Note that a delegated administrator is not authorized to invoke `EnableAWSOrganizationsAccess`.
     *
     * If you have previously disabled Organizations access for Service Catalog, and then enable access again, the portfolio access permissions might not sync with the latest changes to the organization structure. Specifically, accounts that you removed from the organization after disabling Service Catalog access, and before you enabled access again, can retain access to the previously shared portfolio. As a result, an account that has been removed from the organization might still be able to create or manage Amazon Web Services resources when it is no longer authorized to do so. Amazon Web Services is working to resolve this issue.
     */
    override suspend fun enableAwsOrganizationsAccess(input: EnableAwsOrganizationsAccessRequest): EnableAwsOrganizationsAccessResponse {
        val op = SdkHttpOperation.build<EnableAwsOrganizationsAccessRequest, EnableAwsOrganizationsAccessResponse> {
            serializeWith = EnableAWSOrganizationsAccessOperationSerializer()
            deserializeWith = EnableAWSOrganizationsAccessOperationDeserializer()
            operationName = "EnableAWSOrganizationsAccess"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provisions or modifies a product based on the resource changes for the specified plan.
     */
    override suspend fun executeProvisionedProductPlan(input: ExecuteProvisionedProductPlanRequest): ExecuteProvisionedProductPlanResponse {
        val op = SdkHttpOperation.build<ExecuteProvisionedProductPlanRequest, ExecuteProvisionedProductPlanResponse> {
            serializeWith = ExecuteProvisionedProductPlanOperationSerializer()
            deserializeWith = ExecuteProvisionedProductPlanOperationDeserializer()
            operationName = "ExecuteProvisionedProductPlan"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Executes a self-service action against a provisioned product.
     */
    override suspend fun executeProvisionedProductServiceAction(input: ExecuteProvisionedProductServiceActionRequest): ExecuteProvisionedProductServiceActionResponse {
        val op = SdkHttpOperation.build<ExecuteProvisionedProductServiceActionRequest, ExecuteProvisionedProductServiceActionResponse> {
            serializeWith = ExecuteProvisionedProductServiceActionOperationSerializer()
            deserializeWith = ExecuteProvisionedProductServiceActionOperationDeserializer()
            operationName = "ExecuteProvisionedProductServiceAction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management account in the organization or by a delegated admin.
     */
    override suspend fun getAwsOrganizationsAccessStatus(input: GetAwsOrganizationsAccessStatusRequest): GetAwsOrganizationsAccessStatusResponse {
        val op = SdkHttpOperation.build<GetAwsOrganizationsAccessStatusRequest, GetAwsOrganizationsAccessStatusResponse> {
            serializeWith = GetAWSOrganizationsAccessStatusOperationSerializer()
            deserializeWith = GetAWSOrganizationsAccessStatusOperationDeserializer()
            operationName = "GetAWSOrganizationsAccessStatus"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * This API takes either a `ProvisonedProductId` or a `ProvisionedProductName`, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.
     */
    override suspend fun getProvisionedProductOutputs(input: GetProvisionedProductOutputsRequest): GetProvisionedProductOutputsResponse {
        val op = SdkHttpOperation.build<GetProvisionedProductOutputsRequest, GetProvisionedProductOutputsResponse> {
            serializeWith = GetProvisionedProductOutputsOperationSerializer()
            deserializeWith = GetProvisionedProductOutputsOperationDeserializer()
            operationName = "GetProvisionedProductOutputs"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Requests the import of a resource as an Service Catalog provisioned product that is associated to an Service Catalog product and provisioning artifact. Once imported, all supported governance actions are supported on the provisioned product.
     *
     *  Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets, and non-root nested stacks, are not supported.
     *
     *  The CloudFormation stack must have one of the following statuses to be imported: `CREATE_COMPLETE`, `UPDATE_COMPLETE`, `UPDATE_ROLLBACK_COMPLETE`, `IMPORT_COMPLETE`, and `IMPORT_ROLLBACK_COMPLETE`.
     *
     *  Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog product provisioning artifact.
     *
     *  When you import an existing CloudFormation stack into a portfolio, Service Catalog does not apply the product's associated constraints during the import process. Service Catalog applies the constraints after you call `UpdateProvisionedProduct` for the provisioned product.
     *
     *  The user or role that performs this operation must have the `cloudformation:GetTemplate` and `cloudformation:DescribeStacks` IAM policy permissions.
     *
     * You can only import one provisioned product at a time. The product's CloudFormation stack must have the `IMPORT_COMPLETE` status before you import another.
     */
    override suspend fun importAsProvisionedProduct(input: ImportAsProvisionedProductRequest): ImportAsProvisionedProductResponse {
        val op = SdkHttpOperation.build<ImportAsProvisionedProductRequest, ImportAsProvisionedProductResponse> {
            serializeWith = ImportAsProvisionedProductOperationSerializer()
            deserializeWith = ImportAsProvisionedProductOperationDeserializer()
            operationName = "ImportAsProvisionedProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying the `PortfolioShareType`, you can list portfolios for which organizational shares were accepted by this account.
     */
    override suspend fun listAcceptedPortfolioShares(input: ListAcceptedPortfolioSharesRequest): ListAcceptedPortfolioSharesResponse {
        val op = SdkHttpOperation.build<ListAcceptedPortfolioSharesRequest, ListAcceptedPortfolioSharesResponse> {
            serializeWith = ListAcceptedPortfolioSharesOperationSerializer()
            deserializeWith = ListAcceptedPortfolioSharesOperationDeserializer()
            operationName = "ListAcceptedPortfolioShares"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the budgets associated to the specified resource.
     */
    override suspend fun listBudgetsForResource(input: ListBudgetsForResourceRequest): ListBudgetsForResourceResponse {
        val op = SdkHttpOperation.build<ListBudgetsForResourceRequest, ListBudgetsForResourceResponse> {
            serializeWith = ListBudgetsForResourceOperationSerializer()
            deserializeWith = ListBudgetsForResourceOperationDeserializer()
            operationName = "ListBudgetsForResource"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the constraints for the specified portfolio and product.
     */
    override suspend fun listConstraintsForPortfolio(input: ListConstraintsForPortfolioRequest): ListConstraintsForPortfolioResponse {
        val op = SdkHttpOperation.build<ListConstraintsForPortfolioRequest, ListConstraintsForPortfolioResponse> {
            serializeWith = ListConstraintsForPortfolioOperationSerializer()
            deserializeWith = ListConstraintsForPortfolioOperationDeserializer()
            operationName = "ListConstraintsForPortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is necessary when provisioning a product. A path also determines the constraints that are put on a product. A path is dependent on a specific product, porfolio, and principal.
     *
     *  When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to the portfolio. For more information, see [Granting users access](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html) in the *Service Catalog User Guide*.
     */
    override suspend fun listLaunchPaths(input: ListLaunchPathsRequest): ListLaunchPathsResponse {
        val op = SdkHttpOperation.build<ListLaunchPathsRequest, ListLaunchPathsResponse> {
            serializeWith = ListLaunchPathsOperationSerializer()
            deserializeWith = ListLaunchPathsOperationDeserializer()
            operationName = "ListLaunchPaths"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the management account in the organization or by a delegated admin.
     *
     * If a delegated admin is de-registered, they can no longer perform this operation.
     */
    override suspend fun listOrganizationPortfolioAccess(input: ListOrganizationPortfolioAccessRequest): ListOrganizationPortfolioAccessResponse {
        val op = SdkHttpOperation.build<ListOrganizationPortfolioAccessRequest, ListOrganizationPortfolioAccessResponse> {
            serializeWith = ListOrganizationPortfolioAccessOperationSerializer()
            deserializeWith = ListOrganizationPortfolioAccessOperationDeserializer()
            operationName = "ListOrganizationPortfolioAccess"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the account IDs that have access to the specified portfolio.
     *
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin is de-registered, they can no longer perform this operation.
     */
    override suspend fun listPortfolioAccess(input: ListPortfolioAccessRequest): ListPortfolioAccessResponse {
        val op = SdkHttpOperation.build<ListPortfolioAccessRequest, ListPortfolioAccessResponse> {
            serializeWith = ListPortfolioAccessOperationSerializer()
            deserializeWith = ListPortfolioAccessOperationDeserializer()
            operationName = "ListPortfolioAccess"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all portfolios in the catalog.
     */
    override suspend fun listPortfolios(input: ListPortfoliosRequest): ListPortfoliosResponse {
        val op = SdkHttpOperation.build<ListPortfoliosRequest, ListPortfoliosResponse> {
            serializeWith = ListPortfoliosOperationSerializer()
            deserializeWith = ListPortfoliosOperationDeserializer()
            operationName = "ListPortfolios"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all portfolios that the specified product is associated with.
     */
    override suspend fun listPortfoliosForProduct(input: ListPortfoliosForProductRequest): ListPortfoliosForProductResponse {
        val op = SdkHttpOperation.build<ListPortfoliosForProductRequest, ListPortfoliosForProductResponse> {
            serializeWith = ListPortfoliosForProductOperationSerializer()
            deserializeWith = ListPortfoliosForProductOperationDeserializer()
            operationName = "ListPortfoliosForProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all `PrincipalARN`s and corresponding `PrincipalType`s associated with the specified portfolio.
     */
    override suspend fun listPrincipalsForPortfolio(input: ListPrincipalsForPortfolioRequest): ListPrincipalsForPortfolioResponse {
        val op = SdkHttpOperation.build<ListPrincipalsForPortfolioRequest, ListPrincipalsForPortfolioResponse> {
            serializeWith = ListPrincipalsForPortfolioOperationSerializer()
            deserializeWith = ListPrincipalsForPortfolioOperationDeserializer()
            operationName = "ListPrincipalsForPortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     */
    override suspend fun listProvisionedProductPlans(input: ListProvisionedProductPlansRequest): ListProvisionedProductPlansResponse {
        val op = SdkHttpOperation.build<ListProvisionedProductPlansRequest, ListProvisionedProductPlansResponse> {
            serializeWith = ListProvisionedProductPlansOperationSerializer()
            deserializeWith = ListProvisionedProductPlansOperationDeserializer()
            operationName = "ListProvisionedProductPlans"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     */
    override suspend fun listProvisioningArtifacts(input: ListProvisioningArtifactsRequest): ListProvisioningArtifactsResponse {
        val op = SdkHttpOperation.build<ListProvisioningArtifactsRequest, ListProvisioningArtifactsResponse> {
            serializeWith = ListProvisioningArtifactsOperationSerializer()
            deserializeWith = ListProvisioningArtifactsOperationDeserializer()
            operationName = "ListProvisioningArtifacts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     */
    override suspend fun listProvisioningArtifactsForServiceAction(input: ListProvisioningArtifactsForServiceActionRequest): ListProvisioningArtifactsForServiceActionResponse {
        val op = SdkHttpOperation.build<ListProvisioningArtifactsForServiceActionRequest, ListProvisioningArtifactsForServiceActionResponse> {
            serializeWith = ListProvisioningArtifactsForServiceActionOperationSerializer()
            deserializeWith = ListProvisioningArtifactsForServiceActionOperationDeserializer()
            operationName = "ListProvisioningArtifactsForServiceAction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the specified requests or all performed requests.
     */
    override suspend fun listRecordHistory(input: ListRecordHistoryRequest): ListRecordHistoryResponse {
        val op = SdkHttpOperation.build<ListRecordHistoryRequest, ListRecordHistoryResponse> {
            serializeWith = ListRecordHistoryOperationSerializer()
            deserializeWith = ListRecordHistoryOperationDeserializer()
            operationName = "ListRecordHistory"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the resources associated with the specified TagOption.
     */
    override suspend fun listResourcesForTagOption(input: ListResourcesForTagOptionRequest): ListResourcesForTagOptionResponse {
        val op = SdkHttpOperation.build<ListResourcesForTagOptionRequest, ListResourcesForTagOptionResponse> {
            serializeWith = ListResourcesForTagOptionOperationSerializer()
            deserializeWith = ListResourcesForTagOptionOperationDeserializer()
            operationName = "ListResourcesForTagOption"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists all self-service actions.
     */
    override suspend fun listServiceActions(input: ListServiceActionsRequest): ListServiceActionsResponse {
        val op = SdkHttpOperation.build<ListServiceActionsRequest, ListServiceActionsResponse> {
            serializeWith = ListServiceActionsOperationSerializer()
            deserializeWith = ListServiceActionsOperationDeserializer()
            operationName = "ListServiceActions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.
     */
    override suspend fun listServiceActionsForProvisioningArtifact(input: ListServiceActionsForProvisioningArtifactRequest): ListServiceActionsForProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<ListServiceActionsForProvisioningArtifactRequest, ListServiceActionsForProvisioningArtifactResponse> {
            serializeWith = ListServiceActionsForProvisioningArtifactOperationSerializer()
            deserializeWith = ListServiceActionsForProvisioningArtifactOperationDeserializer()
            operationName = "ListServiceActionsForProvisioningArtifact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Returns summary information about stack instances that are associated with the specified `CFN_STACKSET` type provisioned product. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region.
     */
    override suspend fun listStackInstancesForProvisionedProduct(input: ListStackInstancesForProvisionedProductRequest): ListStackInstancesForProvisionedProductResponse {
        val op = SdkHttpOperation.build<ListStackInstancesForProvisionedProductRequest, ListStackInstancesForProvisionedProductResponse> {
            serializeWith = ListStackInstancesForProvisionedProductOperationSerializer()
            deserializeWith = ListStackInstancesForProvisionedProductOperationDeserializer()
            operationName = "ListStackInstancesForProvisionedProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the specified TagOptions or all TagOptions.
     */
    override suspend fun listTagOptions(input: ListTagOptionsRequest): ListTagOptionsResponse {
        val op = SdkHttpOperation.build<ListTagOptionsRequest, ListTagOptionsResponse> {
            serializeWith = ListTagOptionsOperationSerializer()
            deserializeWith = ListTagOptionsOperationDeserializer()
            operationName = "ListTagOptions"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Notifies the result of the provisioning engine execution.
     */
    override suspend fun notifyProvisionProductEngineWorkflowResult(input: NotifyProvisionProductEngineWorkflowResultRequest): NotifyProvisionProductEngineWorkflowResultResponse {
        val op = SdkHttpOperation.build<NotifyProvisionProductEngineWorkflowResultRequest, NotifyProvisionProductEngineWorkflowResultResponse> {
            serializeWith = NotifyProvisionProductEngineWorkflowResultOperationSerializer()
            deserializeWith = NotifyProvisionProductEngineWorkflowResultOperationDeserializer()
            operationName = "NotifyProvisionProductEngineWorkflowResult"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Notifies the result of the terminate engine execution.
     */
    override suspend fun notifyTerminateProvisionedProductEngineWorkflowResult(input: NotifyTerminateProvisionedProductEngineWorkflowResultRequest): NotifyTerminateProvisionedProductEngineWorkflowResultResponse {
        val op = SdkHttpOperation.build<NotifyTerminateProvisionedProductEngineWorkflowResultRequest, NotifyTerminateProvisionedProductEngineWorkflowResultResponse> {
            serializeWith = NotifyTerminateProvisionedProductEngineWorkflowResultOperationSerializer()
            deserializeWith = NotifyTerminateProvisionedProductEngineWorkflowResultOperationDeserializer()
            operationName = "NotifyTerminateProvisionedProductEngineWorkflowResult"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Notifies the result of the update engine execution.
     */
    override suspend fun notifyUpdateProvisionedProductEngineWorkflowResult(input: NotifyUpdateProvisionedProductEngineWorkflowResultRequest): NotifyUpdateProvisionedProductEngineWorkflowResultResponse {
        val op = SdkHttpOperation.build<NotifyUpdateProvisionedProductEngineWorkflowResultRequest, NotifyUpdateProvisionedProductEngineWorkflowResultResponse> {
            serializeWith = NotifyUpdateProvisionedProductEngineWorkflowResultOperationSerializer()
            deserializeWith = NotifyUpdateProvisionedProductEngineWorkflowResultOperationDeserializer()
            operationName = "NotifyUpdateProvisionedProductEngineWorkflowResult"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Provisions the specified product.
     *
     *  A provisioned product is a resourced instance of a product. For example, provisioning a product that's based on an CloudFormation template launches an CloudFormation stack and its underlying resources. You can check the status of this request using DescribeRecord.
     *
     *  If the request contains a tag key with an empty list of values, there's a tag conflict for that key. Don't include conflicted keys as tags, or this will cause the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*".
     *
     *  When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to the portfolio. For more information, see [Granting users access](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html) in the *Service Catalog User Guide*.
     */
    override suspend fun provisionProduct(input: ProvisionProductRequest): ProvisionProductResponse {
        val op = SdkHttpOperation.build<ProvisionProductRequest, ProvisionProductResponse> {
            serializeWith = ProvisionProductOperationSerializer()
            deserializeWith = ProvisionProductOperationDeserializer()
            operationName = "ProvisionProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Rejects an offer to share the specified portfolio.
     */
    override suspend fun rejectPortfolioShare(input: RejectPortfolioShareRequest): RejectPortfolioShareResponse {
        val op = SdkHttpOperation.build<RejectPortfolioShareRequest, RejectPortfolioShareResponse> {
            serializeWith = RejectPortfolioShareOperationSerializer()
            deserializeWith = RejectPortfolioShareOperationDeserializer()
            operationName = "RejectPortfolioShare"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Lists the provisioned products that are available (not terminated).
     *
     * To use additional filtering, see SearchProvisionedProducts.
     */
    override suspend fun scanProvisionedProducts(input: ScanProvisionedProductsRequest): ScanProvisionedProductsResponse {
        val op = SdkHttpOperation.build<ScanProvisionedProductsRequest, ScanProvisionedProductsResponse> {
            serializeWith = ScanProvisionedProductsOperationSerializer()
            deserializeWith = ScanProvisionedProductsOperationDeserializer()
            operationName = "ScanProvisionedProducts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the products to which the caller has access.
     */
    override suspend fun searchProducts(input: SearchProductsRequest): SearchProductsResponse {
        val op = SdkHttpOperation.build<SearchProductsRequest, SearchProductsResponse> {
            serializeWith = SearchProductsOperationSerializer()
            deserializeWith = SearchProductsOperationDeserializer()
            operationName = "SearchProducts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the products for the specified portfolio or all products.
     */
    override suspend fun searchProductsAsAdmin(input: SearchProductsAsAdminRequest): SearchProductsAsAdminResponse {
        val op = SdkHttpOperation.build<SearchProductsAsAdminRequest, SearchProductsAsAdminResponse> {
            serializeWith = SearchProductsAsAdminOperationSerializer()
            deserializeWith = SearchProductsAsAdminOperationDeserializer()
            operationName = "SearchProductsAsAdmin"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Gets information about the provisioned products that meet the specified criteria.
     */
    override suspend fun searchProvisionedProducts(input: SearchProvisionedProductsRequest): SearchProvisionedProductsResponse {
        val op = SdkHttpOperation.build<SearchProvisionedProductsRequest, SearchProvisionedProductsResponse> {
            serializeWith = SearchProvisionedProductsOperationSerializer()
            deserializeWith = SearchProvisionedProductsOperationDeserializer()
            operationName = "SearchProvisionedProducts"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Terminates the specified provisioned product.
     *
     * This operation does not delete any records associated with the provisioned product.
     *
     * You can check the status of this request using DescribeRecord.
     */
    override suspend fun terminateProvisionedProduct(input: TerminateProvisionedProductRequest): TerminateProvisionedProductResponse {
        val op = SdkHttpOperation.build<TerminateProvisionedProductRequest, TerminateProvisionedProductResponse> {
            serializeWith = TerminateProvisionedProductOperationSerializer()
            deserializeWith = TerminateProvisionedProductOperationDeserializer()
            operationName = "TerminateProvisionedProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified constraint.
     */
    override suspend fun updateConstraint(input: UpdateConstraintRequest): UpdateConstraintResponse {
        val op = SdkHttpOperation.build<UpdateConstraintRequest, UpdateConstraintResponse> {
            serializeWith = UpdateConstraintOperationSerializer()
            deserializeWith = UpdateConstraintOperationDeserializer()
            operationName = "UpdateConstraint"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified portfolio.
     *
     * You cannot update a product that was shared with you.
     */
    override suspend fun updatePortfolio(input: UpdatePortfolioRequest): UpdatePortfolioResponse {
        val op = SdkHttpOperation.build<UpdatePortfolioRequest, UpdatePortfolioResponse> {
            serializeWith = UpdatePortfolioOperationSerializer()
            deserializeWith = UpdatePortfolioOperationDeserializer()
            operationName = "UpdatePortfolio"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified portfolio share. You can use this API to enable or disable `TagOptions` sharing or Principal sharing for an existing portfolio share.
     *
     * The portfolio share cannot be updated if the `CreatePortfolioShare` operation is `IN_PROGRESS`, as the share is not available to recipient entities. In this case, you must wait for the portfolio share to be completed.
     *
     * You must provide the `accountId` or organization node in the input, but not both.
     *
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be updated, you must invoke `UpdatePortfolioShare` separately for each share type.
     *
     * This API cannot be used for removing the portfolio share. You must use `DeletePortfolioShare` API for that action.
     *
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that portfolio is then shared with other accounts. For a user in a recipient account who is *not* an Service Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role that matches a principal name association for the portfolio. Although this user may not know which principal names are associated through Service Catalog, they may be able to guess the user. If this potential escalation path is a concern, then Service Catalog recommends using `PrincipalType` as `IAM`. With this configuration, the `PrincipalARN` must already exist in the recipient account before it can be associated.
     */
    override suspend fun updatePortfolioShare(input: UpdatePortfolioShareRequest): UpdatePortfolioShareResponse {
        val op = SdkHttpOperation.build<UpdatePortfolioShareRequest, UpdatePortfolioShareResponse> {
            serializeWith = UpdatePortfolioShareOperationSerializer()
            deserializeWith = UpdatePortfolioShareOperationDeserializer()
            operationName = "UpdatePortfolioShare"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified product.
     */
    override suspend fun updateProduct(input: UpdateProductRequest): UpdateProductResponse {
        val op = SdkHttpOperation.build<UpdateProductRequest, UpdateProductResponse> {
            serializeWith = UpdateProductOperationSerializer()
            deserializeWith = UpdateProductOperationDeserializer()
            operationName = "UpdateProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Requests updates to the configuration of the specified provisioned product.
     *
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates requested, this operation can update with no interruption, with some interruption, or replace the provisioned product entirely.
     *
     * You can check the status of this request using DescribeRecord.
     */
    override suspend fun updateProvisionedProduct(input: UpdateProvisionedProductRequest): UpdateProvisionedProductResponse {
        val op = SdkHttpOperation.build<UpdateProvisionedProductRequest, UpdateProvisionedProductResponse> {
            serializeWith = UpdateProvisionedProductOperationSerializer()
            deserializeWith = UpdateProvisionedProductOperationDeserializer()
            operationName = "UpdateProvisionedProduct"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Requests updates to the properties of the specified provisioned product.
     */
    override suspend fun updateProvisionedProductProperties(input: UpdateProvisionedProductPropertiesRequest): UpdateProvisionedProductPropertiesResponse {
        val op = SdkHttpOperation.build<UpdateProvisionedProductPropertiesRequest, UpdateProvisionedProductPropertiesResponse> {
            serializeWith = UpdateProvisionedProductPropertiesOperationSerializer()
            deserializeWith = UpdateProvisionedProductPropertiesOperationDeserializer()
            operationName = "UpdateProvisionedProductProperties"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot update a provisioning artifact for a product that was shared with you.
     */
    override suspend fun updateProvisioningArtifact(input: UpdateProvisioningArtifactRequest): UpdateProvisioningArtifactResponse {
        val op = SdkHttpOperation.build<UpdateProvisioningArtifactRequest, UpdateProvisioningArtifactResponse> {
            serializeWith = UpdateProvisioningArtifactOperationSerializer()
            deserializeWith = UpdateProvisioningArtifactOperationDeserializer()
            operationName = "UpdateProvisioningArtifact"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates a self-service action.
     */
    override suspend fun updateServiceAction(input: UpdateServiceActionRequest): UpdateServiceActionResponse {
        val op = SdkHttpOperation.build<UpdateServiceActionRequest, UpdateServiceActionResponse> {
            serializeWith = UpdateServiceActionOperationSerializer()
            deserializeWith = UpdateServiceActionOperationDeserializer()
            operationName = "UpdateServiceAction"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the specified TagOption.
     */
    override suspend fun updateTagOption(input: UpdateTagOptionRequest): UpdateTagOptionResponse {
        val op = SdkHttpOperation.build<UpdateTagOptionRequest, UpdateTagOptionResponse> {
            serializeWith = UpdateTagOptionOperationSerializer()
            deserializeWith = UpdateTagOptionOperationDeserializer()
            operationName = "UpdateTagOption"
            serviceName = ServiceId
            telemetry {
                provider = config.telemetryProvider
                scope = telemetryScope
                metrics = opMetrics
                attributes = attributesOf {
                    "rpc.system" to "aws-api"
                }
            }
            execution.auth = OperationAuthConfig(authSchemeAdapter, configuredAuthSchemes, identityProviderConfig)
            execution.endpointResolver = EndpointResolverAdapter(config)
            execution.retryStrategy = config.retryStrategy
            execution.retryPolicy = config.retryPolicy
        }
        mergeServiceDefaults(op.context)
        op.install(AwsRetryHeaderMiddleware())
        op.interceptors.add(AwsSpanInterceptor)
        op.install(AwsJsonProtocol("AWS242ServiceCatalogService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.interceptors.addAll(config.interceptors)
        return op.roundTrip(client, input)
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.logMode)
        ctx.putIfAbsentNotNull(SdkClientOption.IdempotencyTokenProvider, config.idempotencyTokenProvider)
        ctx.putIfAbsentNotNull(AwsAttributes.Region, config.region)
        ctx.putIfAbsentNotNull(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "servicecatalog")
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }

}
