// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.servicecatalog.auth.DefaultServiceCatalogAuthSchemeProvider
import aws.sdk.kotlin.services.servicecatalog.auth.ServiceCatalogAuthSchemeProvider
import aws.sdk.kotlin.services.servicecatalog.endpoints.DefaultServiceCatalogEndpointProvider
import aws.sdk.kotlin.services.servicecatalog.endpoints.ServiceCatalogEndpointParameters
import aws.sdk.kotlin.services.servicecatalog.endpoints.ServiceCatalogEndpointProvider
import aws.sdk.kotlin.services.servicecatalog.model.AcceptPortfolioShareRequest
import aws.sdk.kotlin.services.servicecatalog.model.AcceptPortfolioShareResponse
import aws.sdk.kotlin.services.servicecatalog.model.AssociateBudgetWithResourceRequest
import aws.sdk.kotlin.services.servicecatalog.model.AssociateBudgetWithResourceResponse
import aws.sdk.kotlin.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.AssociatePrincipalWithPortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.AssociateProductWithPortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.AssociateProductWithPortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.AssociateServiceActionWithProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.AssociateTagOptionWithResourceRequest
import aws.sdk.kotlin.services.servicecatalog.model.AssociateTagOptionWithResourceResponse
import aws.sdk.kotlin.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.BatchAssociateServiceActionWithProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.BatchDisassociateServiceActionFromProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.CopyProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.CopyProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.CreateConstraintRequest
import aws.sdk.kotlin.services.servicecatalog.model.CreateConstraintResponse
import aws.sdk.kotlin.services.servicecatalog.model.CreatePortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.CreatePortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.CreatePortfolioShareRequest
import aws.sdk.kotlin.services.servicecatalog.model.CreatePortfolioShareResponse
import aws.sdk.kotlin.services.servicecatalog.model.CreateProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.CreateProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.CreateProvisionedProductPlanRequest
import aws.sdk.kotlin.services.servicecatalog.model.CreateProvisionedProductPlanResponse
import aws.sdk.kotlin.services.servicecatalog.model.CreateProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.CreateProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.CreateServiceActionRequest
import aws.sdk.kotlin.services.servicecatalog.model.CreateServiceActionResponse
import aws.sdk.kotlin.services.servicecatalog.model.CreateTagOptionRequest
import aws.sdk.kotlin.services.servicecatalog.model.CreateTagOptionResponse
import aws.sdk.kotlin.services.servicecatalog.model.DeleteConstraintRequest
import aws.sdk.kotlin.services.servicecatalog.model.DeleteConstraintResponse
import aws.sdk.kotlin.services.servicecatalog.model.DeletePortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.DeletePortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.DeletePortfolioShareRequest
import aws.sdk.kotlin.services.servicecatalog.model.DeletePortfolioShareResponse
import aws.sdk.kotlin.services.servicecatalog.model.DeleteProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.DeleteProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.DeleteProvisionedProductPlanRequest
import aws.sdk.kotlin.services.servicecatalog.model.DeleteProvisionedProductPlanResponse
import aws.sdk.kotlin.services.servicecatalog.model.DeleteProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.DeleteProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.DeleteServiceActionRequest
import aws.sdk.kotlin.services.servicecatalog.model.DeleteServiceActionResponse
import aws.sdk.kotlin.services.servicecatalog.model.DeleteTagOptionRequest
import aws.sdk.kotlin.services.servicecatalog.model.DeleteTagOptionResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeConstraintRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeConstraintResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeCopyProductStatusRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeCopyProductStatusResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioShareStatusRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioShareStatusResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioSharesRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioSharesResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProductAsAdminRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProductAsAdminResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProductViewRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProductViewResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisionedProductPlanRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisionedProductPlanResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisionedProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisionedProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisioningParametersRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisioningParametersResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeRecordRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeRecordResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeServiceActionExecutionParametersRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeServiceActionExecutionParametersResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeServiceActionRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeServiceActionResponse
import aws.sdk.kotlin.services.servicecatalog.model.DescribeTagOptionRequest
import aws.sdk.kotlin.services.servicecatalog.model.DescribeTagOptionResponse
import aws.sdk.kotlin.services.servicecatalog.model.DisableAwsOrganizationsAccessRequest
import aws.sdk.kotlin.services.servicecatalog.model.DisableAwsOrganizationsAccessResponse
import aws.sdk.kotlin.services.servicecatalog.model.DisassociateBudgetFromResourceRequest
import aws.sdk.kotlin.services.servicecatalog.model.DisassociateBudgetFromResourceResponse
import aws.sdk.kotlin.services.servicecatalog.model.DisassociatePrincipalFromPortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.DisassociatePrincipalFromPortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.DisassociateProductFromPortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.DisassociateProductFromPortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.DisassociateServiceActionFromProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.DisassociateTagOptionFromResourceRequest
import aws.sdk.kotlin.services.servicecatalog.model.DisassociateTagOptionFromResourceResponse
import aws.sdk.kotlin.services.servicecatalog.model.EnableAwsOrganizationsAccessRequest
import aws.sdk.kotlin.services.servicecatalog.model.EnableAwsOrganizationsAccessResponse
import aws.sdk.kotlin.services.servicecatalog.model.ExecuteProvisionedProductPlanRequest
import aws.sdk.kotlin.services.servicecatalog.model.ExecuteProvisionedProductPlanResponse
import aws.sdk.kotlin.services.servicecatalog.model.ExecuteProvisionedProductServiceActionRequest
import aws.sdk.kotlin.services.servicecatalog.model.ExecuteProvisionedProductServiceActionResponse
import aws.sdk.kotlin.services.servicecatalog.model.GetAwsOrganizationsAccessStatusRequest
import aws.sdk.kotlin.services.servicecatalog.model.GetAwsOrganizationsAccessStatusResponse
import aws.sdk.kotlin.services.servicecatalog.model.GetProvisionedProductOutputsRequest
import aws.sdk.kotlin.services.servicecatalog.model.GetProvisionedProductOutputsResponse
import aws.sdk.kotlin.services.servicecatalog.model.ImportAsProvisionedProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.ImportAsProvisionedProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListBudgetsForResourceRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListBudgetsForResourceResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListConstraintsForPortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListConstraintsForPortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListLaunchPathsRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListLaunchPathsResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListOrganizationPortfolioAccessRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListOrganizationPortfolioAccessResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfolioAccessRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfolioAccessResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfoliosForProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfoliosForProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfoliosRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListPortfoliosResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListPrincipalsForPortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListPrincipalsForPortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListProvisionedProductPlansRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListProvisionedProductPlansResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListProvisioningArtifactsForServiceActionResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListProvisioningArtifactsRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListProvisioningArtifactsResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListRecordHistoryRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListRecordHistoryResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListResourcesForTagOptionRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListResourcesForTagOptionResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListServiceActionsForProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListServiceActionsRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListServiceActionsResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListStackInstancesForProvisionedProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListStackInstancesForProvisionedProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.ListTagOptionsRequest
import aws.sdk.kotlin.services.servicecatalog.model.ListTagOptionsResponse
import aws.sdk.kotlin.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultRequest
import aws.sdk.kotlin.services.servicecatalog.model.NotifyProvisionProductEngineWorkflowResultResponse
import aws.sdk.kotlin.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultRequest
import aws.sdk.kotlin.services.servicecatalog.model.NotifyTerminateProvisionedProductEngineWorkflowResultResponse
import aws.sdk.kotlin.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultRequest
import aws.sdk.kotlin.services.servicecatalog.model.NotifyUpdateProvisionedProductEngineWorkflowResultResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProvisionProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.ProvisionProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.RejectPortfolioShareRequest
import aws.sdk.kotlin.services.servicecatalog.model.RejectPortfolioShareResponse
import aws.sdk.kotlin.services.servicecatalog.model.ScanProvisionedProductsRequest
import aws.sdk.kotlin.services.servicecatalog.model.ScanProvisionedProductsResponse
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsAsAdminRequest
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsAsAdminResponse
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsRequest
import aws.sdk.kotlin.services.servicecatalog.model.SearchProductsResponse
import aws.sdk.kotlin.services.servicecatalog.model.SearchProvisionedProductsRequest
import aws.sdk.kotlin.services.servicecatalog.model.SearchProvisionedProductsResponse
import aws.sdk.kotlin.services.servicecatalog.model.TerminateProvisionedProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.TerminateProvisionedProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.UpdateConstraintRequest
import aws.sdk.kotlin.services.servicecatalog.model.UpdateConstraintResponse
import aws.sdk.kotlin.services.servicecatalog.model.UpdatePortfolioRequest
import aws.sdk.kotlin.services.servicecatalog.model.UpdatePortfolioResponse
import aws.sdk.kotlin.services.servicecatalog.model.UpdatePortfolioShareRequest
import aws.sdk.kotlin.services.servicecatalog.model.UpdatePortfolioShareResponse
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductPropertiesRequest
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductPropertiesResponse
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisionedProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisioningArtifactRequest
import aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.UpdateServiceActionRequest
import aws.sdk.kotlin.services.servicecatalog.model.UpdateServiceActionResponse
import aws.sdk.kotlin.services.servicecatalog.model.UpdateTagOptionRequest
import aws.sdk.kotlin.services.servicecatalog.model.UpdateTagOptionResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Service Catalog"
public const val SdkVersion: String = "1.2.6"
public const val ServiceApiVersion: String = "2015-12-10"

/**
 * # Service Catalog
 * [Service Catalog](http://aws.amazon.com/servicecatalog) enables organizations to create and manage catalogs of IT services that are approved for Amazon Web Services. To get the most out of this documentation, you should be familiar with the terminology discussed in [Service Catalog Concepts](http://docs.aws.amazon.com/servicecatalog/latest/adminguide/what-is_concepts.html).
 */
public interface ServiceCatalogClient : SdkClient {
    /**
     * ServiceCatalogClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ServiceCatalogClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ServiceCatalog",
                "SERVICE_CATALOG",
                "service_catalog",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ServiceCatalogClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ServiceCatalogClient = DefaultServiceCatalogClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ServiceCatalogEndpointProvider = builder.endpointProvider ?: DefaultServiceCatalogEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ServiceCatalogAuthSchemeProvider = builder.authSchemeProvider ?: DefaultServiceCatalogAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Service Catalog"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ServiceCatalogEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ServiceCatalogAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts an offer to share the specified portfolio.
     */
    public suspend fun acceptPortfolioShare(input: AcceptPortfolioShareRequest): AcceptPortfolioShareResponse

    /**
     * Associates the specified budget with the specified resource.
     */
    public suspend fun associateBudgetWithResource(input: AssociateBudgetWithResourceRequest): AssociateBudgetWithResourceResponse

    /**
     * Associates the specified principal ARN with the specified portfolio.
     *
     * If you share the portfolio with principal name sharing enabled, the `PrincipalARN` association is included in the share.
     *
     * The `PortfolioID`, `PrincipalARN`, and `PrincipalType` parameters are required.
     *
     * You can associate a maximum of 10 Principals with a portfolio using `PrincipalType` as `IAM_PATTERN`.
     *
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that portfolio is then shared with other accounts. For a user in a recipient account who is *not* an Service Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role that matches a principal name association for the portfolio. Although this user may not know which principal names are associated through Service Catalog, they may be able to guess the user. If this potential escalation path is a concern, then Service Catalog recommends using `PrincipalType` as `IAM`. With this configuration, the `PrincipalARN` must already exist in the recipient account before it can be associated.
     */
    public suspend fun associatePrincipalWithPortfolio(input: AssociatePrincipalWithPortfolioRequest): AssociatePrincipalWithPortfolioResponse

    /**
     * Associates the specified product with the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    public suspend fun associateProductWithPortfolio(input: AssociateProductWithPortfolioRequest): AssociateProductWithPortfolioResponse

    /**
     * Associates a self-service action with a provisioning artifact.
     */
    public suspend fun associateServiceActionWithProvisioningArtifact(input: AssociateServiceActionWithProvisioningArtifactRequest): AssociateServiceActionWithProvisioningArtifactResponse

    /**
     * Associate the specified TagOption with the specified portfolio or product.
     */
    public suspend fun associateTagOptionWithResource(input: AssociateTagOptionWithResourceRequest): AssociateTagOptionWithResourceResponse

    /**
     * Associates multiple self-service actions with provisioning artifacts.
     */
    public suspend fun batchAssociateServiceActionWithProvisioningArtifact(input: BatchAssociateServiceActionWithProvisioningArtifactRequest): BatchAssociateServiceActionWithProvisioningArtifactResponse

    /**
     * Disassociates a batch of self-service actions from the specified provisioning artifact.
     */
    public suspend fun batchDisassociateServiceActionFromProvisioningArtifact(input: BatchDisassociateServiceActionFromProvisioningArtifactRequest): BatchDisassociateServiceActionFromProvisioningArtifactResponse

    /**
     * Copies the specified source product to the specified target product or a new product.
     *
     * You can copy a product to the same account or another account. You can copy a product to the same Region or another Region. If you copy a product to another account, you must first share the product in a portfolio using CreatePortfolioShare.
     *
     * This operation is performed asynchronously. To track the progress of the operation, use DescribeCopyProductStatus.
     */
    public suspend fun copyProduct(input: CopyProductRequest): CopyProductResponse

    /**
     * Creates a constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    public suspend fun createConstraint(input: CreateConstraintRequest): CreateConstraintResponse

    /**
     * Creates a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    public suspend fun createPortfolio(input: CreatePortfolioRequest): CreatePortfolioResponse

    /**
     * Shares the specified portfolio with the specified account or organization node. Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. You can share portfolios to an organization, an organizational unit, or a specific account.
     *
     * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
     *
     * `AWSOrganizationsAccess` must be enabled in order to create a portfolio share to an organization node.
     *
     * You can't share a shared resource, including portfolios that contain a shared product.
     *
     * If the portfolio share with the specified account or organization node already exists, this action will have no effect and will not return an error. To update an existing share, you must use the ` UpdatePortfolioShare` API instead.
     *
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that portfolio is then shared with other accounts. For a user in a recipient account who is *not* an Service Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role that matches a principal name association for the portfolio. Although this user may not know which principal names are associated through Service Catalog, they may be able to guess the user. If this potential escalation path is a concern, then Service Catalog recommends using `PrincipalType` as `IAM`. With this configuration, the `PrincipalARN` must already exist in the recipient account before it can be associated.
     */
    public suspend fun createPortfolioShare(input: CreatePortfolioShareRequest): CreatePortfolioShareResponse

    /**
     * Creates a product.
     *
     * A delegated admin is authorized to invoke this command.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    public suspend fun createProduct(input: CreateProductRequest): CreateProductResponse

    /**
     * Creates a plan.
     *
     * A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating a provisioned product) when the plan is executed.
     *
     * You can create one plan for each provisioned product. To create a plan for an existing provisioned product, the product status must be AVAILABLE or TAINTED.
     *
     * To view the resource changes in the change set, use DescribeProvisionedProductPlan. To create or modify the provisioned product, use ExecuteProvisionedProductPlan.
     */
    public suspend fun createProvisionedProductPlan(input: CreateProvisionedProductPlanRequest): CreateProvisionedProductPlanResponse

    /**
     * Creates a provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot create a provisioning artifact for a product that was shared with you.
     *
     * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
     */
    public suspend fun createProvisioningArtifact(input: CreateProvisioningArtifactRequest): CreateProvisioningArtifactResponse

    /**
     * Creates a self-service action.
     */
    public suspend fun createServiceAction(input: CreateServiceActionRequest): CreateServiceActionResponse

    /**
     * Creates a TagOption.
     */
    public suspend fun createTagOption(input: CreateTagOptionRequest): CreateTagOptionResponse

    /**
     * Deletes the specified constraint.
     *
     * A delegated admin is authorized to invoke this command.
     */
    public suspend fun deleteConstraint(input: DeleteConstraintRequest): DeleteConstraintResponse

    /**
     * Deletes the specified portfolio.
     *
     * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or shared accounts.
     *
     * A delegated admin is authorized to invoke this command.
     */
    public suspend fun deletePortfolio(input: DeletePortfolioRequest): DeletePortfolioResponse

    /**
     * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization node can only be deleted by the management account of an organization or by a delegated administrator.
     *
     * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
     */
    public suspend fun deletePortfolioShare(input: DeletePortfolioShareRequest): DeletePortfolioShareResponse

    /**
     * Deletes the specified product.
     *
     * You cannot delete a product if it was shared with you or is associated with a portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    public suspend fun deleteProduct(input: DeleteProductRequest): DeleteProductResponse

    /**
     * Deletes the specified plan.
     */
    public suspend fun deleteProvisionedProductPlan(input: DeleteProvisionedProductPlanRequest): DeleteProvisionedProductPlanResponse

    /**
     * Deletes the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
     */
    public suspend fun deleteProvisioningArtifact(input: DeleteProvisioningArtifactRequest): DeleteProvisioningArtifactResponse

    /**
     * Deletes a self-service action.
     */
    public suspend fun deleteServiceAction(input: DeleteServiceActionRequest): DeleteServiceActionResponse

    /**
     * Deletes the specified TagOption.
     *
     * You cannot delete a TagOption if it is associated with a product or portfolio.
     */
    public suspend fun deleteTagOption(input: DeleteTagOptionRequest): DeleteTagOptionResponse

    /**
     * Gets information about the specified constraint.
     */
    public suspend fun describeConstraint(input: DescribeConstraintRequest): DescribeConstraintResponse

    /**
     * Gets the status of the specified copy product operation.
     */
    public suspend fun describeCopyProductStatus(input: DescribeCopyProductStatusRequest): DescribeCopyProductStatusResponse

    /**
     * Gets information about the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    public suspend fun describePortfolio(input: DescribePortfolioRequest): DescribePortfolioResponse

    /**
     * Gets the status of the specified portfolio share operation. This API can only be called by the management account in the organization or by a delegated admin.
     */
    public suspend fun describePortfolioShareStatus(input: DescribePortfolioShareStatusRequest): DescribePortfolioShareStatusResponse

    /**
     * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
     *
     * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether the recipient entity has imported the share, and whether TagOptions are included with the share.
     *
     * The `PortfolioId` and `Type` parameters are both required.
     */
    public suspend fun describePortfolioShares(input: DescribePortfolioSharesRequest): DescribePortfolioSharesResponse

    /**
     * Gets information about the specified product.
     *
     *  Running this operation with administrator access results in a failure. DescribeProductAsAdmin should be used instead.
     */
    public suspend fun describeProduct(input: DescribeProductRequest = DescribeProductRequest { }): DescribeProductResponse

    /**
     * Gets information about the specified product. This operation is run with administrator access.
     */
    public suspend fun describeProductAsAdmin(input: DescribeProductAsAdminRequest = DescribeProductAsAdminRequest { }): DescribeProductAsAdminResponse

    /**
     * Gets information about the specified product.
     */
    public suspend fun describeProductView(input: DescribeProductViewRequest): DescribeProductViewResponse

    /**
     * Gets information about the specified provisioned product.
     */
    public suspend fun describeProvisionedProduct(input: DescribeProvisionedProductRequest = DescribeProvisionedProductRequest { }): DescribeProvisionedProductResponse

    /**
     * Gets information about the resource changes for the specified plan.
     */
    public suspend fun describeProvisionedProductPlan(input: DescribeProvisionedProductPlanRequest): DescribeProvisionedProductPlanResponse

    /**
     * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
     */
    public suspend fun describeProvisioningArtifact(input: DescribeProvisioningArtifactRequest = DescribeProvisioningArtifactRequest { }): DescribeProvisioningArtifactResponse

    /**
     * Gets information about the configuration required to provision the specified product using the specified provisioning artifact.
     *
     * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key. The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to ProvisionProduct, do not include conflicted TagOption keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*". Tag the provisioned product with the value `sc-tagoption-conflict-portfolioId-productId`.
     */
    public suspend fun describeProvisioningParameters(input: DescribeProvisioningParametersRequest = DescribeProvisioningParametersRequest { }): DescribeProvisioningParametersResponse

    /**
     * Gets information about the specified request operation.
     *
     * Use this operation after calling a request operation (for example, ProvisionProduct, TerminateProvisionedProduct, or UpdateProvisionedProduct).
     *
     * If a provisioned product was transferred to a new owner using UpdateProvisionedProductProperties, the new owner will be able to describe all past records for that product. The previous owner will no longer be able to describe the records, but will be able to use ListRecordHistory to see the product's history from when he was the owner.
     */
    public suspend fun describeRecord(input: DescribeRecordRequest): DescribeRecordResponse

    /**
     * Describes a self-service action.
     */
    public suspend fun describeServiceAction(input: DescribeServiceActionRequest): DescribeServiceActionResponse

    /**
     * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.
     */
    public suspend fun describeServiceActionExecutionParameters(input: DescribeServiceActionExecutionParametersRequest): DescribeServiceActionExecutionParametersResponse

    /**
     * Gets information about the specified TagOption.
     */
    public suspend fun describeTagOption(input: DescribeTagOptionRequest): DescribeTagOptionResponse

    /**
     * Disable portfolio sharing through the Organizations service. This command will not delete your current shares, but prevents you from creating new shares throughout your organization. Current shares are not kept in sync with your organization structure if the structure changes after calling this API. Only the management account in the organization can call this API.
     *
     * You cannot call this API if there are active delegated administrators in the organization.
     *
     * Note that a delegated administrator is not authorized to invoke `DisableAWSOrganizationsAccess`.
     *
     * If you share an Service Catalog portfolio in an organization within Organizations, and then disable Organizations access for Service Catalog, the portfolio access permissions will not sync with the latest changes to the organization structure. Specifically, accounts that you removed from the organization after disabling Service Catalog access will retain access to the previously shared portfolio.
     */
    public suspend fun disableAwsOrganizationsAccess(input: DisableAwsOrganizationsAccessRequest = DisableAwsOrganizationsAccessRequest { }): DisableAwsOrganizationsAccessResponse

    /**
     * Disassociates the specified budget from the specified resource.
     */
    public suspend fun disassociateBudgetFromResource(input: DisassociateBudgetFromResourceRequest): DisassociateBudgetFromResourceResponse

    /**
     * Disassociates a previously associated principal ARN from a specified portfolio.
     *
     * The `PrincipalType` and `PrincipalARN` must match the `AssociatePrincipalWithPortfolio` call request details. For example, to disassociate an association created with a `PrincipalARN` of `PrincipalType` IAM you must use the `PrincipalType` IAM when calling `DisassociatePrincipalFromPortfolio`.
     *
     * For portfolios that have been shared with principal name sharing enabled: after disassociating a principal, share recipient accounts will no longer be able to provision products in this portfolio using a role matching the name of the associated principal.
     *
     * For more information, review [associate-principal-with-portfolio](https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options) in the Amazon Web Services CLI Command Reference.
     *
     * If you disassociate a principal from a portfolio, with PrincipalType as `IAM`, the same principal will still have access to the portfolio if it matches one of the associated principals of type `IAM_PATTERN`. To fully remove access for a principal, verify all the associated Principals of type `IAM_PATTERN`, and then ensure you disassociate any `IAM_PATTERN` principals that match the principal whose access you are removing.
     */
    public suspend fun disassociatePrincipalFromPortfolio(input: DisassociatePrincipalFromPortfolioRequest): DisassociatePrincipalFromPortfolioResponse

    /**
     * Disassociates the specified product from the specified portfolio.
     *
     * A delegated admin is authorized to invoke this command.
     */
    public suspend fun disassociateProductFromPortfolio(input: DisassociateProductFromPortfolioRequest): DisassociateProductFromPortfolioResponse

    /**
     * Disassociates the specified self-service action association from the specified provisioning artifact.
     */
    public suspend fun disassociateServiceActionFromProvisioningArtifact(input: DisassociateServiceActionFromProvisioningArtifactRequest): DisassociateServiceActionFromProvisioningArtifactResponse

    /**
     * Disassociates the specified TagOption from the specified resource.
     */
    public suspend fun disassociateTagOptionFromResource(input: DisassociateTagOptionFromResourceRequest): DisassociateTagOptionFromResourceResponse

    /**
     * Enable portfolio sharing feature through Organizations. This API will allow Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This API can only be called by the management account in the organization.
     *
     * When you call this API, Service Catalog calls `organizations:EnableAWSServiceAccess` on your behalf so that your shares stay in sync with any changes in your Organizations structure.
     *
     * Note that a delegated administrator is not authorized to invoke `EnableAWSOrganizationsAccess`.
     *
     * If you have previously disabled Organizations access for Service Catalog, and then enable access again, the portfolio access permissions might not sync with the latest changes to the organization structure. Specifically, accounts that you removed from the organization after disabling Service Catalog access, and before you enabled access again, can retain access to the previously shared portfolio. As a result, an account that has been removed from the organization might still be able to create or manage Amazon Web Services resources when it is no longer authorized to do so. Amazon Web Services is working to resolve this issue.
     */
    public suspend fun enableAwsOrganizationsAccess(input: EnableAwsOrganizationsAccessRequest = EnableAwsOrganizationsAccessRequest { }): EnableAwsOrganizationsAccessResponse

    /**
     * Provisions or modifies a product based on the resource changes for the specified plan.
     */
    public suspend fun executeProvisionedProductPlan(input: ExecuteProvisionedProductPlanRequest): ExecuteProvisionedProductPlanResponse

    /**
     * Executes a self-service action against a provisioned product.
     */
    public suspend fun executeProvisionedProductServiceAction(input: ExecuteProvisionedProductServiceActionRequest): ExecuteProvisionedProductServiceActionResponse

    /**
     * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management account in the organization or by a delegated admin.
     */
    public suspend fun getAwsOrganizationsAccessStatus(input: GetAwsOrganizationsAccessStatusRequest = GetAwsOrganizationsAccessStatusRequest { }): GetAwsOrganizationsAccessStatusResponse

    /**
     * This API takes either a `ProvisonedProductId` or a `ProvisionedProductName`, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.
     */
    public suspend fun getProvisionedProductOutputs(input: GetProvisionedProductOutputsRequest = GetProvisionedProductOutputsRequest { }): GetProvisionedProductOutputsResponse

    /**
     * Requests the import of a resource as an Service Catalog provisioned product that is associated to an Service Catalog product and provisioning artifact. Once imported, all supported governance actions are supported on the provisioned product.
     *
     *  Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets, and non-root nested stacks, are not supported.
     *
     *  The CloudFormation stack must have one of the following statuses to be imported: `CREATE_COMPLETE`, `UPDATE_COMPLETE`, `UPDATE_ROLLBACK_COMPLETE`, `IMPORT_COMPLETE`, and `IMPORT_ROLLBACK_COMPLETE`.
     *
     *  Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog product provisioning artifact.
     *
     *  When you import an existing CloudFormation stack into a portfolio, Service Catalog does not apply the product's associated constraints during the import process. Service Catalog applies the constraints after you call `UpdateProvisionedProduct` for the provisioned product.
     *
     *  The user or role that performs this operation must have the `cloudformation:GetTemplate` and `cloudformation:DescribeStacks` IAM policy permissions.
     *
     * You can only import one provisioned product at a time. The product's CloudFormation stack must have the `IMPORT_COMPLETE` status before you import another.
     */
    public suspend fun importAsProvisionedProduct(input: ImportAsProvisionedProductRequest): ImportAsProvisionedProductResponse

    /**
     * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying the `PortfolioShareType`, you can list portfolios for which organizational shares were accepted by this account.
     */
    public suspend fun listAcceptedPortfolioShares(input: ListAcceptedPortfolioSharesRequest = ListAcceptedPortfolioSharesRequest { }): ListAcceptedPortfolioSharesResponse

    /**
     * Lists all the budgets associated to the specified resource.
     */
    public suspend fun listBudgetsForResource(input: ListBudgetsForResourceRequest): ListBudgetsForResourceResponse

    /**
     * Lists the constraints for the specified portfolio and product.
     */
    public suspend fun listConstraintsForPortfolio(input: ListConstraintsForPortfolioRequest): ListConstraintsForPortfolioResponse

    /**
     * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is necessary when provisioning a product. A path also determines the constraints that are put on a product. A path is dependent on a specific product, porfolio, and principal.
     *
     *  When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to the portfolio. For more information, see [Granting users access](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html) in the *Service Catalog User Guide*.
     */
    public suspend fun listLaunchPaths(input: ListLaunchPathsRequest): ListLaunchPathsResponse

    /**
     * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the management account in the organization or by a delegated admin.
     *
     * If a delegated admin is de-registered, they can no longer perform this operation.
     */
    public suspend fun listOrganizationPortfolioAccess(input: ListOrganizationPortfolioAccessRequest): ListOrganizationPortfolioAccessResponse

    /**
     * Lists the account IDs that have access to the specified portfolio.
     *
     * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin is de-registered, they can no longer perform this operation.
     */
    public suspend fun listPortfolioAccess(input: ListPortfolioAccessRequest): ListPortfolioAccessResponse

    /**
     * Lists all portfolios in the catalog.
     */
    public suspend fun listPortfolios(input: ListPortfoliosRequest = ListPortfoliosRequest { }): ListPortfoliosResponse

    /**
     * Lists all portfolios that the specified product is associated with.
     */
    public suspend fun listPortfoliosForProduct(input: ListPortfoliosForProductRequest): ListPortfoliosForProductResponse

    /**
     * Lists all `PrincipalARN`s and corresponding `PrincipalType`s associated with the specified portfolio.
     */
    public suspend fun listPrincipalsForPortfolio(input: ListPrincipalsForPortfolioRequest): ListPrincipalsForPortfolioResponse

    /**
     * Lists the plans for the specified provisioned product or all plans to which the user has access.
     */
    public suspend fun listProvisionedProductPlans(input: ListProvisionedProductPlansRequest = ListProvisionedProductPlansRequest { }): ListProvisionedProductPlansResponse

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified product.
     */
    public suspend fun listProvisioningArtifacts(input: ListProvisioningArtifactsRequest): ListProvisioningArtifactsResponse

    /**
     * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
     */
    public suspend fun listProvisioningArtifactsForServiceAction(input: ListProvisioningArtifactsForServiceActionRequest): ListProvisioningArtifactsForServiceActionResponse

    /**
     * Lists the specified requests or all performed requests.
     */
    public suspend fun listRecordHistory(input: ListRecordHistoryRequest = ListRecordHistoryRequest { }): ListRecordHistoryResponse

    /**
     * Lists the resources associated with the specified TagOption.
     */
    public suspend fun listResourcesForTagOption(input: ListResourcesForTagOptionRequest): ListResourcesForTagOptionResponse

    /**
     * Lists all self-service actions.
     */
    public suspend fun listServiceActions(input: ListServiceActionsRequest = ListServiceActionsRequest { }): ListServiceActionsResponse

    /**
     * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.
     */
    public suspend fun listServiceActionsForProvisioningArtifact(input: ListServiceActionsForProvisioningArtifactRequest): ListServiceActionsForProvisioningArtifactResponse

    /**
     * Returns summary information about stack instances that are associated with the specified `CFN_STACKSET` type provisioned product. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region.
     */
    public suspend fun listStackInstancesForProvisionedProduct(input: ListStackInstancesForProvisionedProductRequest): ListStackInstancesForProvisionedProductResponse

    /**
     * Lists the specified TagOptions or all TagOptions.
     */
    public suspend fun listTagOptions(input: ListTagOptionsRequest = ListTagOptionsRequest { }): ListTagOptionsResponse

    /**
     * Notifies the result of the provisioning engine execution.
     */
    public suspend fun notifyProvisionProductEngineWorkflowResult(input: NotifyProvisionProductEngineWorkflowResultRequest): NotifyProvisionProductEngineWorkflowResultResponse

    /**
     * Notifies the result of the terminate engine execution.
     */
    public suspend fun notifyTerminateProvisionedProductEngineWorkflowResult(input: NotifyTerminateProvisionedProductEngineWorkflowResultRequest): NotifyTerminateProvisionedProductEngineWorkflowResultResponse

    /**
     * Notifies the result of the update engine execution.
     */
    public suspend fun notifyUpdateProvisionedProductEngineWorkflowResult(input: NotifyUpdateProvisionedProductEngineWorkflowResultRequest): NotifyUpdateProvisionedProductEngineWorkflowResultResponse

    /**
     * Provisions the specified product.
     *
     *  A provisioned product is a resourced instance of a product. For example, provisioning a product that's based on an CloudFormation template launches an CloudFormation stack and its underlying resources. You can check the status of this request using DescribeRecord.
     *
     *  If the request contains a tag key with an empty list of values, there's a tag conflict for that key. Don't include conflicted keys as tags, or this will cause the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*".
     *
     *  When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to the portfolio. For more information, see [Granting users access](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html) in the *Service Catalog User Guide*.
     */
    public suspend fun provisionProduct(input: ProvisionProductRequest): ProvisionProductResponse

    /**
     * Rejects an offer to share the specified portfolio.
     */
    public suspend fun rejectPortfolioShare(input: RejectPortfolioShareRequest): RejectPortfolioShareResponse

    /**
     * Lists the provisioned products that are available (not terminated).
     *
     * To use additional filtering, see SearchProvisionedProducts.
     */
    public suspend fun scanProvisionedProducts(input: ScanProvisionedProductsRequest = ScanProvisionedProductsRequest { }): ScanProvisionedProductsResponse

    /**
     * Gets information about the products to which the caller has access.
     */
    public suspend fun searchProducts(input: SearchProductsRequest = SearchProductsRequest { }): SearchProductsResponse

    /**
     * Gets information about the products for the specified portfolio or all products.
     */
    public suspend fun searchProductsAsAdmin(input: SearchProductsAsAdminRequest = SearchProductsAsAdminRequest { }): SearchProductsAsAdminResponse

    /**
     * Gets information about the provisioned products that meet the specified criteria.
     */
    public suspend fun searchProvisionedProducts(input: SearchProvisionedProductsRequest = SearchProvisionedProductsRequest { }): SearchProvisionedProductsResponse

    /**
     * Terminates the specified provisioned product.
     *
     * This operation does not delete any records associated with the provisioned product.
     *
     * You can check the status of this request using DescribeRecord.
     */
    public suspend fun terminateProvisionedProduct(input: TerminateProvisionedProductRequest): TerminateProvisionedProductResponse

    /**
     * Updates the specified constraint.
     */
    public suspend fun updateConstraint(input: UpdateConstraintRequest): UpdateConstraintResponse

    /**
     * Updates the specified portfolio.
     *
     * You cannot update a product that was shared with you.
     */
    public suspend fun updatePortfolio(input: UpdatePortfolioRequest): UpdatePortfolioResponse

    /**
     * Updates the specified portfolio share. You can use this API to enable or disable `TagOptions` sharing or Principal sharing for an existing portfolio share.
     *
     * The portfolio share cannot be updated if the `CreatePortfolioShare` operation is `IN_PROGRESS`, as the share is not available to recipient entities. In this case, you must wait for the portfolio share to be completed.
     *
     * You must provide the `accountId` or organization node in the input, but not both.
     *
     * If the portfolio is shared to both an external account and an organization node, and both shares need to be updated, you must invoke `UpdatePortfolioShare` separately for each share type.
     *
     * This API cannot be used for removing the portfolio share. You must use `DeletePortfolioShare` API for that action.
     *
     * When you associate a principal with portfolio, a potential privilege escalation path may occur when that portfolio is then shared with other accounts. For a user in a recipient account who is *not* an Service Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role that matches a principal name association for the portfolio. Although this user may not know which principal names are associated through Service Catalog, they may be able to guess the user. If this potential escalation path is a concern, then Service Catalog recommends using `PrincipalType` as `IAM`. With this configuration, the `PrincipalARN` must already exist in the recipient account before it can be associated.
     */
    public suspend fun updatePortfolioShare(input: UpdatePortfolioShareRequest): UpdatePortfolioShareResponse

    /**
     * Updates the specified product.
     */
    public suspend fun updateProduct(input: UpdateProductRequest): UpdateProductResponse

    /**
     * Requests updates to the configuration of the specified provisioned product.
     *
     * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates requested, this operation can update with no interruption, with some interruption, or replace the provisioned product entirely.
     *
     * You can check the status of this request using DescribeRecord.
     */
    public suspend fun updateProvisionedProduct(input: UpdateProvisionedProductRequest): UpdateProvisionedProductResponse

    /**
     * Requests updates to the properties of the specified provisioned product.
     */
    public suspend fun updateProvisionedProductProperties(input: UpdateProvisionedProductPropertiesRequest): UpdateProvisionedProductPropertiesResponse

    /**
     * Updates the specified provisioning artifact (also known as a version) for the specified product.
     *
     * You cannot update a provisioning artifact for a product that was shared with you.
     */
    public suspend fun updateProvisioningArtifact(input: UpdateProvisioningArtifactRequest): UpdateProvisioningArtifactResponse

    /**
     * Updates a self-service action.
     */
    public suspend fun updateServiceAction(input: UpdateServiceActionRequest): UpdateServiceActionResponse

    /**
     * Updates the specified TagOption.
     */
    public suspend fun updateTagOption(input: UpdateTagOptionRequest): UpdateTagOptionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ServiceCatalogClient.withConfig(block: ServiceCatalogClient.Config.Builder.() -> Unit): ServiceCatalogClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultServiceCatalogClient(newConfig)
}

/**
 * Accepts an offer to share the specified portfolio.
 */
public suspend inline fun ServiceCatalogClient.acceptPortfolioShare(crossinline block: AcceptPortfolioShareRequest.Builder.() -> Unit): AcceptPortfolioShareResponse = acceptPortfolioShare(AcceptPortfolioShareRequest.Builder().apply(block).build())

/**
 * Associates the specified budget with the specified resource.
 */
public suspend inline fun ServiceCatalogClient.associateBudgetWithResource(crossinline block: AssociateBudgetWithResourceRequest.Builder.() -> Unit): AssociateBudgetWithResourceResponse = associateBudgetWithResource(AssociateBudgetWithResourceRequest.Builder().apply(block).build())

/**
 * Associates the specified principal ARN with the specified portfolio.
 *
 * If you share the portfolio with principal name sharing enabled, the `PrincipalARN` association is included in the share.
 *
 * The `PortfolioID`, `PrincipalARN`, and `PrincipalType` parameters are required.
 *
 * You can associate a maximum of 10 Principals with a portfolio using `PrincipalType` as `IAM_PATTERN`.
 *
 * When you associate a principal with portfolio, a potential privilege escalation path may occur when that portfolio is then shared with other accounts. For a user in a recipient account who is *not* an Service Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role that matches a principal name association for the portfolio. Although this user may not know which principal names are associated through Service Catalog, they may be able to guess the user. If this potential escalation path is a concern, then Service Catalog recommends using `PrincipalType` as `IAM`. With this configuration, the `PrincipalARN` must already exist in the recipient account before it can be associated.
 */
public suspend inline fun ServiceCatalogClient.associatePrincipalWithPortfolio(crossinline block: AssociatePrincipalWithPortfolioRequest.Builder.() -> Unit): AssociatePrincipalWithPortfolioResponse = associatePrincipalWithPortfolio(AssociatePrincipalWithPortfolioRequest.Builder().apply(block).build())

/**
 * Associates the specified product with the specified portfolio.
 *
 * A delegated admin is authorized to invoke this command.
 */
public suspend inline fun ServiceCatalogClient.associateProductWithPortfolio(crossinline block: AssociateProductWithPortfolioRequest.Builder.() -> Unit): AssociateProductWithPortfolioResponse = associateProductWithPortfolio(AssociateProductWithPortfolioRequest.Builder().apply(block).build())

/**
 * Associates a self-service action with a provisioning artifact.
 */
public suspend inline fun ServiceCatalogClient.associateServiceActionWithProvisioningArtifact(crossinline block: AssociateServiceActionWithProvisioningArtifactRequest.Builder.() -> Unit): AssociateServiceActionWithProvisioningArtifactResponse = associateServiceActionWithProvisioningArtifact(AssociateServiceActionWithProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Associate the specified TagOption with the specified portfolio or product.
 */
public suspend inline fun ServiceCatalogClient.associateTagOptionWithResource(crossinline block: AssociateTagOptionWithResourceRequest.Builder.() -> Unit): AssociateTagOptionWithResourceResponse = associateTagOptionWithResource(AssociateTagOptionWithResourceRequest.Builder().apply(block).build())

/**
 * Associates multiple self-service actions with provisioning artifacts.
 */
public suspend inline fun ServiceCatalogClient.batchAssociateServiceActionWithProvisioningArtifact(crossinline block: BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder.() -> Unit): BatchAssociateServiceActionWithProvisioningArtifactResponse = batchAssociateServiceActionWithProvisioningArtifact(BatchAssociateServiceActionWithProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Disassociates a batch of self-service actions from the specified provisioning artifact.
 */
public suspend inline fun ServiceCatalogClient.batchDisassociateServiceActionFromProvisioningArtifact(crossinline block: BatchDisassociateServiceActionFromProvisioningArtifactRequest.Builder.() -> Unit): BatchDisassociateServiceActionFromProvisioningArtifactResponse = batchDisassociateServiceActionFromProvisioningArtifact(BatchDisassociateServiceActionFromProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Copies the specified source product to the specified target product or a new product.
 *
 * You can copy a product to the same account or another account. You can copy a product to the same Region or another Region. If you copy a product to another account, you must first share the product in a portfolio using CreatePortfolioShare.
 *
 * This operation is performed asynchronously. To track the progress of the operation, use DescribeCopyProductStatus.
 */
public suspend inline fun ServiceCatalogClient.copyProduct(crossinline block: CopyProductRequest.Builder.() -> Unit): CopyProductResponse = copyProduct(CopyProductRequest.Builder().apply(block).build())

/**
 * Creates a constraint.
 *
 * A delegated admin is authorized to invoke this command.
 */
public suspend inline fun ServiceCatalogClient.createConstraint(crossinline block: CreateConstraintRequest.Builder.() -> Unit): CreateConstraintResponse = createConstraint(CreateConstraintRequest.Builder().apply(block).build())

/**
 * Creates a portfolio.
 *
 * A delegated admin is authorized to invoke this command.
 */
public suspend inline fun ServiceCatalogClient.createPortfolio(crossinline block: CreatePortfolioRequest.Builder.() -> Unit): CreatePortfolioResponse = createPortfolio(CreatePortfolioRequest.Builder().apply(block).build())

/**
 * Shares the specified portfolio with the specified account or organization node. Shares to an organization node can only be created by the management account of an organization or by a delegated administrator. You can share portfolios to an organization, an organizational unit, or a specific account.
 *
 * Note that if a delegated admin is de-registered, they can no longer create portfolio shares.
 *
 * `AWSOrganizationsAccess` must be enabled in order to create a portfolio share to an organization node.
 *
 * You can't share a shared resource, including portfolios that contain a shared product.
 *
 * If the portfolio share with the specified account or organization node already exists, this action will have no effect and will not return an error. To update an existing share, you must use the ` UpdatePortfolioShare` API instead.
 *
 * When you associate a principal with portfolio, a potential privilege escalation path may occur when that portfolio is then shared with other accounts. For a user in a recipient account who is *not* an Service Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role that matches a principal name association for the portfolio. Although this user may not know which principal names are associated through Service Catalog, they may be able to guess the user. If this potential escalation path is a concern, then Service Catalog recommends using `PrincipalType` as `IAM`. With this configuration, the `PrincipalARN` must already exist in the recipient account before it can be associated.
 */
public suspend inline fun ServiceCatalogClient.createPortfolioShare(crossinline block: CreatePortfolioShareRequest.Builder.() -> Unit): CreatePortfolioShareResponse = createPortfolioShare(CreatePortfolioShareRequest.Builder().apply(block).build())

/**
 * Creates a product.
 *
 * A delegated admin is authorized to invoke this command.
 *
 * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
 */
public suspend inline fun ServiceCatalogClient.createProduct(crossinline block: CreateProductRequest.Builder.() -> Unit): CreateProductResponse = createProduct(CreateProductRequest.Builder().apply(block).build())

/**
 * Creates a plan.
 *
 * A plan includes the list of resources to be created (when provisioning a new product) or modified (when updating a provisioned product) when the plan is executed.
 *
 * You can create one plan for each provisioned product. To create a plan for an existing provisioned product, the product status must be AVAILABLE or TAINTED.
 *
 * To view the resource changes in the change set, use DescribeProvisionedProductPlan. To create or modify the provisioned product, use ExecuteProvisionedProductPlan.
 */
public suspend inline fun ServiceCatalogClient.createProvisionedProductPlan(crossinline block: CreateProvisionedProductPlanRequest.Builder.() -> Unit): CreateProvisionedProductPlanResponse = createProvisionedProductPlan(CreateProvisionedProductPlanRequest.Builder().apply(block).build())

/**
 * Creates a provisioning artifact (also known as a version) for the specified product.
 *
 * You cannot create a provisioning artifact for a product that was shared with you.
 *
 * The user or role that performs this operation must have the `cloudformation:GetTemplate` IAM policy permission. This policy permission is required when using the `ImportFromPhysicalId` template source in the information data section.
 */
public suspend inline fun ServiceCatalogClient.createProvisioningArtifact(crossinline block: CreateProvisioningArtifactRequest.Builder.() -> Unit): CreateProvisioningArtifactResponse = createProvisioningArtifact(CreateProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Creates a self-service action.
 */
public suspend inline fun ServiceCatalogClient.createServiceAction(crossinline block: CreateServiceActionRequest.Builder.() -> Unit): CreateServiceActionResponse = createServiceAction(CreateServiceActionRequest.Builder().apply(block).build())

/**
 * Creates a TagOption.
 */
public suspend inline fun ServiceCatalogClient.createTagOption(crossinline block: CreateTagOptionRequest.Builder.() -> Unit): CreateTagOptionResponse = createTagOption(CreateTagOptionRequest.Builder().apply(block).build())

/**
 * Deletes the specified constraint.
 *
 * A delegated admin is authorized to invoke this command.
 */
public suspend inline fun ServiceCatalogClient.deleteConstraint(crossinline block: DeleteConstraintRequest.Builder.() -> Unit): DeleteConstraintResponse = deleteConstraint(DeleteConstraintRequest.Builder().apply(block).build())

/**
 * Deletes the specified portfolio.
 *
 * You cannot delete a portfolio if it was shared with you or if it has associated products, users, constraints, or shared accounts.
 *
 * A delegated admin is authorized to invoke this command.
 */
public suspend inline fun ServiceCatalogClient.deletePortfolio(crossinline block: DeletePortfolioRequest.Builder.() -> Unit): DeletePortfolioResponse = deletePortfolio(DeletePortfolioRequest.Builder().apply(block).build())

/**
 * Stops sharing the specified portfolio with the specified account or organization node. Shares to an organization node can only be deleted by the management account of an organization or by a delegated administrator.
 *
 * Note that if a delegated admin is de-registered, portfolio shares created from that account are removed.
 */
public suspend inline fun ServiceCatalogClient.deletePortfolioShare(crossinline block: DeletePortfolioShareRequest.Builder.() -> Unit): DeletePortfolioShareResponse = deletePortfolioShare(DeletePortfolioShareRequest.Builder().apply(block).build())

/**
 * Deletes the specified product.
 *
 * You cannot delete a product if it was shared with you or is associated with a portfolio.
 *
 * A delegated admin is authorized to invoke this command.
 */
public suspend inline fun ServiceCatalogClient.deleteProduct(crossinline block: DeleteProductRequest.Builder.() -> Unit): DeleteProductResponse = deleteProduct(DeleteProductRequest.Builder().apply(block).build())

/**
 * Deletes the specified plan.
 */
public suspend inline fun ServiceCatalogClient.deleteProvisionedProductPlan(crossinline block: DeleteProvisionedProductPlanRequest.Builder.() -> Unit): DeleteProvisionedProductPlanResponse = deleteProvisionedProductPlan(DeleteProvisionedProductPlanRequest.Builder().apply(block).build())

/**
 * Deletes the specified provisioning artifact (also known as a version) for the specified product.
 *
 * You cannot delete a provisioning artifact associated with a product that was shared with you. You cannot delete the last provisioning artifact for a product, because a product must have at least one provisioning artifact.
 */
public suspend inline fun ServiceCatalogClient.deleteProvisioningArtifact(crossinline block: DeleteProvisioningArtifactRequest.Builder.() -> Unit): DeleteProvisioningArtifactResponse = deleteProvisioningArtifact(DeleteProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Deletes a self-service action.
 */
public suspend inline fun ServiceCatalogClient.deleteServiceAction(crossinline block: DeleteServiceActionRequest.Builder.() -> Unit): DeleteServiceActionResponse = deleteServiceAction(DeleteServiceActionRequest.Builder().apply(block).build())

/**
 * Deletes the specified TagOption.
 *
 * You cannot delete a TagOption if it is associated with a product or portfolio.
 */
public suspend inline fun ServiceCatalogClient.deleteTagOption(crossinline block: DeleteTagOptionRequest.Builder.() -> Unit): DeleteTagOptionResponse = deleteTagOption(DeleteTagOptionRequest.Builder().apply(block).build())

/**
 * Gets information about the specified constraint.
 */
public suspend inline fun ServiceCatalogClient.describeConstraint(crossinline block: DescribeConstraintRequest.Builder.() -> Unit): DescribeConstraintResponse = describeConstraint(DescribeConstraintRequest.Builder().apply(block).build())

/**
 * Gets the status of the specified copy product operation.
 */
public suspend inline fun ServiceCatalogClient.describeCopyProductStatus(crossinline block: DescribeCopyProductStatusRequest.Builder.() -> Unit): DescribeCopyProductStatusResponse = describeCopyProductStatus(DescribeCopyProductStatusRequest.Builder().apply(block).build())

/**
 * Gets information about the specified portfolio.
 *
 * A delegated admin is authorized to invoke this command.
 */
public suspend inline fun ServiceCatalogClient.describePortfolio(crossinline block: DescribePortfolioRequest.Builder.() -> Unit): DescribePortfolioResponse = describePortfolio(DescribePortfolioRequest.Builder().apply(block).build())

/**
 * Gets the status of the specified portfolio share operation. This API can only be called by the management account in the organization or by a delegated admin.
 */
public suspend inline fun ServiceCatalogClient.describePortfolioShareStatus(crossinline block: DescribePortfolioShareStatusRequest.Builder.() -> Unit): DescribePortfolioShareStatusResponse = describePortfolioShareStatus(DescribePortfolioShareStatusRequest.Builder().apply(block).build())

/**
 * Returns a summary of each of the portfolio shares that were created for the specified portfolio.
 *
 * You can use this API to determine which accounts or organizational nodes this portfolio have been shared, whether the recipient entity has imported the share, and whether TagOptions are included with the share.
 *
 * The `PortfolioId` and `Type` parameters are both required.
 */
public suspend inline fun ServiceCatalogClient.describePortfolioShares(crossinline block: DescribePortfolioSharesRequest.Builder.() -> Unit): DescribePortfolioSharesResponse = describePortfolioShares(DescribePortfolioSharesRequest.Builder().apply(block).build())

/**
 * Gets information about the specified product.
 *
 *  Running this operation with administrator access results in a failure. DescribeProductAsAdmin should be used instead.
 */
public suspend inline fun ServiceCatalogClient.describeProduct(crossinline block: DescribeProductRequest.Builder.() -> Unit): DescribeProductResponse = describeProduct(DescribeProductRequest.Builder().apply(block).build())

/**
 * Gets information about the specified product. This operation is run with administrator access.
 */
public suspend inline fun ServiceCatalogClient.describeProductAsAdmin(crossinline block: DescribeProductAsAdminRequest.Builder.() -> Unit): DescribeProductAsAdminResponse = describeProductAsAdmin(DescribeProductAsAdminRequest.Builder().apply(block).build())

/**
 * Gets information about the specified product.
 */
public suspend inline fun ServiceCatalogClient.describeProductView(crossinline block: DescribeProductViewRequest.Builder.() -> Unit): DescribeProductViewResponse = describeProductView(DescribeProductViewRequest.Builder().apply(block).build())

/**
 * Gets information about the specified provisioned product.
 */
public suspend inline fun ServiceCatalogClient.describeProvisionedProduct(crossinline block: DescribeProvisionedProductRequest.Builder.() -> Unit): DescribeProvisionedProductResponse = describeProvisionedProduct(DescribeProvisionedProductRequest.Builder().apply(block).build())

/**
 * Gets information about the resource changes for the specified plan.
 */
public suspend inline fun ServiceCatalogClient.describeProvisionedProductPlan(crossinline block: DescribeProvisionedProductPlanRequest.Builder.() -> Unit): DescribeProvisionedProductPlanResponse = describeProvisionedProductPlan(DescribeProvisionedProductPlanRequest.Builder().apply(block).build())

/**
 * Gets information about the specified provisioning artifact (also known as a version) for the specified product.
 */
public suspend inline fun ServiceCatalogClient.describeProvisioningArtifact(crossinline block: DescribeProvisioningArtifactRequest.Builder.() -> Unit): DescribeProvisioningArtifactResponse = describeProvisioningArtifact(DescribeProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Gets information about the configuration required to provision the specified product using the specified provisioning artifact.
 *
 * If the output contains a TagOption key with an empty list of values, there is a TagOption conflict for that key. The end user cannot take action to fix the conflict, and launch is not blocked. In subsequent calls to ProvisionProduct, do not include conflicted TagOption keys as tags, or this causes the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*". Tag the provisioned product with the value `sc-tagoption-conflict-portfolioId-productId`.
 */
public suspend inline fun ServiceCatalogClient.describeProvisioningParameters(crossinline block: DescribeProvisioningParametersRequest.Builder.() -> Unit): DescribeProvisioningParametersResponse = describeProvisioningParameters(DescribeProvisioningParametersRequest.Builder().apply(block).build())

/**
 * Gets information about the specified request operation.
 *
 * Use this operation after calling a request operation (for example, ProvisionProduct, TerminateProvisionedProduct, or UpdateProvisionedProduct).
 *
 * If a provisioned product was transferred to a new owner using UpdateProvisionedProductProperties, the new owner will be able to describe all past records for that product. The previous owner will no longer be able to describe the records, but will be able to use ListRecordHistory to see the product's history from when he was the owner.
 */
public suspend inline fun ServiceCatalogClient.describeRecord(crossinline block: DescribeRecordRequest.Builder.() -> Unit): DescribeRecordResponse = describeRecord(DescribeRecordRequest.Builder().apply(block).build())

/**
 * Describes a self-service action.
 */
public suspend inline fun ServiceCatalogClient.describeServiceAction(crossinline block: DescribeServiceActionRequest.Builder.() -> Unit): DescribeServiceActionResponse = describeServiceAction(DescribeServiceActionRequest.Builder().apply(block).build())

/**
 * Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user.
 */
public suspend inline fun ServiceCatalogClient.describeServiceActionExecutionParameters(crossinline block: DescribeServiceActionExecutionParametersRequest.Builder.() -> Unit): DescribeServiceActionExecutionParametersResponse = describeServiceActionExecutionParameters(DescribeServiceActionExecutionParametersRequest.Builder().apply(block).build())

/**
 * Gets information about the specified TagOption.
 */
public suspend inline fun ServiceCatalogClient.describeTagOption(crossinline block: DescribeTagOptionRequest.Builder.() -> Unit): DescribeTagOptionResponse = describeTagOption(DescribeTagOptionRequest.Builder().apply(block).build())

/**
 * Disable portfolio sharing through the Organizations service. This command will not delete your current shares, but prevents you from creating new shares throughout your organization. Current shares are not kept in sync with your organization structure if the structure changes after calling this API. Only the management account in the organization can call this API.
 *
 * You cannot call this API if there are active delegated administrators in the organization.
 *
 * Note that a delegated administrator is not authorized to invoke `DisableAWSOrganizationsAccess`.
 *
 * If you share an Service Catalog portfolio in an organization within Organizations, and then disable Organizations access for Service Catalog, the portfolio access permissions will not sync with the latest changes to the organization structure. Specifically, accounts that you removed from the organization after disabling Service Catalog access will retain access to the previously shared portfolio.
 */
public suspend inline fun ServiceCatalogClient.disableAwsOrganizationsAccess(crossinline block: DisableAwsOrganizationsAccessRequest.Builder.() -> Unit): DisableAwsOrganizationsAccessResponse = disableAwsOrganizationsAccess(DisableAwsOrganizationsAccessRequest.Builder().apply(block).build())

/**
 * Disassociates the specified budget from the specified resource.
 */
public suspend inline fun ServiceCatalogClient.disassociateBudgetFromResource(crossinline block: DisassociateBudgetFromResourceRequest.Builder.() -> Unit): DisassociateBudgetFromResourceResponse = disassociateBudgetFromResource(DisassociateBudgetFromResourceRequest.Builder().apply(block).build())

/**
 * Disassociates a previously associated principal ARN from a specified portfolio.
 *
 * The `PrincipalType` and `PrincipalARN` must match the `AssociatePrincipalWithPortfolio` call request details. For example, to disassociate an association created with a `PrincipalARN` of `PrincipalType` IAM you must use the `PrincipalType` IAM when calling `DisassociatePrincipalFromPortfolio`.
 *
 * For portfolios that have been shared with principal name sharing enabled: after disassociating a principal, share recipient accounts will no longer be able to provision products in this portfolio using a role matching the name of the associated principal.
 *
 * For more information, review [associate-principal-with-portfolio](https://docs.aws.amazon.com/cli/latest/reference/servicecatalog/associate-principal-with-portfolio.html#options) in the Amazon Web Services CLI Command Reference.
 *
 * If you disassociate a principal from a portfolio, with PrincipalType as `IAM`, the same principal will still have access to the portfolio if it matches one of the associated principals of type `IAM_PATTERN`. To fully remove access for a principal, verify all the associated Principals of type `IAM_PATTERN`, and then ensure you disassociate any `IAM_PATTERN` principals that match the principal whose access you are removing.
 */
public suspend inline fun ServiceCatalogClient.disassociatePrincipalFromPortfolio(crossinline block: DisassociatePrincipalFromPortfolioRequest.Builder.() -> Unit): DisassociatePrincipalFromPortfolioResponse = disassociatePrincipalFromPortfolio(DisassociatePrincipalFromPortfolioRequest.Builder().apply(block).build())

/**
 * Disassociates the specified product from the specified portfolio.
 *
 * A delegated admin is authorized to invoke this command.
 */
public suspend inline fun ServiceCatalogClient.disassociateProductFromPortfolio(crossinline block: DisassociateProductFromPortfolioRequest.Builder.() -> Unit): DisassociateProductFromPortfolioResponse = disassociateProductFromPortfolio(DisassociateProductFromPortfolioRequest.Builder().apply(block).build())

/**
 * Disassociates the specified self-service action association from the specified provisioning artifact.
 */
public suspend inline fun ServiceCatalogClient.disassociateServiceActionFromProvisioningArtifact(crossinline block: DisassociateServiceActionFromProvisioningArtifactRequest.Builder.() -> Unit): DisassociateServiceActionFromProvisioningArtifactResponse = disassociateServiceActionFromProvisioningArtifact(DisassociateServiceActionFromProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Disassociates the specified TagOption from the specified resource.
 */
public suspend inline fun ServiceCatalogClient.disassociateTagOptionFromResource(crossinline block: DisassociateTagOptionFromResourceRequest.Builder.() -> Unit): DisassociateTagOptionFromResourceResponse = disassociateTagOptionFromResource(DisassociateTagOptionFromResourceRequest.Builder().apply(block).build())

/**
 * Enable portfolio sharing feature through Organizations. This API will allow Service Catalog to receive updates on your organization in order to sync your shares with the current structure. This API can only be called by the management account in the organization.
 *
 * When you call this API, Service Catalog calls `organizations:EnableAWSServiceAccess` on your behalf so that your shares stay in sync with any changes in your Organizations structure.
 *
 * Note that a delegated administrator is not authorized to invoke `EnableAWSOrganizationsAccess`.
 *
 * If you have previously disabled Organizations access for Service Catalog, and then enable access again, the portfolio access permissions might not sync with the latest changes to the organization structure. Specifically, accounts that you removed from the organization after disabling Service Catalog access, and before you enabled access again, can retain access to the previously shared portfolio. As a result, an account that has been removed from the organization might still be able to create or manage Amazon Web Services resources when it is no longer authorized to do so. Amazon Web Services is working to resolve this issue.
 */
public suspend inline fun ServiceCatalogClient.enableAwsOrganizationsAccess(crossinline block: EnableAwsOrganizationsAccessRequest.Builder.() -> Unit): EnableAwsOrganizationsAccessResponse = enableAwsOrganizationsAccess(EnableAwsOrganizationsAccessRequest.Builder().apply(block).build())

/**
 * Provisions or modifies a product based on the resource changes for the specified plan.
 */
public suspend inline fun ServiceCatalogClient.executeProvisionedProductPlan(crossinline block: ExecuteProvisionedProductPlanRequest.Builder.() -> Unit): ExecuteProvisionedProductPlanResponse = executeProvisionedProductPlan(ExecuteProvisionedProductPlanRequest.Builder().apply(block).build())

/**
 * Executes a self-service action against a provisioned product.
 */
public suspend inline fun ServiceCatalogClient.executeProvisionedProductServiceAction(crossinline block: ExecuteProvisionedProductServiceActionRequest.Builder.() -> Unit): ExecuteProvisionedProductServiceActionResponse = executeProvisionedProductServiceAction(ExecuteProvisionedProductServiceActionRequest.Builder().apply(block).build())

/**
 * Get the Access Status for Organizations portfolio share feature. This API can only be called by the management account in the organization or by a delegated admin.
 */
public suspend inline fun ServiceCatalogClient.getAwsOrganizationsAccessStatus(crossinline block: GetAwsOrganizationsAccessStatusRequest.Builder.() -> Unit): GetAwsOrganizationsAccessStatusResponse = getAwsOrganizationsAccessStatus(GetAwsOrganizationsAccessStatusRequest.Builder().apply(block).build())

/**
 * This API takes either a `ProvisonedProductId` or a `ProvisionedProductName`, along with a list of one or more output keys, and responds with the key/value pairs of those outputs.
 */
public suspend inline fun ServiceCatalogClient.getProvisionedProductOutputs(crossinline block: GetProvisionedProductOutputsRequest.Builder.() -> Unit): GetProvisionedProductOutputsResponse = getProvisionedProductOutputs(GetProvisionedProductOutputsRequest.Builder().apply(block).build())

/**
 * Requests the import of a resource as an Service Catalog provisioned product that is associated to an Service Catalog product and provisioning artifact. Once imported, all supported governance actions are supported on the provisioned product.
 *
 *  Resource import only supports CloudFormation stack ARNs. CloudFormation StackSets, and non-root nested stacks, are not supported.
 *
 *  The CloudFormation stack must have one of the following statuses to be imported: `CREATE_COMPLETE`, `UPDATE_COMPLETE`, `UPDATE_ROLLBACK_COMPLETE`, `IMPORT_COMPLETE`, and `IMPORT_ROLLBACK_COMPLETE`.
 *
 *  Import of the resource requires that the CloudFormation stack template matches the associated Service Catalog product provisioning artifact.
 *
 *  When you import an existing CloudFormation stack into a portfolio, Service Catalog does not apply the product's associated constraints during the import process. Service Catalog applies the constraints after you call `UpdateProvisionedProduct` for the provisioned product.
 *
 *  The user or role that performs this operation must have the `cloudformation:GetTemplate` and `cloudformation:DescribeStacks` IAM policy permissions.
 *
 * You can only import one provisioned product at a time. The product's CloudFormation stack must have the `IMPORT_COMPLETE` status before you import another.
 */
public suspend inline fun ServiceCatalogClient.importAsProvisionedProduct(crossinline block: ImportAsProvisionedProductRequest.Builder.() -> Unit): ImportAsProvisionedProductResponse = importAsProvisionedProduct(ImportAsProvisionedProductRequest.Builder().apply(block).build())

/**
 * Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying the `PortfolioShareType`, you can list portfolios for which organizational shares were accepted by this account.
 */
public suspend inline fun ServiceCatalogClient.listAcceptedPortfolioShares(crossinline block: ListAcceptedPortfolioSharesRequest.Builder.() -> Unit): ListAcceptedPortfolioSharesResponse = listAcceptedPortfolioShares(ListAcceptedPortfolioSharesRequest.Builder().apply(block).build())

/**
 * Lists all the budgets associated to the specified resource.
 */
public suspend inline fun ServiceCatalogClient.listBudgetsForResource(crossinline block: ListBudgetsForResourceRequest.Builder.() -> Unit): ListBudgetsForResourceResponse = listBudgetsForResource(ListBudgetsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the constraints for the specified portfolio and product.
 */
public suspend inline fun ServiceCatalogClient.listConstraintsForPortfolio(crossinline block: ListConstraintsForPortfolioRequest.Builder.() -> Unit): ListConstraintsForPortfolioResponse = listConstraintsForPortfolio(ListConstraintsForPortfolioRequest.Builder().apply(block).build())

/**
 * Lists the paths to the specified product. A path describes how the user gets access to a specified product and is necessary when provisioning a product. A path also determines the constraints that are put on a product. A path is dependent on a specific product, porfolio, and principal.
 *
 *  When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to the portfolio. For more information, see [Granting users access](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html) in the *Service Catalog User Guide*.
 */
public suspend inline fun ServiceCatalogClient.listLaunchPaths(crossinline block: ListLaunchPathsRequest.Builder.() -> Unit): ListLaunchPathsResponse = listLaunchPaths(ListLaunchPathsRequest.Builder().apply(block).build())

/**
 * Lists the organization nodes that have access to the specified portfolio. This API can only be called by the management account in the organization or by a delegated admin.
 *
 * If a delegated admin is de-registered, they can no longer perform this operation.
 */
public suspend inline fun ServiceCatalogClient.listOrganizationPortfolioAccess(crossinline block: ListOrganizationPortfolioAccessRequest.Builder.() -> Unit): ListOrganizationPortfolioAccessResponse = listOrganizationPortfolioAccess(ListOrganizationPortfolioAccessRequest.Builder().apply(block).build())

/**
 * Lists the account IDs that have access to the specified portfolio.
 *
 * A delegated admin can list the accounts that have access to the shared portfolio. Note that if a delegated admin is de-registered, they can no longer perform this operation.
 */
public suspend inline fun ServiceCatalogClient.listPortfolioAccess(crossinline block: ListPortfolioAccessRequest.Builder.() -> Unit): ListPortfolioAccessResponse = listPortfolioAccess(ListPortfolioAccessRequest.Builder().apply(block).build())

/**
 * Lists all portfolios in the catalog.
 */
public suspend inline fun ServiceCatalogClient.listPortfolios(crossinline block: ListPortfoliosRequest.Builder.() -> Unit): ListPortfoliosResponse = listPortfolios(ListPortfoliosRequest.Builder().apply(block).build())

/**
 * Lists all portfolios that the specified product is associated with.
 */
public suspend inline fun ServiceCatalogClient.listPortfoliosForProduct(crossinline block: ListPortfoliosForProductRequest.Builder.() -> Unit): ListPortfoliosForProductResponse = listPortfoliosForProduct(ListPortfoliosForProductRequest.Builder().apply(block).build())

/**
 * Lists all `PrincipalARN`s and corresponding `PrincipalType`s associated with the specified portfolio.
 */
public suspend inline fun ServiceCatalogClient.listPrincipalsForPortfolio(crossinline block: ListPrincipalsForPortfolioRequest.Builder.() -> Unit): ListPrincipalsForPortfolioResponse = listPrincipalsForPortfolio(ListPrincipalsForPortfolioRequest.Builder().apply(block).build())

/**
 * Lists the plans for the specified provisioned product or all plans to which the user has access.
 */
public suspend inline fun ServiceCatalogClient.listProvisionedProductPlans(crossinline block: ListProvisionedProductPlansRequest.Builder.() -> Unit): ListProvisionedProductPlansResponse = listProvisionedProductPlans(ListProvisionedProductPlansRequest.Builder().apply(block).build())

/**
 * Lists all provisioning artifacts (also known as versions) for the specified product.
 */
public suspend inline fun ServiceCatalogClient.listProvisioningArtifacts(crossinline block: ListProvisioningArtifactsRequest.Builder.() -> Unit): ListProvisioningArtifactsResponse = listProvisioningArtifacts(ListProvisioningArtifactsRequest.Builder().apply(block).build())

/**
 * Lists all provisioning artifacts (also known as versions) for the specified self-service action.
 */
public suspend inline fun ServiceCatalogClient.listProvisioningArtifactsForServiceAction(crossinline block: ListProvisioningArtifactsForServiceActionRequest.Builder.() -> Unit): ListProvisioningArtifactsForServiceActionResponse = listProvisioningArtifactsForServiceAction(ListProvisioningArtifactsForServiceActionRequest.Builder().apply(block).build())

/**
 * Lists the specified requests or all performed requests.
 */
public suspend inline fun ServiceCatalogClient.listRecordHistory(crossinline block: ListRecordHistoryRequest.Builder.() -> Unit): ListRecordHistoryResponse = listRecordHistory(ListRecordHistoryRequest.Builder().apply(block).build())

/**
 * Lists the resources associated with the specified TagOption.
 */
public suspend inline fun ServiceCatalogClient.listResourcesForTagOption(crossinline block: ListResourcesForTagOptionRequest.Builder.() -> Unit): ListResourcesForTagOptionResponse = listResourcesForTagOption(ListResourcesForTagOptionRequest.Builder().apply(block).build())

/**
 * Lists all self-service actions.
 */
public suspend inline fun ServiceCatalogClient.listServiceActions(crossinline block: ListServiceActionsRequest.Builder.() -> Unit): ListServiceActionsResponse = listServiceActions(ListServiceActionsRequest.Builder().apply(block).build())

/**
 * Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID.
 */
public suspend inline fun ServiceCatalogClient.listServiceActionsForProvisioningArtifact(crossinline block: ListServiceActionsForProvisioningArtifactRequest.Builder.() -> Unit): ListServiceActionsForProvisioningArtifactResponse = listServiceActionsForProvisioningArtifact(ListServiceActionsForProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Returns summary information about stack instances that are associated with the specified `CFN_STACKSET` type provisioned product. You can filter for stack instances that are associated with a specific Amazon Web Services account name or Region.
 */
public suspend inline fun ServiceCatalogClient.listStackInstancesForProvisionedProduct(crossinline block: ListStackInstancesForProvisionedProductRequest.Builder.() -> Unit): ListStackInstancesForProvisionedProductResponse = listStackInstancesForProvisionedProduct(ListStackInstancesForProvisionedProductRequest.Builder().apply(block).build())

/**
 * Lists the specified TagOptions or all TagOptions.
 */
public suspend inline fun ServiceCatalogClient.listTagOptions(crossinline block: ListTagOptionsRequest.Builder.() -> Unit): ListTagOptionsResponse = listTagOptions(ListTagOptionsRequest.Builder().apply(block).build())

/**
 * Notifies the result of the provisioning engine execution.
 */
public suspend inline fun ServiceCatalogClient.notifyProvisionProductEngineWorkflowResult(crossinline block: NotifyProvisionProductEngineWorkflowResultRequest.Builder.() -> Unit): NotifyProvisionProductEngineWorkflowResultResponse = notifyProvisionProductEngineWorkflowResult(NotifyProvisionProductEngineWorkflowResultRequest.Builder().apply(block).build())

/**
 * Notifies the result of the terminate engine execution.
 */
public suspend inline fun ServiceCatalogClient.notifyTerminateProvisionedProductEngineWorkflowResult(crossinline block: NotifyTerminateProvisionedProductEngineWorkflowResultRequest.Builder.() -> Unit): NotifyTerminateProvisionedProductEngineWorkflowResultResponse = notifyTerminateProvisionedProductEngineWorkflowResult(NotifyTerminateProvisionedProductEngineWorkflowResultRequest.Builder().apply(block).build())

/**
 * Notifies the result of the update engine execution.
 */
public suspend inline fun ServiceCatalogClient.notifyUpdateProvisionedProductEngineWorkflowResult(crossinline block: NotifyUpdateProvisionedProductEngineWorkflowResultRequest.Builder.() -> Unit): NotifyUpdateProvisionedProductEngineWorkflowResultResponse = notifyUpdateProvisionedProductEngineWorkflowResult(NotifyUpdateProvisionedProductEngineWorkflowResultRequest.Builder().apply(block).build())

/**
 * Provisions the specified product.
 *
 *  A provisioned product is a resourced instance of a product. For example, provisioning a product that's based on an CloudFormation template launches an CloudFormation stack and its underlying resources. You can check the status of this request using DescribeRecord.
 *
 *  If the request contains a tag key with an empty list of values, there's a tag conflict for that key. Don't include conflicted keys as tags, or this will cause the error "Parameter validation failed: Missing required parameter in Tags&#91;*N*&#93;:*Value*".
 *
 *  When provisioning a product that's been added to a portfolio, you must grant your user, group, or role access to the portfolio. For more information, see [Granting users access](https://docs.aws.amazon.com/servicecatalog/latest/adminguide/catalogs_portfolios_users.html) in the *Service Catalog User Guide*.
 */
public suspend inline fun ServiceCatalogClient.provisionProduct(crossinline block: ProvisionProductRequest.Builder.() -> Unit): ProvisionProductResponse = provisionProduct(ProvisionProductRequest.Builder().apply(block).build())

/**
 * Rejects an offer to share the specified portfolio.
 */
public suspend inline fun ServiceCatalogClient.rejectPortfolioShare(crossinline block: RejectPortfolioShareRequest.Builder.() -> Unit): RejectPortfolioShareResponse = rejectPortfolioShare(RejectPortfolioShareRequest.Builder().apply(block).build())

/**
 * Lists the provisioned products that are available (not terminated).
 *
 * To use additional filtering, see SearchProvisionedProducts.
 */
public suspend inline fun ServiceCatalogClient.scanProvisionedProducts(crossinline block: ScanProvisionedProductsRequest.Builder.() -> Unit): ScanProvisionedProductsResponse = scanProvisionedProducts(ScanProvisionedProductsRequest.Builder().apply(block).build())

/**
 * Gets information about the products to which the caller has access.
 */
public suspend inline fun ServiceCatalogClient.searchProducts(crossinline block: SearchProductsRequest.Builder.() -> Unit): SearchProductsResponse = searchProducts(SearchProductsRequest.Builder().apply(block).build())

/**
 * Gets information about the products for the specified portfolio or all products.
 */
public suspend inline fun ServiceCatalogClient.searchProductsAsAdmin(crossinline block: SearchProductsAsAdminRequest.Builder.() -> Unit): SearchProductsAsAdminResponse = searchProductsAsAdmin(SearchProductsAsAdminRequest.Builder().apply(block).build())

/**
 * Gets information about the provisioned products that meet the specified criteria.
 */
public suspend inline fun ServiceCatalogClient.searchProvisionedProducts(crossinline block: SearchProvisionedProductsRequest.Builder.() -> Unit): SearchProvisionedProductsResponse = searchProvisionedProducts(SearchProvisionedProductsRequest.Builder().apply(block).build())

/**
 * Terminates the specified provisioned product.
 *
 * This operation does not delete any records associated with the provisioned product.
 *
 * You can check the status of this request using DescribeRecord.
 */
public suspend inline fun ServiceCatalogClient.terminateProvisionedProduct(crossinline block: TerminateProvisionedProductRequest.Builder.() -> Unit): TerminateProvisionedProductResponse = terminateProvisionedProduct(TerminateProvisionedProductRequest.Builder().apply(block).build())

/**
 * Updates the specified constraint.
 */
public suspend inline fun ServiceCatalogClient.updateConstraint(crossinline block: UpdateConstraintRequest.Builder.() -> Unit): UpdateConstraintResponse = updateConstraint(UpdateConstraintRequest.Builder().apply(block).build())

/**
 * Updates the specified portfolio.
 *
 * You cannot update a product that was shared with you.
 */
public suspend inline fun ServiceCatalogClient.updatePortfolio(crossinline block: UpdatePortfolioRequest.Builder.() -> Unit): UpdatePortfolioResponse = updatePortfolio(UpdatePortfolioRequest.Builder().apply(block).build())

/**
 * Updates the specified portfolio share. You can use this API to enable or disable `TagOptions` sharing or Principal sharing for an existing portfolio share.
 *
 * The portfolio share cannot be updated if the `CreatePortfolioShare` operation is `IN_PROGRESS`, as the share is not available to recipient entities. In this case, you must wait for the portfolio share to be completed.
 *
 * You must provide the `accountId` or organization node in the input, but not both.
 *
 * If the portfolio is shared to both an external account and an organization node, and both shares need to be updated, you must invoke `UpdatePortfolioShare` separately for each share type.
 *
 * This API cannot be used for removing the portfolio share. You must use `DeletePortfolioShare` API for that action.
 *
 * When you associate a principal with portfolio, a potential privilege escalation path may occur when that portfolio is then shared with other accounts. For a user in a recipient account who is *not* an Service Catalog Admin, but still has the ability to create Principals (Users/Groups/Roles), that user could create a role that matches a principal name association for the portfolio. Although this user may not know which principal names are associated through Service Catalog, they may be able to guess the user. If this potential escalation path is a concern, then Service Catalog recommends using `PrincipalType` as `IAM`. With this configuration, the `PrincipalARN` must already exist in the recipient account before it can be associated.
 */
public suspend inline fun ServiceCatalogClient.updatePortfolioShare(crossinline block: UpdatePortfolioShareRequest.Builder.() -> Unit): UpdatePortfolioShareResponse = updatePortfolioShare(UpdatePortfolioShareRequest.Builder().apply(block).build())

/**
 * Updates the specified product.
 */
public suspend inline fun ServiceCatalogClient.updateProduct(crossinline block: UpdateProductRequest.Builder.() -> Unit): UpdateProductResponse = updateProduct(UpdateProductRequest.Builder().apply(block).build())

/**
 * Requests updates to the configuration of the specified provisioned product.
 *
 * If there are tags associated with the object, they cannot be updated or added. Depending on the specific updates requested, this operation can update with no interruption, with some interruption, or replace the provisioned product entirely.
 *
 * You can check the status of this request using DescribeRecord.
 */
public suspend inline fun ServiceCatalogClient.updateProvisionedProduct(crossinline block: UpdateProvisionedProductRequest.Builder.() -> Unit): UpdateProvisionedProductResponse = updateProvisionedProduct(UpdateProvisionedProductRequest.Builder().apply(block).build())

/**
 * Requests updates to the properties of the specified provisioned product.
 */
public suspend inline fun ServiceCatalogClient.updateProvisionedProductProperties(crossinline block: UpdateProvisionedProductPropertiesRequest.Builder.() -> Unit): UpdateProvisionedProductPropertiesResponse = updateProvisionedProductProperties(UpdateProvisionedProductPropertiesRequest.Builder().apply(block).build())

/**
 * Updates the specified provisioning artifact (also known as a version) for the specified product.
 *
 * You cannot update a provisioning artifact for a product that was shared with you.
 */
public suspend inline fun ServiceCatalogClient.updateProvisioningArtifact(crossinline block: UpdateProvisioningArtifactRequest.Builder.() -> Unit): UpdateProvisioningArtifactResponse = updateProvisioningArtifact(UpdateProvisioningArtifactRequest.Builder().apply(block).build())

/**
 * Updates a self-service action.
 */
public suspend inline fun ServiceCatalogClient.updateServiceAction(crossinline block: UpdateServiceActionRequest.Builder.() -> Unit): UpdateServiceActionResponse = updateServiceAction(UpdateServiceActionRequest.Builder().apply(block).build())

/**
 * Updates the specified TagOption.
 */
public suspend inline fun ServiceCatalogClient.updateTagOption(crossinline block: UpdateTagOptionRequest.Builder.() -> Unit): UpdateTagOptionResponse = updateTagOption(UpdateTagOptionRequest.Builder().apply(block).build())
