// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

public class AssociatePrincipalWithPortfolioRequest private constructor(builder: Builder) {
    /**
     * The language code.
     * + `jp` - Japanese
     * + `zh` - Chinese
     */
    public val acceptLanguage: kotlin.String? = builder.acceptLanguage
    /**
     * The portfolio identifier.
     */
    public val portfolioId: kotlin.String? = builder.portfolioId
    /**
     * The ARN of the principal (user, role, or group). If the `PrincipalType` is `IAM`, the supported value is a fully defined [IAM Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). If the `PrincipalType` is `IAM_PATTERN`, the supported value is an `IAM` ARN *without an AccountID* in the following format:
     *
     * *arn:partition:iam:::resource-type/resource-id*
     *
     * The ARN resource-id can be either:
     * + A fully formed resource-id. For example, *arn:aws:iam:::role/resource-name* or *arn:aws:iam:::role/resource-path/resource-name*
     * + A wildcard ARN. The wildcard ARN accepts `IAM_PATTERN` values with a "*" or "?" in the resource-id segment of the ARN. For example *arn:partition:service:::resource-type/resource-path/resource-name*. The new symbols are exclusive to the **resource-path** and **resource-name** and cannot replace the **resource-type** or other ARN values. The ARN path and principal name allow unlimited wildcard characters.
     *
     * Examples of an **acceptable** wildcard ARN:
     * + arn:aws:iam:::role/ResourceName_*
     * + arn:aws:iam:::role&#47;*&#47;ResourceName_?
     *
     * Examples of an **unacceptable** wildcard ARN:
     * + arn:aws:iam:::*&#47;ResourceName
     *
     * You can associate multiple `IAM_PATTERN`s even if the account has no principal with that name.
     *
     * The "?" wildcard character matches zero or one of any character. This is similar to ".?" in regular regex context. The "*" wildcard character matches any number of any characters. This is similar to ".*" in regular regex context.
     *
     * In the IAM Principal ARN format (*arn:partition:iam:::resource-type/resource-path/resource-name*), valid resource-type values include **user&#47;**, **group&#47;**, or **role&#47;**. The "?" and "*" characters are allowed only after the resource-type in the resource-id segment. You can use special characters anywhere within the resource-id.
     *
     * The "*" character also matches the "/" character, allowing paths to be formed *within* the resource-id. For example, *arn:aws:iam:::role&#47;*****&#47;ResourceName_?* matches both *arn:aws:iam:::role/pathA/pathB/ResourceName_1* and *arn:aws:iam:::role/pathA/ResourceName_1*.
     */
    public val principalArn: kotlin.String? = builder.principalArn
    /**
     * The principal type. The supported value is `IAM` if you use a fully defined Amazon Resource Name (ARN), or `IAM_PATTERN` if you use an ARN with no `accountID`, with or without wildcard characters.
     */
    public val principalType: aws.sdk.kotlin.services.servicecatalog.model.PrincipalType? = builder.principalType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociatePrincipalWithPortfolioRequest(")
        append("acceptLanguage=$acceptLanguage,")
        append("portfolioId=$portfolioId,")
        append("principalArn=$principalArn,")
        append("principalType=$principalType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptLanguage?.hashCode() ?: 0
        result = 31 * result + (portfolioId?.hashCode() ?: 0)
        result = 31 * result + (principalArn?.hashCode() ?: 0)
        result = 31 * result + (principalType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociatePrincipalWithPortfolioRequest

        if (acceptLanguage != other.acceptLanguage) return false
        if (portfolioId != other.portfolioId) return false
        if (principalArn != other.principalArn) return false
        if (principalType != other.principalType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The language code.
         * + `jp` - Japanese
         * + `zh` - Chinese
         */
        public var acceptLanguage: kotlin.String? = null
        /**
         * The portfolio identifier.
         */
        public var portfolioId: kotlin.String? = null
        /**
         * The ARN of the principal (user, role, or group). If the `PrincipalType` is `IAM`, the supported value is a fully defined [IAM Amazon Resource Name (ARN)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). If the `PrincipalType` is `IAM_PATTERN`, the supported value is an `IAM` ARN *without an AccountID* in the following format:
         *
         * *arn:partition:iam:::resource-type/resource-id*
         *
         * The ARN resource-id can be either:
         * + A fully formed resource-id. For example, *arn:aws:iam:::role/resource-name* or *arn:aws:iam:::role/resource-path/resource-name*
         * + A wildcard ARN. The wildcard ARN accepts `IAM_PATTERN` values with a "*" or "?" in the resource-id segment of the ARN. For example *arn:partition:service:::resource-type/resource-path/resource-name*. The new symbols are exclusive to the **resource-path** and **resource-name** and cannot replace the **resource-type** or other ARN values. The ARN path and principal name allow unlimited wildcard characters.
         *
         * Examples of an **acceptable** wildcard ARN:
         * + arn:aws:iam:::role/ResourceName_*
         * + arn:aws:iam:::role&#47;*&#47;ResourceName_?
         *
         * Examples of an **unacceptable** wildcard ARN:
         * + arn:aws:iam:::*&#47;ResourceName
         *
         * You can associate multiple `IAM_PATTERN`s even if the account has no principal with that name.
         *
         * The "?" wildcard character matches zero or one of any character. This is similar to ".?" in regular regex context. The "*" wildcard character matches any number of any characters. This is similar to ".*" in regular regex context.
         *
         * In the IAM Principal ARN format (*arn:partition:iam:::resource-type/resource-path/resource-name*), valid resource-type values include **user&#47;**, **group&#47;**, or **role&#47;**. The "?" and "*" characters are allowed only after the resource-type in the resource-id segment. You can use special characters anywhere within the resource-id.
         *
         * The "*" character also matches the "/" character, allowing paths to be formed *within* the resource-id. For example, *arn:aws:iam:::role&#47;*****&#47;ResourceName_?* matches both *arn:aws:iam:::role/pathA/pathB/ResourceName_1* and *arn:aws:iam:::role/pathA/ResourceName_1*.
         */
        public var principalArn: kotlin.String? = null
        /**
         * The principal type. The supported value is `IAM` if you use a fully defined Amazon Resource Name (ARN), or `IAM_PATTERN` if you use an ARN with no `accountID`, with or without wildcard characters.
         */
        public var principalType: aws.sdk.kotlin.services.servicecatalog.model.PrincipalType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest) : this() {
            this.acceptLanguage = x.acceptLanguage
            this.portfolioId = x.portfolioId
            this.principalArn = x.principalArn
            this.principalType = x.principalType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.AssociatePrincipalWithPortfolioRequest = AssociatePrincipalWithPortfolioRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
