// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CopyProductRequest private constructor(builder: Builder) {
    /**
     * The language code.
     * + `jp` - Japanese
     * + `zh` - Chinese
     */
    public val acceptLanguage: kotlin.String? = builder.acceptLanguage
    /**
     * The copy options. If the value is `CopyTags`, the tags from the source product are copied to the target product.
     */
    public val copyOptions: List<CopyOption>? = builder.copyOptions
    /**
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The Amazon Resource Name (ARN) of the source product.
     */
    public val sourceProductArn: kotlin.String? = builder.sourceProductArn
    /**
     * The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all provisioning artifacts are copied.
     */
    public val sourceProvisioningArtifactIdentifiers: List<Map<ProvisioningArtifactPropertyName, String>>? = builder.sourceProvisioningArtifactIdentifiers
    /**
     * The identifier of the target product. By default, a new product is created.
     */
    public val targetProductId: kotlin.String? = builder.targetProductId
    /**
     * A name for the target product. The default is the name of the source product.
     */
    public val targetProductName: kotlin.String? = builder.targetProductName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.CopyProductRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyProductRequest(")
        append("acceptLanguage=$acceptLanguage,")
        append("copyOptions=$copyOptions,")
        append("idempotencyToken=$idempotencyToken,")
        append("sourceProductArn=$sourceProductArn,")
        append("sourceProvisioningArtifactIdentifiers=$sourceProvisioningArtifactIdentifiers,")
        append("targetProductId=$targetProductId,")
        append("targetProductName=$targetProductName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptLanguage?.hashCode() ?: 0
        result = 31 * result + (copyOptions?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (sourceProductArn?.hashCode() ?: 0)
        result = 31 * result + (sourceProvisioningArtifactIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (targetProductId?.hashCode() ?: 0)
        result = 31 * result + (targetProductName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyProductRequest

        if (acceptLanguage != other.acceptLanguage) return false
        if (copyOptions != other.copyOptions) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (sourceProductArn != other.sourceProductArn) return false
        if (sourceProvisioningArtifactIdentifiers != other.sourceProvisioningArtifactIdentifiers) return false
        if (targetProductId != other.targetProductId) return false
        if (targetProductName != other.targetProductName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.CopyProductRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The language code.
         * + `jp` - Japanese
         * + `zh` - Chinese
         */
        public var acceptLanguage: kotlin.String? = null
        /**
         * The copy options. If the value is `CopyTags`, the tags from the source product are copied to the target product.
         */
        public var copyOptions: List<CopyOption>? = null
        /**
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the source product.
         */
        public var sourceProductArn: kotlin.String? = null
        /**
         * The identifiers of the provisioning artifacts (also known as versions) of the product to copy. By default, all provisioning artifacts are copied.
         */
        public var sourceProvisioningArtifactIdentifiers: List<Map<ProvisioningArtifactPropertyName, String>>? = null
        /**
         * The identifier of the target product. By default, a new product is created.
         */
        public var targetProductId: kotlin.String? = null
        /**
         * A name for the target product. The default is the name of the source product.
         */
        public var targetProductName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.CopyProductRequest) : this() {
            this.acceptLanguage = x.acceptLanguage
            this.copyOptions = x.copyOptions
            this.idempotencyToken = x.idempotencyToken
            this.sourceProductArn = x.sourceProductArn
            this.sourceProvisioningArtifactIdentifiers = x.sourceProvisioningArtifactIdentifiers
            this.targetProductId = x.targetProductId
            this.targetProductName = x.targetProductName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.CopyProductRequest = CopyProductRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
