// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateConstraintRequest private constructor(builder: Builder) {
    /**
     * The language code.
     * + `jp` - Japanese
     * + `zh` - Chinese
     */
    public val acceptLanguage: kotlin.String? = builder.acceptLanguage
    /**
     * The description of the constraint.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:
     *
     * ## LAUNCH
     * You are required to specify either the `RoleArn` or the `LocalRoleName` but can't use both.
     *
     * Specify the `RoleArn` property as follows:
     *
     * `{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}`
     *
     * Specify the `LocalRoleName` property as follows:
     *
     * `{"LocalRoleName": "SCBasicLaunchRole"}`
     *
     * If you specify the `LocalRoleName` property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.
     *
     * The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.
     *
     * You cannot have both a `LAUNCH` and a `STACKSET` constraint.
     *
     * You also cannot have more than one `LAUNCH` constraint on a product and portfolio.
     *
     * ## NOTIFICATION
     * Specify the `NotificationArns` property as follows:
     *
     * `{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}`
     *
     * ## RESOURCE_UPDATE
     * Specify the `TagUpdatesOnProvisionedProduct` property as follows:
     *
     * `{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}`
     *
     * The `TagUpdatesOnProvisionedProduct` property accepts a string value of `ALLOWED` or `NOT_ALLOWED`.
     *
     * ## STACKSET
     * Specify the `Parameters` property as follows:
     *
     * `{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}`
     *
     * You cannot have both a `LAUNCH` and a `STACKSET` constraint.
     *
     * You also cannot have more than one `STACKSET` constraint on a product and portfolio.
     *
     * Products with a `STACKSET` constraint will launch an CloudFormation stack set.
     *
     * ## TEMPLATE
     * Specify the `Rules` property. For more information, see [Template Constraint Rules](http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html).
     */
    public val parameters: kotlin.String? = builder.parameters
    /**
     * The portfolio identifier.
     */
    public val portfolioId: kotlin.String? = builder.portfolioId
    /**
     * The product identifier.
     */
    public val productId: kotlin.String? = builder.productId
    /**
     * The type of constraint.
     * + `LAUNCH`
     * + `NOTIFICATION`
     * + `RESOURCE_UPDATE`
     * + `STACKSET`
     * + `TEMPLATE`
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.CreateConstraintRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateConstraintRequest(")
        append("acceptLanguage=$acceptLanguage,")
        append("description=$description,")
        append("idempotencyToken=$idempotencyToken,")
        append("parameters=$parameters,")
        append("portfolioId=$portfolioId,")
        append("productId=$productId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptLanguage?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (portfolioId?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateConstraintRequest

        if (acceptLanguage != other.acceptLanguage) return false
        if (description != other.description) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (parameters != other.parameters) return false
        if (portfolioId != other.portfolioId) return false
        if (productId != other.productId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.CreateConstraintRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The language code.
         * + `jp` - Japanese
         * + `zh` - Chinese
         */
        public var acceptLanguage: kotlin.String? = null
        /**
         * The description of the constraint.
         */
        public var description: kotlin.String? = null
        /**
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:
         *
         * ## LAUNCH
         * You are required to specify either the `RoleArn` or the `LocalRoleName` but can't use both.
         *
         * Specify the `RoleArn` property as follows:
         *
         * `{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}`
         *
         * Specify the `LocalRoleName` property as follows:
         *
         * `{"LocalRoleName": "SCBasicLaunchRole"}`
         *
         * If you specify the `LocalRoleName` property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.
         *
         * The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.
         *
         * You cannot have both a `LAUNCH` and a `STACKSET` constraint.
         *
         * You also cannot have more than one `LAUNCH` constraint on a product and portfolio.
         *
         * ## NOTIFICATION
         * Specify the `NotificationArns` property as follows:
         *
         * `{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}`
         *
         * ## RESOURCE_UPDATE
         * Specify the `TagUpdatesOnProvisionedProduct` property as follows:
         *
         * `{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}`
         *
         * The `TagUpdatesOnProvisionedProduct` property accepts a string value of `ALLOWED` or `NOT_ALLOWED`.
         *
         * ## STACKSET
         * Specify the `Parameters` property as follows:
         *
         * `{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}`
         *
         * You cannot have both a `LAUNCH` and a `STACKSET` constraint.
         *
         * You also cannot have more than one `STACKSET` constraint on a product and portfolio.
         *
         * Products with a `STACKSET` constraint will launch an CloudFormation stack set.
         *
         * ## TEMPLATE
         * Specify the `Rules` property. For more information, see [Template Constraint Rules](http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html).
         */
        public var parameters: kotlin.String? = null
        /**
         * The portfolio identifier.
         */
        public var portfolioId: kotlin.String? = null
        /**
         * The product identifier.
         */
        public var productId: kotlin.String? = null
        /**
         * The type of constraint.
         * + `LAUNCH`
         * + `NOTIFICATION`
         * + `RESOURCE_UPDATE`
         * + `STACKSET`
         * + `TEMPLATE`
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.CreateConstraintRequest) : this() {
            this.acceptLanguage = x.acceptLanguage
            this.description = x.description
            this.idempotencyToken = x.idempotencyToken
            this.parameters = x.parameters
            this.portfolioId = x.portfolioId
            this.productId = x.productId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.CreateConstraintRequest = CreateConstraintRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
