// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribePortfolioSharesRequest private constructor(builder: Builder) {
    /**
     * The maximum number of items to return with this call.
     */
    public val pageSize: kotlin.Int? = builder.pageSize
    /**
     * The page token for the next set of results. To retrieve the first set of results, use null.
     */
    public val pageToken: kotlin.String? = builder.pageToken
    /**
     * The unique identifier of the portfolio for which shares will be retrieved.
     */
    public val portfolioId: kotlin.String? = builder.portfolioId
    /**
     * The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following:
     *
     * 1. `ACCOUNT` - Represents an external account to account share.
     *
     * 2. `ORGANIZATION` - Represents a share to an organization. This share is available to every account in the organization.
     *
     * 3. `ORGANIZATIONAL_UNIT` - Represents a share to an organizational unit.
     *
     * 4. `ORGANIZATION_MEMBER_ACCOUNT` - Represents a share to an account in the organization.
     */
    public val type: aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioShareType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioSharesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePortfolioSharesRequest(")
        append("pageSize=$pageSize,")
        append("pageToken=$pageToken,")
        append("portfolioId=$portfolioId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = pageSize ?: 0
        result = 31 * result + (pageToken?.hashCode() ?: 0)
        result = 31 * result + (portfolioId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePortfolioSharesRequest

        if (pageSize != other.pageSize) return false
        if (pageToken != other.pageToken) return false
        if (portfolioId != other.portfolioId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioSharesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The maximum number of items to return with this call.
         */
        public var pageSize: kotlin.Int? = null
        /**
         * The page token for the next set of results. To retrieve the first set of results, use null.
         */
        public var pageToken: kotlin.String? = null
        /**
         * The unique identifier of the portfolio for which shares will be retrieved.
         */
        public var portfolioId: kotlin.String? = null
        /**
         * The type of portfolio share to summarize. This field acts as a filter on the type of portfolio share, which can be one of the following:
         *
         * 1. `ACCOUNT` - Represents an external account to account share.
         *
         * 2. `ORGANIZATION` - Represents a share to an organization. This share is available to every account in the organization.
         *
         * 3. `ORGANIZATIONAL_UNIT` - Represents a share to an organizational unit.
         *
         * 4. `ORGANIZATION_MEMBER_ACCOUNT` - Represents a share to an account in the organization.
         */
        public var type: aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioShareType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioSharesRequest) : this() {
            this.pageSize = x.pageSize
            this.pageToken = x.pageToken
            this.portfolioId = x.portfolioId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioSharesRequest = DescribePortfolioSharesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
