// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The constraints that the administrator has put on the parameter.
 */
public class ParameterConstraints private constructor(builder: Builder) {
    /**
     * A regular expression that represents the patterns that allow for `String` types. The pattern must match the entire parameter value provided.
     */
    public val allowedPattern: kotlin.String? = builder.allowedPattern
    /**
     * The values that the administrator has allowed for the parameter.
     */
    public val allowedValues: List<String>? = builder.allowedValues
    /**
     * A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of `[A-Za-z0-9]+` displays the following error message when the user specifies an invalid value:
     *
     * `Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+`
     *
     * By adding a constraint description, such as must only contain letters (uppercase and lowercase) and numbers, you can display the following customized error message:
     *
     * `Malformed input-Parameter MyParameter must only contain uppercase and lowercase letters and numbers.`
     */
    public val constraintDescription: kotlin.String? = builder.constraintDescription
    /**
     * An integer value that determines the largest number of characters you want to allow for `String` types.
     */
    public val maxLength: kotlin.String? = builder.maxLength
    /**
     * A numeric value that determines the largest numeric value you want to allow for `Number` types.
     */
    public val maxValue: kotlin.String? = builder.maxValue
    /**
     * An integer value that determines the smallest number of characters you want to allow for `String` types.
     */
    public val minLength: kotlin.String? = builder.minLength
    /**
     * A numeric value that determines the smallest numeric value you want to allow for `Number` types.
     */
    public val minValue: kotlin.String? = builder.minValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ParameterConstraints = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParameterConstraints(")
        append("allowedPattern=$allowedPattern,")
        append("allowedValues=$allowedValues,")
        append("constraintDescription=$constraintDescription,")
        append("maxLength=$maxLength,")
        append("maxValue=$maxValue,")
        append("minLength=$minLength,")
        append("minValue=$minValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedPattern?.hashCode() ?: 0
        result = 31 * result + (allowedValues?.hashCode() ?: 0)
        result = 31 * result + (constraintDescription?.hashCode() ?: 0)
        result = 31 * result + (maxLength?.hashCode() ?: 0)
        result = 31 * result + (maxValue?.hashCode() ?: 0)
        result = 31 * result + (minLength?.hashCode() ?: 0)
        result = 31 * result + (minValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParameterConstraints

        if (allowedPattern != other.allowedPattern) return false
        if (allowedValues != other.allowedValues) return false
        if (constraintDescription != other.constraintDescription) return false
        if (maxLength != other.maxLength) return false
        if (maxValue != other.maxValue) return false
        if (minLength != other.minLength) return false
        if (minValue != other.minValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ParameterConstraints = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A regular expression that represents the patterns that allow for `String` types. The pattern must match the entire parameter value provided.
         */
        public var allowedPattern: kotlin.String? = null
        /**
         * The values that the administrator has allowed for the parameter.
         */
        public var allowedValues: List<String>? = null
        /**
         * A string that explains a constraint when the constraint is violated. For example, without a constraint description, a parameter that has an allowed pattern of `[A-Za-z0-9]+` displays the following error message when the user specifies an invalid value:
         *
         * `Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+`
         *
         * By adding a constraint description, such as must only contain letters (uppercase and lowercase) and numbers, you can display the following customized error message:
         *
         * `Malformed input-Parameter MyParameter must only contain uppercase and lowercase letters and numbers.`
         */
        public var constraintDescription: kotlin.String? = null
        /**
         * An integer value that determines the largest number of characters you want to allow for `String` types.
         */
        public var maxLength: kotlin.String? = null
        /**
         * A numeric value that determines the largest numeric value you want to allow for `Number` types.
         */
        public var maxValue: kotlin.String? = null
        /**
         * An integer value that determines the smallest number of characters you want to allow for `String` types.
         */
        public var minLength: kotlin.String? = null
        /**
         * A numeric value that determines the smallest numeric value you want to allow for `Number` types.
         */
        public var minValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ParameterConstraints) : this() {
            this.allowedPattern = x.allowedPattern
            this.allowedValues = x.allowedValues
            this.constraintDescription = x.constraintDescription
            this.maxLength = x.maxLength
            this.maxValue = x.maxValue
            this.minLength = x.minLength
            this.minValue = x.minValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ParameterConstraints = ParameterConstraints(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
