// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the portfolio share.
 */
public class PortfolioShareDetail private constructor(builder: Builder) {
    /**
     * Indicates whether the shared portfolio is imported by the recipient account. If the recipient is in an organization node, the share is automatically imported, and the field is always set to true.
     */
    public val accepted: kotlin.Boolean = builder.accepted
    /**
     * The identifier of the recipient entity that received the portfolio share. The recipient entity can be one of the following:
     *
     * 1. An external account.
     *
     * 2. An organziation member account.
     *
     * 3. An organzational unit (OU).
     *
     * 4. The organization itself. (This shares with every account in the organization).
     */
    public val principalId: kotlin.String? = builder.principalId
    /**
     * Indicates if `Principal` sharing is enabled or disabled for the portfolio share.
     */
    public val sharePrincipals: kotlin.Boolean = builder.sharePrincipals
    /**
     * Indicates whether TagOptions sharing is enabled or disabled for the portfolio share.
     */
    public val shareTagOptions: kotlin.Boolean = builder.shareTagOptions
    /**
     * The type of the portfolio share.
     */
    public val type: aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioShareType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.PortfolioShareDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PortfolioShareDetail(")
        append("accepted=$accepted,")
        append("principalId=$principalId,")
        append("sharePrincipals=$sharePrincipals,")
        append("shareTagOptions=$shareTagOptions,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accepted.hashCode()
        result = 31 * result + (principalId?.hashCode() ?: 0)
        result = 31 * result + (sharePrincipals.hashCode())
        result = 31 * result + (shareTagOptions.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PortfolioShareDetail

        if (accepted != other.accepted) return false
        if (principalId != other.principalId) return false
        if (sharePrincipals != other.sharePrincipals) return false
        if (shareTagOptions != other.shareTagOptions) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.PortfolioShareDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the shared portfolio is imported by the recipient account. If the recipient is in an organization node, the share is automatically imported, and the field is always set to true.
         */
        public var accepted: kotlin.Boolean = false
        /**
         * The identifier of the recipient entity that received the portfolio share. The recipient entity can be one of the following:
         *
         * 1. An external account.
         *
         * 2. An organziation member account.
         *
         * 3. An organzational unit (OU).
         *
         * 4. The organization itself. (This shares with every account in the organization).
         */
        public var principalId: kotlin.String? = null
        /**
         * Indicates if `Principal` sharing is enabled or disabled for the portfolio share.
         */
        public var sharePrincipals: kotlin.Boolean = false
        /**
         * Indicates whether TagOptions sharing is enabled or disabled for the portfolio share.
         */
        public var shareTagOptions: kotlin.Boolean = false
        /**
         * The type of the portfolio share.
         */
        public var type: aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioShareType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.PortfolioShareDetail) : this() {
            this.accepted = x.accepted
            this.principalId = x.principalId
            this.sharePrincipals = x.sharePrincipals
            this.shareTagOptions = x.shareTagOptions
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.PortfolioShareDetail = PortfolioShareDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
