// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a product view.
 */
public class ProductViewDetail private constructor(builder: Builder) {
    /**
     * The UTC time stamp of the creation time.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The ARN of the product.
     */
    public val productArn: kotlin.String? = builder.productArn
    /**
     * Summary information about the product view.
     */
    public val productViewSummary: aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary? = builder.productViewSummary
    /**
     * A top level `ProductViewDetail` response containing details about the product’s connection. Service Catalog returns this field for the `CreateProduct`, `UpdateProduct`, `DescribeProductAsAdmin`, and `SearchProductAsAdmin` APIs. This response contains the same fields as the `ConnectionParameters` request, with the addition of the `LastSync` response.
     */
    public val sourceConnection: aws.sdk.kotlin.services.servicecatalog.model.SourceConnectionDetail? = builder.sourceConnection
    /**
     * The status of the product.
     * + `AVAILABLE` - The product is ready for use.
     * + `CREATING` - Product creation has started; the product is not ready for use.
     * + `FAILED` - An action failed.
     */
    public val status: aws.sdk.kotlin.services.servicecatalog.model.Status? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProductViewDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProductViewDetail(")
        append("createdTime=$createdTime,")
        append("productArn=$productArn,")
        append("productViewSummary=$productViewSummary,")
        append("sourceConnection=$sourceConnection,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdTime?.hashCode() ?: 0
        result = 31 * result + (productArn?.hashCode() ?: 0)
        result = 31 * result + (productViewSummary?.hashCode() ?: 0)
        result = 31 * result + (sourceConnection?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProductViewDetail

        if (createdTime != other.createdTime) return false
        if (productArn != other.productArn) return false
        if (productViewSummary != other.productViewSummary) return false
        if (sourceConnection != other.sourceConnection) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProductViewDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The UTC time stamp of the creation time.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the product.
         */
        public var productArn: kotlin.String? = null
        /**
         * Summary information about the product view.
         */
        public var productViewSummary: aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary? = null
        /**
         * A top level `ProductViewDetail` response containing details about the product’s connection. Service Catalog returns this field for the `CreateProduct`, `UpdateProduct`, `DescribeProductAsAdmin`, and `SearchProductAsAdmin` APIs. This response contains the same fields as the `ConnectionParameters` request, with the addition of the `LastSync` response.
         */
        public var sourceConnection: aws.sdk.kotlin.services.servicecatalog.model.SourceConnectionDetail? = null
        /**
         * The status of the product.
         * + `AVAILABLE` - The product is ready for use.
         * + `CREATING` - Product creation has started; the product is not ready for use.
         * + `FAILED` - An action failed.
         */
        public var status: aws.sdk.kotlin.services.servicecatalog.model.Status? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProductViewDetail) : this() {
            this.createdTime = x.createdTime
            this.productArn = x.productArn
            this.productViewSummary = x.productViewSummary
            this.sourceConnection = x.sourceConnection
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProductViewDetail = ProductViewDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary] inside the given [block]
         */
        public fun productViewSummary(block: aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary.Builder.() -> kotlin.Unit) {
            this.productViewSummary = aws.sdk.kotlin.services.servicecatalog.model.ProductViewSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.servicecatalog.model.SourceConnectionDetail] inside the given [block]
         */
        public fun sourceConnection(block: aws.sdk.kotlin.services.servicecatalog.model.SourceConnectionDetail.Builder.() -> kotlin.Unit) {
            this.sourceConnection = aws.sdk.kotlin.services.servicecatalog.model.SourceConnectionDetail.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
