// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a provisioned product.
 */
public class ProvisionedProductDetail private constructor(builder: Builder) {
    /**
     * The ARN of the provisioned product.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The UTC time stamp of the creation time.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The identifier of the provisioned product.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The record identifier of the last request performed on this provisioned product of the following types:
     * +  ProvisionProduct
     * +  UpdateProvisionedProduct
     * +  ExecuteProvisionedProductPlan
     * +  TerminateProvisionedProduct
     */
    public val lastProvisioningRecordId: kotlin.String? = builder.lastProvisioningRecordId
    /**
     * The record identifier of the last request performed on this provisioned product.
     */
    public val lastRecordId: kotlin.String? = builder.lastRecordId
    /**
     * The record identifier of the last successful request performed on this provisioned product of the following types:
     * +  ProvisionProduct
     * +  UpdateProvisionedProduct
     * +  ExecuteProvisionedProductPlan
     * +  TerminateProvisionedProduct
     */
    public val lastSuccessfulProvisioningRecordId: kotlin.String? = builder.lastSuccessfulProvisioningRecordId
    /**
     * The ARN of the launch role associated with the provisioned product.
     */
    public val launchRoleArn: kotlin.String? = builder.launchRoleArn
    /**
     * The user-friendly name of the provisioned product.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The product identifier. For example, `prod-abcdzk7xy33qa`.
     */
    public val productId: kotlin.String? = builder.productId
    /**
     * The identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`.
     */
    public val provisioningArtifactId: kotlin.String? = builder.provisioningArtifactId
    /**
     * The current status of the provisioned product.
     * + `AVAILABLE` - Stable state, ready to perform any operation. The most recent operation succeeded and completed.
     * + `UNDER_CHANGE` - Transitive state. Operations performed might not have valid results. Wait for an `AVAILABLE` status before performing operations.
     * + `TAINTED` - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.
     * + `ERROR` - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
     * + `PLAN_IN_PROGRESS` - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an `AVAILABLE` status before performing operations.
     */
    public val status: aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductStatus? = builder.status
    /**
     * The current status message of the provisioned product.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage
    /**
     * The type of provisioned product. The supported values are `CFN_STACK`, `CFN_STACKSET`, `TERRAFORM_OPEN_SOURCE`, `TERRAFORM_CLOUD`, and `EXTERNAL`.
     */
    public val type: kotlin.String? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisionedProductDetail(")
        append("arn=$arn,")
        append("createdTime=$createdTime,")
        append("id=$id,")
        append("idempotencyToken=$idempotencyToken,")
        append("lastProvisioningRecordId=$lastProvisioningRecordId,")
        append("lastRecordId=$lastRecordId,")
        append("lastSuccessfulProvisioningRecordId=$lastSuccessfulProvisioningRecordId,")
        append("launchRoleArn=$launchRoleArn,")
        append("name=$name,")
        append("productId=$productId,")
        append("provisioningArtifactId=$provisioningArtifactId,")
        append("status=$status,")
        append("statusMessage=$statusMessage,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (lastProvisioningRecordId?.hashCode() ?: 0)
        result = 31 * result + (lastRecordId?.hashCode() ?: 0)
        result = 31 * result + (lastSuccessfulProvisioningRecordId?.hashCode() ?: 0)
        result = 31 * result + (launchRoleArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (productId?.hashCode() ?: 0)
        result = 31 * result + (provisioningArtifactId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisionedProductDetail

        if (arn != other.arn) return false
        if (createdTime != other.createdTime) return false
        if (id != other.id) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (lastProvisioningRecordId != other.lastProvisioningRecordId) return false
        if (lastRecordId != other.lastRecordId) return false
        if (lastSuccessfulProvisioningRecordId != other.lastSuccessfulProvisioningRecordId) return false
        if (launchRoleArn != other.launchRoleArn) return false
        if (name != other.name) return false
        if (productId != other.productId) return false
        if (provisioningArtifactId != other.provisioningArtifactId) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the provisioned product.
         */
        public var arn: kotlin.String? = null
        /**
         * The UTC time stamp of the creation time.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The identifier of the provisioned product.
         */
        public var id: kotlin.String? = null
        /**
         * A unique identifier that you provide to ensure idempotency. If multiple requests differ only by the idempotency token, the same response is returned for each repeated request.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * The record identifier of the last request performed on this provisioned product of the following types:
         * +  ProvisionProduct
         * +  UpdateProvisionedProduct
         * +  ExecuteProvisionedProductPlan
         * +  TerminateProvisionedProduct
         */
        public var lastProvisioningRecordId: kotlin.String? = null
        /**
         * The record identifier of the last request performed on this provisioned product.
         */
        public var lastRecordId: kotlin.String? = null
        /**
         * The record identifier of the last successful request performed on this provisioned product of the following types:
         * +  ProvisionProduct
         * +  UpdateProvisionedProduct
         * +  ExecuteProvisionedProductPlan
         * +  TerminateProvisionedProduct
         */
        public var lastSuccessfulProvisioningRecordId: kotlin.String? = null
        /**
         * The ARN of the launch role associated with the provisioned product.
         */
        public var launchRoleArn: kotlin.String? = null
        /**
         * The user-friendly name of the provisioned product.
         */
        public var name: kotlin.String? = null
        /**
         * The product identifier. For example, `prod-abcdzk7xy33qa`.
         */
        public var productId: kotlin.String? = null
        /**
         * The identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`.
         */
        public var provisioningArtifactId: kotlin.String? = null
        /**
         * The current status of the provisioned product.
         * + `AVAILABLE` - Stable state, ready to perform any operation. The most recent operation succeeded and completed.
         * + `UNDER_CHANGE` - Transitive state. Operations performed might not have valid results. Wait for an `AVAILABLE` status before performing operations.
         * + `TAINTED` - Stable state, ready to perform any operation. The stack has completed the requested operation but is not exactly what was requested. For example, a request to update to a new version failed and the stack rolled back to the current version.
         * + `ERROR` - An unexpected error occurred. The provisioned product exists but the stack is not running. For example, CloudFormation received a parameter value that was not valid and could not launch the stack.
         * + `PLAN_IN_PROGRESS` - Transitive state. The plan operations were performed to provision a new product, but resources have not yet been created. After reviewing the list of resources to be created, execute the plan. Wait for an `AVAILABLE` status before performing operations.
         */
        public var status: aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductStatus? = null
        /**
         * The current status message of the provisioned product.
         */
        public var statusMessage: kotlin.String? = null
        /**
         * The type of provisioned product. The supported values are `CFN_STACK`, `CFN_STACKSET`, `TERRAFORM_OPEN_SOURCE`, `TERRAFORM_CLOUD`, and `EXTERNAL`.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductDetail) : this() {
            this.arn = x.arn
            this.createdTime = x.createdTime
            this.id = x.id
            this.idempotencyToken = x.idempotencyToken
            this.lastProvisioningRecordId = x.lastProvisioningRecordId
            this.lastRecordId = x.lastRecordId
            this.lastSuccessfulProvisioningRecordId = x.lastSuccessfulProvisioningRecordId
            this.launchRoleArn = x.launchRoleArn
            this.name = x.name
            this.productId = x.productId
            this.provisioningArtifactId = x.provisioningArtifactId
            this.status = x.status
            this.statusMessage = x.statusMessage
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductDetail = ProvisionedProductDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
