// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a provisioning artifact (also known as a version) for a product.
 */
public class ProvisioningArtifactDetail private constructor(builder: Builder) {
    /**
     * Indicates whether the product version is active.
     */
    public val active: kotlin.Boolean? = builder.active
    /**
     * The UTC time stamp of the creation time.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The description of the provisioning artifact.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
     */
    public val guidance: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactGuidance? = builder.guidance
    /**
     * The identifier of the provisioning artifact.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the provisioning artifact.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Specifies the revision of the external artifact that was used to automatically sync the Service Catalog product and create the provisioning artifact. Service Catalog includes this response parameter as a high level field to the existing `ProvisioningArtifactDetail` type, which is returned as part of the response for `CreateProduct`, `UpdateProduct`, `DescribeProductAsAdmin`, `DescribeProvisioningArtifact`, `ListProvisioningArtifact`, and `UpdateProvisioningArticat` APIs.
     *
     * This field only exists for Repo-Synced products.
     */
    public val sourceRevision: kotlin.String? = builder.sourceRevision
    /**
     * The type of provisioning artifact.
     * + `CLOUD_FORMATION_TEMPLATE` - CloudFormation template
     * + `TERRAFORM_OPEN_SOURCE` - Terraform Open Source configuration file
     * + `TERRAFORM_CLOUD` - Terraform Cloud configuration file
     * + `EXTERNAL` - External configuration file
     */
    public val type: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisioningArtifactDetail(")
        append("active=$active,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("guidance=$guidance,")
        append("id=$id,")
        append("name=$name,")
        append("sourceRevision=$sourceRevision,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = active?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (guidance?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sourceRevision?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisioningArtifactDetail

        if (active != other.active) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (guidance != other.guidance) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (sourceRevision != other.sourceRevision) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the product version is active.
         */
        public var active: kotlin.Boolean? = null
        /**
         * The UTC time stamp of the creation time.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the provisioning artifact.
         */
        public var description: kotlin.String? = null
        /**
         * Information set by the administrator to provide guidance to end users about which provisioning artifacts to use.
         */
        public var guidance: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactGuidance? = null
        /**
         * The identifier of the provisioning artifact.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the provisioning artifact.
         */
        public var name: kotlin.String? = null
        /**
         * Specifies the revision of the external artifact that was used to automatically sync the Service Catalog product and create the provisioning artifact. Service Catalog includes this response parameter as a high level field to the existing `ProvisioningArtifactDetail` type, which is returned as part of the response for `CreateProduct`, `UpdateProduct`, `DescribeProductAsAdmin`, `DescribeProvisioningArtifact`, `ListProvisioningArtifact`, and `UpdateProvisioningArticat` APIs.
         *
         * This field only exists for Repo-Synced products.
         */
        public var sourceRevision: kotlin.String? = null
        /**
         * The type of provisioning artifact.
         * + `CLOUD_FORMATION_TEMPLATE` - CloudFormation template
         * + `TERRAFORM_OPEN_SOURCE` - Terraform Open Source configuration file
         * + `TERRAFORM_CLOUD` - Terraform Cloud configuration file
         * + `EXTERNAL` - External configuration file
         */
        public var type: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactDetail) : this() {
            this.active = x.active
            this.createdTime = x.createdTime
            this.description = x.description
            this.guidance = x.guidance
            this.id = x.id
            this.name = x.name
            this.sourceRevision = x.sourceRevision
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactDetail = ProvisioningArtifactDetail(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
