// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The user-defined preferences that will be applied during product provisioning, unless overridden by `ProvisioningPreferences` or `UpdateProvisioningPreferences`.
 *
 * For more information on maximum concurrent accounts and failure tolerance, see [Stack set operation options](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-concepts.html#stackset-ops-options) in the *CloudFormation User Guide*.
 */
public class ProvisioningArtifactPreferences private constructor(builder: Builder) {
    /**
     * One or more Amazon Web Services accounts where stack instances are deployed from the stack set. These accounts can be scoped in `ProvisioningPreferences$StackSetAccounts` and `UpdateProvisioningPreferences$StackSetAccounts`.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     */
    public val stackSetAccounts: List<String>? = builder.stackSetAccounts
    /**
     * One or more Amazon Web Services Regions where stack instances are deployed from the stack set. These Regions can be scoped in `ProvisioningPreferences$StackSetRegions` and `UpdateProvisioningPreferences$StackSetRegions`.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     */
    public val stackSetRegions: List<String>? = builder.stackSetRegions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisioningArtifactPreferences(")
        append("stackSetAccounts=$stackSetAccounts,")
        append("stackSetRegions=$stackSetRegions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = stackSetAccounts?.hashCode() ?: 0
        result = 31 * result + (stackSetRegions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisioningArtifactPreferences

        if (stackSetAccounts != other.stackSetAccounts) return false
        if (stackSetRegions != other.stackSetRegions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactPreferences = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * One or more Amazon Web Services accounts where stack instances are deployed from the stack set. These accounts can be scoped in `ProvisioningPreferences$StackSetAccounts` and `UpdateProvisioningPreferences$StackSetAccounts`.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         */
        public var stackSetAccounts: List<String>? = null
        /**
         * One or more Amazon Web Services Regions where stack instances are deployed from the stack set. These Regions can be scoped in `ProvisioningPreferences$StackSetRegions` and `UpdateProvisioningPreferences$StackSetRegions`.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         */
        public var stackSetRegions: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactPreferences) : this() {
            this.stackSetAccounts = x.stackSetAccounts
            this.stackSetRegions = x.stackSetRegions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactPreferences = ProvisioningArtifactPreferences(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
