// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a provisioning artifact (also known as a version) for a product.
 */
public class ProvisioningArtifactProperties private constructor(builder: Builder) {
    /**
     * The description of the provisioning artifact, including how it differs from the previous provisioning artifact.
     */
    public val description: kotlin.String? = builder.description
    /**
     * If set to true, Service Catalog stops validating the specified provisioning artifact even if it is invalid.
     *
     * Service Catalog does not support template validation for the `TERRAFORM_OS` product type.
     */
    public val disableTemplateValidation: kotlin.Boolean = builder.disableTemplateValidation
    /**
     * Specify the template source with one of the following options, but not both. Keys accepted: &#91; `LoadTemplateFromURL`, `ImportFromPhysicalId` &#93;
     *
     * The URL of the CloudFormation template in Amazon S3 or GitHub in JSON format. Specify the URL in JSON format as follows:
     *
     * `"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."`
     *
     * `ImportFromPhysicalId`: The physical id of the resource that contains the template. Currently only supports CloudFormation stack arn. Specify the physical id in JSON format as follows: `ImportFromPhysicalId: “arn:aws:cloudformation:[us-east-1]:[accountId]:stack/[StackName]/[resourceId]`
     */
    public val info: Map<String, String>? = builder.info
    /**
     * The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The type of provisioning artifact.
     * + `CLOUD_FORMATION_TEMPLATE` - CloudFormation template
     * + `TERRAFORM_OPEN_SOURCE` - Terraform Open Source configuration file
     * + `TERRAFORM_CLOUD` - Terraform Cloud configuration file
     * + `EXTERNAL` - External configuration file
     */
    public val type: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisioningArtifactProperties(")
        append("description=$description,")
        append("disableTemplateValidation=$disableTemplateValidation,")
        append("info=$info,")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (disableTemplateValidation.hashCode())
        result = 31 * result + (info?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisioningArtifactProperties

        if (description != other.description) return false
        if (disableTemplateValidation != other.disableTemplateValidation) return false
        if (info != other.info) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the provisioning artifact, including how it differs from the previous provisioning artifact.
         */
        public var description: kotlin.String? = null
        /**
         * If set to true, Service Catalog stops validating the specified provisioning artifact even if it is invalid.
         *
         * Service Catalog does not support template validation for the `TERRAFORM_OS` product type.
         */
        public var disableTemplateValidation: kotlin.Boolean = false
        /**
         * Specify the template source with one of the following options, but not both. Keys accepted: &#91; `LoadTemplateFromURL`, `ImportFromPhysicalId` &#93;
         *
         * The URL of the CloudFormation template in Amazon S3 or GitHub in JSON format. Specify the URL in JSON format as follows:
         *
         * `"LoadTemplateFromURL": "https://s3.amazonaws.com/cf-templates-ozkq9d3hgiq2-us-east-1/..."`
         *
         * `ImportFromPhysicalId`: The physical id of the resource that contains the template. Currently only supports CloudFormation stack arn. Specify the physical id in JSON format as follows: `ImportFromPhysicalId: “arn:aws:cloudformation:[us-east-1]:[accountId]:stack/[StackName]/[resourceId]`
         */
        public var info: Map<String, String>? = null
        /**
         * The name of the provisioning artifact (for example, v1 v2beta). No spaces are allowed.
         */
        public var name: kotlin.String? = null
        /**
         * The type of provisioning artifact.
         * + `CLOUD_FORMATION_TEMPLATE` - CloudFormation template
         * + `TERRAFORM_OPEN_SOURCE` - Terraform Open Source configuration file
         * + `TERRAFORM_CLOUD` - Terraform Cloud configuration file
         * + `EXTERNAL` - External configuration file
         */
        public var type: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactProperties) : this() {
            this.description = x.description
            this.disableTemplateValidation = x.disableTemplateValidation
            this.info = x.info
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactProperties = ProvisioningArtifactProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
