// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A self-service action association consisting of the Action ID, the Product ID, and the Provisioning Artifact ID.
 */
public class ServiceActionAssociation private constructor(builder: Builder) {
    /**
     * The product identifier. For example, `prod-abcdzk7xy33qa`.
     */
    public val productId: kotlin.String = requireNotNull(builder.productId) { "A non-null value must be provided for productId" }
    /**
     * The identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`.
     */
    public val provisioningArtifactId: kotlin.String = requireNotNull(builder.provisioningArtifactId) { "A non-null value must be provided for provisioningArtifactId" }
    /**
     * The self-service action identifier. For example, `act-fs7abcd89wxyz`.
     */
    public val serviceActionId: kotlin.String = requireNotNull(builder.serviceActionId) { "A non-null value must be provided for serviceActionId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.ServiceActionAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceActionAssociation(")
        append("productId=$productId,")
        append("provisioningArtifactId=$provisioningArtifactId,")
        append("serviceActionId=$serviceActionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = productId.hashCode()
        result = 31 * result + (provisioningArtifactId.hashCode())
        result = 31 * result + (serviceActionId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceActionAssociation

        if (productId != other.productId) return false
        if (provisioningArtifactId != other.provisioningArtifactId) return false
        if (serviceActionId != other.serviceActionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.ServiceActionAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The product identifier. For example, `prod-abcdzk7xy33qa`.
         */
        public var productId: kotlin.String? = null
        /**
         * The identifier of the provisioning artifact. For example, `pa-4abcdjnxjj6ne`.
         */
        public var provisioningArtifactId: kotlin.String? = null
        /**
         * The self-service action identifier. For example, `act-fs7abcd89wxyz`.
         */
        public var serviceActionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.ServiceActionAssociation) : this() {
            this.productId = x.productId
            this.provisioningArtifactId = x.provisioningArtifactId
            this.serviceActionId = x.serviceActionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.ServiceActionAssociation = ServiceActionAssociation(this)

        internal fun correctErrors(): Builder {
            if (productId == null) productId = ""
            if (provisioningArtifactId == null) provisioningArtifactId = ""
            if (serviceActionId == null) serviceActionId = ""
            return this
        }
    }
}
