// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateConstraintRequest private constructor(builder: Builder) {
    /**
     * The language code.
     * + `jp` - Japanese
     * + `zh` - Chinese
     */
    public val acceptLanguage: kotlin.String? = builder.acceptLanguage
    /**
     * The updated description of the constraint.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The identifier of the constraint.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:
     *
     * ## LAUNCH
     * You are required to specify either the `RoleArn` or the `LocalRoleName` but can't use both.
     *
     * Specify the `RoleArn` property as follows:
     *
     * `{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}`
     *
     * Specify the `LocalRoleName` property as follows:
     *
     * `{"LocalRoleName": "SCBasicLaunchRole"}`
     *
     * If you specify the `LocalRoleName` property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.
     *
     * The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.
     *
     * You cannot have both a `LAUNCH` and a `STACKSET` constraint.
     *
     * You also cannot have more than one `LAUNCH` constraint on a product and portfolio.
     *
     * ## NOTIFICATION
     * Specify the `NotificationArns` property as follows:
     *
     * `{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}`
     *
     * ## RESOURCE_UPDATE
     * Specify the `TagUpdatesOnProvisionedProduct` property as follows:
     *
     * `{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}`
     *
     * The `TagUpdatesOnProvisionedProduct` property accepts a string value of `ALLOWED` or `NOT_ALLOWED`.
     *
     * ## STACKSET
     * Specify the `Parameters` property as follows:
     *
     * `{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}`
     *
     * You cannot have both a `LAUNCH` and a `STACKSET` constraint.
     *
     * You also cannot have more than one `STACKSET` constraint on a product and portfolio.
     *
     * Products with a `STACKSET` constraint will launch an CloudFormation stack set.
     *
     * ## TEMPLATE
     * Specify the `Rules` property. For more information, see [Template Constraint Rules](http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html).
     */
    public val parameters: kotlin.String? = builder.parameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.UpdateConstraintRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConstraintRequest(")
        append("acceptLanguage=$acceptLanguage,")
        append("description=$description,")
        append("id=$id,")
        append("parameters=$parameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptLanguage?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateConstraintRequest

        if (acceptLanguage != other.acceptLanguage) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (parameters != other.parameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.UpdateConstraintRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The language code.
         * + `jp` - Japanese
         * + `zh` - Chinese
         */
        public var acceptLanguage: kotlin.String? = null
        /**
         * The updated description of the constraint.
         */
        public var description: kotlin.String? = null
        /**
         * The identifier of the constraint.
         */
        public var id: kotlin.String? = null
        /**
         * The constraint parameters, in JSON format. The syntax depends on the constraint type as follows:
         *
         * ## LAUNCH
         * You are required to specify either the `RoleArn` or the `LocalRoleName` but can't use both.
         *
         * Specify the `RoleArn` property as follows:
         *
         * `{"RoleArn" : "arn:aws:iam::123456789012:role/LaunchRole"}`
         *
         * Specify the `LocalRoleName` property as follows:
         *
         * `{"LocalRoleName": "SCBasicLaunchRole"}`
         *
         * If you specify the `LocalRoleName` property, when an account uses the launch constraint, the IAM role with that name in the account will be used. This allows launch-role constraints to be account-agnostic so the administrator can create fewer resources per shared account.
         *
         * The given role name must exist in the account used to create the launch constraint and the account of the user who launches a product with this launch constraint.
         *
         * You cannot have both a `LAUNCH` and a `STACKSET` constraint.
         *
         * You also cannot have more than one `LAUNCH` constraint on a product and portfolio.
         *
         * ## NOTIFICATION
         * Specify the `NotificationArns` property as follows:
         *
         * `{"NotificationArns" : ["arn:aws:sns:us-east-1:123456789012:Topic"]}`
         *
         * ## RESOURCE_UPDATE
         * Specify the `TagUpdatesOnProvisionedProduct` property as follows:
         *
         * `{"Version":"2.0","Properties":{"TagUpdateOnProvisionedProduct":"String"}}`
         *
         * The `TagUpdatesOnProvisionedProduct` property accepts a string value of `ALLOWED` or `NOT_ALLOWED`.
         *
         * ## STACKSET
         * Specify the `Parameters` property as follows:
         *
         * `{"Version": "String", "Properties": {"AccountList": [ "String" ], "RegionList": [ "String" ], "AdminRole": "String", "ExecutionRole": "String"}}`
         *
         * You cannot have both a `LAUNCH` and a `STACKSET` constraint.
         *
         * You also cannot have more than one `STACKSET` constraint on a product and portfolio.
         *
         * Products with a `STACKSET` constraint will launch an CloudFormation stack set.
         *
         * ## TEMPLATE
         * Specify the `Rules` property. For more information, see [Template Constraint Rules](http://docs.aws.amazon.com/servicecatalog/latest/adminguide/reference-template_constraint_rules.html).
         */
        public var parameters: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.UpdateConstraintRequest) : this() {
            this.acceptLanguage = x.acceptLanguage
            this.description = x.description
            this.id = x.id
            this.parameters = x.parameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.UpdateConstraintRequest = UpdateConstraintRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
