// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The user-defined preferences that will be applied when updating a provisioned product. Not all preferences are applicable to all provisioned product types.
 */
public class UpdateProvisioningPreferences private constructor(builder: Builder) {
    /**
     * One or more Amazon Web Services accounts that will have access to the provisioned product.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * The Amazon Web Services accounts specified should be within the list of accounts in the `STACKSET` constraint. To get the list of accounts in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
     *
     * If no values are specified, the default value is all accounts from the `STACKSET` constraint.
     */
    public val stackSetAccounts: List<String>? = builder.stackSetAccounts
    /**
     * The number of accounts, per Region, for which this operation can fail before Service Catalog stops the operation in that Region. If the operation is stopped in a Region, Service Catalog doesn't attempt the operation in any subsequent Regions.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage`, but not both.
     *
     * The default value is `0` if no value is specified.
     */
    public val stackSetFailureToleranceCount: kotlin.Int? = builder.stackSetFailureToleranceCount
    /**
     * The percentage of accounts, per Region, for which this stack operation can fail before Service Catalog stops the operation in that Region. If the operation is stopped in a Region, Service Catalog doesn't attempt the operation in any subsequent Regions.
     *
     * When calculating the number of accounts based on the specified percentage, Service Catalog rounds down to the next whole number.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage`, but not both.
     */
    public val stackSetFailureTolerancePercentage: kotlin.Int? = builder.stackSetFailureTolerancePercentage
    /**
     * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `StackSetFailureToleranceCount`. `StackSetMaxConcurrentCount` is at most one more than the `StackSetFailureToleranceCount`.
     *
     * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage`, but not both.
     */
    public val stackSetMaxConcurrencyCount: kotlin.Int? = builder.stackSetMaxConcurrencyCount
    /**
     * The maximum percentage of accounts in which to perform this operation at one time.
     *
     * When calculating the number of accounts based on the specified percentage, Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, Service Catalog sets the number as `1` instead.
     *
     * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage`, but not both.
     */
    public val stackSetMaxConcurrencyPercentage: kotlin.Int? = builder.stackSetMaxConcurrencyPercentage
    /**
     * Determines what action Service Catalog performs to a stack set or a stack instance represented by the provisioned product. The default value is `UPDATE` if nothing is specified.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * ## CREATE
     * Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new stack instances are created based on accounts and Regions; if new ProductId or ProvisioningArtifactID are passed, they will be ignored.
     *
     * ## UPDATE
     * Updates the stack set represented by the provisioned product and also its stack instances.
     *
     * ## DELETE
     * Deletes a stack instance in the stack set represented by the provisioned product.
     */
    public val stackSetOperationType: aws.sdk.kotlin.services.servicecatalog.model.StackSetOperationType? = builder.stackSetOperationType
    /**
     * One or more Amazon Web Services Regions where the provisioned product will be available.
     *
     * Applicable only to a `CFN_STACKSET` provisioned product type.
     *
     * The specified Regions should be within the list of Regions from the `STACKSET` constraint. To get the list of Regions in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
     *
     * If no values are specified, the default value is all Regions from the `STACKSET` constraint.
     */
    public val stackSetRegions: List<String>? = builder.stackSetRegions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisioningPreferences = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateProvisioningPreferences(")
        append("stackSetAccounts=$stackSetAccounts,")
        append("stackSetFailureToleranceCount=$stackSetFailureToleranceCount,")
        append("stackSetFailureTolerancePercentage=$stackSetFailureTolerancePercentage,")
        append("stackSetMaxConcurrencyCount=$stackSetMaxConcurrencyCount,")
        append("stackSetMaxConcurrencyPercentage=$stackSetMaxConcurrencyPercentage,")
        append("stackSetOperationType=$stackSetOperationType,")
        append("stackSetRegions=$stackSetRegions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = stackSetAccounts?.hashCode() ?: 0
        result = 31 * result + (stackSetFailureToleranceCount ?: 0)
        result = 31 * result + (stackSetFailureTolerancePercentage ?: 0)
        result = 31 * result + (stackSetMaxConcurrencyCount ?: 0)
        result = 31 * result + (stackSetMaxConcurrencyPercentage ?: 0)
        result = 31 * result + (stackSetOperationType?.hashCode() ?: 0)
        result = 31 * result + (stackSetRegions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateProvisioningPreferences

        if (stackSetAccounts != other.stackSetAccounts) return false
        if (stackSetFailureToleranceCount != other.stackSetFailureToleranceCount) return false
        if (stackSetFailureTolerancePercentage != other.stackSetFailureTolerancePercentage) return false
        if (stackSetMaxConcurrencyCount != other.stackSetMaxConcurrencyCount) return false
        if (stackSetMaxConcurrencyPercentage != other.stackSetMaxConcurrencyPercentage) return false
        if (stackSetOperationType != other.stackSetOperationType) return false
        if (stackSetRegions != other.stackSetRegions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisioningPreferences = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * One or more Amazon Web Services accounts that will have access to the provisioned product.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * The Amazon Web Services accounts specified should be within the list of accounts in the `STACKSET` constraint. To get the list of accounts in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
         *
         * If no values are specified, the default value is all accounts from the `STACKSET` constraint.
         */
        public var stackSetAccounts: List<String>? = null
        /**
         * The number of accounts, per Region, for which this operation can fail before Service Catalog stops the operation in that Region. If the operation is stopped in a Region, Service Catalog doesn't attempt the operation in any subsequent Regions.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage`, but not both.
         *
         * The default value is `0` if no value is specified.
         */
        public var stackSetFailureToleranceCount: kotlin.Int? = null
        /**
         * The percentage of accounts, per Region, for which this stack operation can fail before Service Catalog stops the operation in that Region. If the operation is stopped in a Region, Service Catalog doesn't attempt the operation in any subsequent Regions.
         *
         * When calculating the number of accounts based on the specified percentage, Service Catalog rounds down to the next whole number.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * Conditional: You must specify either `StackSetFailureToleranceCount` or `StackSetFailureTolerancePercentage`, but not both.
         */
        public var stackSetFailureTolerancePercentage: kotlin.Int? = null
        /**
         * The maximum number of accounts in which to perform this operation at one time. This is dependent on the value of `StackSetFailureToleranceCount`. `StackSetMaxConcurrentCount` is at most one more than the `StackSetFailureToleranceCount`.
         *
         * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage`, but not both.
         */
        public var stackSetMaxConcurrencyCount: kotlin.Int? = null
        /**
         * The maximum percentage of accounts in which to perform this operation at one time.
         *
         * When calculating the number of accounts based on the specified percentage, Service Catalog rounds down to the next whole number. This is true except in cases where rounding down would result is zero. In this case, Service Catalog sets the number as `1` instead.
         *
         * Note that this setting lets you specify the maximum for operations. For large deployments, under certain circumstances the actual number of accounts acted upon concurrently may be lower due to service throttling.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * Conditional: You must specify either `StackSetMaxConcurrentCount` or `StackSetMaxConcurrentPercentage`, but not both.
         */
        public var stackSetMaxConcurrencyPercentage: kotlin.Int? = null
        /**
         * Determines what action Service Catalog performs to a stack set or a stack instance represented by the provisioned product. The default value is `UPDATE` if nothing is specified.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * ## CREATE
         * Creates a new stack instance in the stack set represented by the provisioned product. In this case, only new stack instances are created based on accounts and Regions; if new ProductId or ProvisioningArtifactID are passed, they will be ignored.
         *
         * ## UPDATE
         * Updates the stack set represented by the provisioned product and also its stack instances.
         *
         * ## DELETE
         * Deletes a stack instance in the stack set represented by the provisioned product.
         */
        public var stackSetOperationType: aws.sdk.kotlin.services.servicecatalog.model.StackSetOperationType? = null
        /**
         * One or more Amazon Web Services Regions where the provisioned product will be available.
         *
         * Applicable only to a `CFN_STACKSET` provisioned product type.
         *
         * The specified Regions should be within the list of Regions from the `STACKSET` constraint. To get the list of Regions in the `STACKSET` constraint, use the `DescribeProvisioningParameters` operation.
         *
         * If no values are specified, the default value is all Regions from the `STACKSET` constraint.
         */
        public var stackSetRegions: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisioningPreferences) : this() {
            this.stackSetAccounts = x.stackSetAccounts
            this.stackSetFailureToleranceCount = x.stackSetFailureToleranceCount
            this.stackSetFailureTolerancePercentage = x.stackSetFailureTolerancePercentage
            this.stackSetMaxConcurrencyCount = x.stackSetMaxConcurrencyCount
            this.stackSetMaxConcurrencyPercentage = x.stackSetMaxConcurrencyPercentage
            this.stackSetOperationType = x.stackSetOperationType
            this.stackSetRegions = x.stackSetRegions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.servicecatalog.model.UpdateProvisioningPreferences = UpdateProvisioningPreferences(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
