// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.AssociateBudgetWithResourceResponse
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AssociateBudgetWithResourceOperationDeserializer: HttpDeserializer.NonStreaming<AssociateBudgetWithResourceResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AssociateBudgetWithResourceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssociateBudgetWithResourceError(context, call, payload)
        }
        val builder = AssociateBudgetWithResourceResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAssociateBudgetWithResourceError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DuplicateResourceException" -> DuplicateResourceExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
