// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.CopyOption
import aws.sdk.kotlin.services.servicecatalog.model.CopyProductRequest
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactPropertyName
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CopyProductOperationSerializer: HttpSerializer.NonStreaming<CopyProductRequest> {
    override fun serialize(context: ExecutionContext, input: CopyProductRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeCopyProductOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCopyProductOperationBody(context: ExecutionContext, input: CopyProductRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCEPTLANGUAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("AcceptLanguage"))
    val COPYOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CopyOptions"))
    val IDEMPOTENCYTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdempotencyToken"))
    val SOURCEPRODUCTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourceProductArn"))
    val SOURCEPROVISIONINGARTIFACTIDENTIFIERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SourceProvisioningArtifactIdentifiers"))
    val SOURCEPROVISIONINGARTIFACTIDENTIFIERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val TARGETPRODUCTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TargetProductId"))
    val TARGETPRODUCTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TargetProductName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCEPTLANGUAGE_DESCRIPTOR)
        field(COPYOPTIONS_DESCRIPTOR)
        field(IDEMPOTENCYTOKEN_DESCRIPTOR)
        field(SOURCEPRODUCTARN_DESCRIPTOR)
        field(SOURCEPROVISIONINGARTIFACTIDENTIFIERS_DESCRIPTOR)
        field(TARGETPRODUCTID_DESCRIPTOR)
        field(TARGETPRODUCTNAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.acceptLanguage?.let { field(ACCEPTLANGUAGE_DESCRIPTOR, it) }
        if (input.copyOptions != null) {
            listField(COPYOPTIONS_DESCRIPTOR) {
                for (el0 in input.copyOptions) {
                    serializeString(el0.value)
                }
            }
        }
        input.idempotencyToken?.let { field(IDEMPOTENCYTOKEN_DESCRIPTOR, it) } ?: field(IDEMPOTENCYTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.sourceProductArn?.let { field(SOURCEPRODUCTARN_DESCRIPTOR, it) }
        if (input.sourceProvisioningArtifactIdentifiers != null) {
            listField(SOURCEPROVISIONINGARTIFACTIDENTIFIERS_DESCRIPTOR) {
                for (el0 in input.sourceProvisioningArtifactIdentifiers) {
                    serializer.serializeMap(SOURCEPROVISIONINGARTIFACTIDENTIFIERS_C0_DESCRIPTOR) {
                        el0.forEach { (key1, value1) -> entry(key1.value, value1) }
                    }
                }
            }
        }
        input.targetProductId?.let { field(TARGETPRODUCTID_DESCRIPTOR, it) }
        input.targetProductName?.let { field(TARGETPRODUCTNAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
