// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.CreateProvisionedProductPlanResponse
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateProvisionedProductPlanOperationDeserializer: HttpDeserializer.NonStreaming<CreateProvisionedProductPlanResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateProvisionedProductPlanResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateProvisionedProductPlanError(context, call, payload)
        }
        val builder = CreateProvisionedProductPlanResponse.Builder()

        if (payload != null) {
            deserializeCreateProvisionedProductPlanOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateProvisionedProductPlanError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidStateException" -> InvalidStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateProvisionedProductPlanOperationBody(builder: CreateProvisionedProductPlanResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PLANID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlanId"))
    val PLANNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PlanName"))
    val PROVISIONPRODUCTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisionProductId"))
    val PROVISIONEDPRODUCTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisionedProductName"))
    val PROVISIONINGARTIFACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProvisioningArtifactId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PLANID_DESCRIPTOR)
        field(PLANNAME_DESCRIPTOR)
        field(PROVISIONPRODUCTID_DESCRIPTOR)
        field(PROVISIONEDPRODUCTNAME_DESCRIPTOR)
        field(PROVISIONINGARTIFACTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PLANID_DESCRIPTOR.index -> builder.planId = deserializeString()
                PLANNAME_DESCRIPTOR.index -> builder.planName = deserializeString()
                PROVISIONPRODUCTID_DESCRIPTOR.index -> builder.provisionProductId = deserializeString()
                PROVISIONEDPRODUCTNAME_DESCRIPTOR.index -> builder.provisionedProductName = deserializeString()
                PROVISIONINGARTIFACTID_DESCRIPTOR.index -> builder.provisioningArtifactId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
