// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.DescribePortfolioShareStatusResponse
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.ShareDetails
import aws.sdk.kotlin.services.servicecatalog.model.ShareStatus
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribePortfolioShareStatusOperationDeserializer: HttpDeserializer.NonStreaming<DescribePortfolioShareStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribePortfolioShareStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribePortfolioShareStatusError(context, call, payload)
        }
        val builder = DescribePortfolioShareStatusResponse.Builder()

        if (payload != null) {
            deserializeDescribePortfolioShareStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribePortfolioShareStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "OperationNotSupportedException" -> OperationNotSupportedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePortfolioShareStatusOperationBody(builder: DescribePortfolioShareStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ORGANIZATIONNODEVALUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OrganizationNodeValue"))
    val PORTFOLIOID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PortfolioId"))
    val PORTFOLIOSHARETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PortfolioShareToken"))
    val SHAREDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ShareDetails"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ORGANIZATIONNODEVALUE_DESCRIPTOR)
        field(PORTFOLIOID_DESCRIPTOR)
        field(PORTFOLIOSHARETOKEN_DESCRIPTOR)
        field(SHAREDETAILS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ORGANIZATIONNODEVALUE_DESCRIPTOR.index -> builder.organizationNodeValue = deserializeString()
                PORTFOLIOID_DESCRIPTOR.index -> builder.portfolioId = deserializeString()
                PORTFOLIOSHARETOKEN_DESCRIPTOR.index -> builder.portfolioShareToken = deserializeString()
                SHAREDETAILS_DESCRIPTOR.index -> builder.shareDetails = deserializeShareDetailsDocument(deserializer)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ShareStatus.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
