// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.BudgetDetail
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProductAsAdminResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProductViewDetail
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactSummary
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.Tag
import aws.sdk.kotlin.services.servicecatalog.model.TagOptionDetail
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeProductAsAdminOperationDeserializer: HttpDeserializer.NonStreaming<DescribeProductAsAdminResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeProductAsAdminResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeProductAsAdminError(context, call, payload)
        }
        val builder = DescribeProductAsAdminResponse.Builder()

        if (payload != null) {
            deserializeDescribeProductAsAdminOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeProductAsAdminError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProductAsAdminOperationBody(builder: DescribeProductAsAdminResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BUDGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Budgets"))
    val PRODUCTVIEWDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProductViewDetail"))
    val PROVISIONINGARTIFACTSUMMARIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifactSummaries"))
    val TAGOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TagOptions"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BUDGETS_DESCRIPTOR)
        field(PRODUCTVIEWDETAIL_DESCRIPTOR)
        field(PROVISIONINGARTIFACTSUMMARIES_DESCRIPTOR)
        field(TAGOPTIONS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BUDGETS_DESCRIPTOR.index -> builder.budgets =
                    deserializer.deserializeList(BUDGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<BudgetDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBudgetDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PRODUCTVIEWDETAIL_DESCRIPTOR.index -> builder.productViewDetail = deserializeProductViewDetailDocument(deserializer)
                PROVISIONINGARTIFACTSUMMARIES_DESCRIPTOR.index -> builder.provisioningArtifactSummaries =
                    deserializer.deserializeList(PROVISIONINGARTIFACTSUMMARIES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifactSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGOPTIONS_DESCRIPTOR.index -> builder.tagOptions =
                    deserializer.deserializeList(TAGOPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<TagOptionDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagOptionDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeList(TAGS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
