// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.CloudWatchDashboard
import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisionedProductResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProvisionedProductDetail
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeProvisionedProductOperationDeserializer: HttpDeserializer.NonStreaming<DescribeProvisionedProductResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeProvisionedProductResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeProvisionedProductError(context, call, payload)
        }
        val builder = DescribeProvisionedProductResponse.Builder()

        if (payload != null) {
            deserializeDescribeProvisionedProductOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeProvisionedProductError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProvisionedProductOperationBody(builder: DescribeProvisionedProductResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLOUDWATCHDASHBOARDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CloudWatchDashboards"))
    val PROVISIONEDPRODUCTDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProvisionedProductDetail"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLOUDWATCHDASHBOARDS_DESCRIPTOR)
        field(PROVISIONEDPRODUCTDETAIL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLOUDWATCHDASHBOARDS_DESCRIPTOR.index -> builder.cloudWatchDashboards =
                    deserializer.deserializeList(CLOUDWATCHDASHBOARDS_DESCRIPTOR) {
                        val col0 = mutableListOf<CloudWatchDashboard>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCloudWatchDashboardDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PROVISIONEDPRODUCTDETAIL_DESCRIPTOR.index -> builder.provisionedProductDetail = deserializeProvisionedProductDetailDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
