// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.servicecatalog.serde

import aws.sdk.kotlin.services.servicecatalog.model.DescribeProvisioningArtifactResponse
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactDetail
import aws.sdk.kotlin.services.servicecatalog.model.ProvisioningArtifactParameter
import aws.sdk.kotlin.services.servicecatalog.model.ServiceCatalogException
import aws.sdk.kotlin.services.servicecatalog.model.Status
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeProvisioningArtifactOperationDeserializer: HttpDeserializer.NonStreaming<DescribeProvisioningArtifactResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeProvisioningArtifactResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeProvisioningArtifactError(context, call, payload)
        }
        val builder = DescribeProvisioningArtifactResponse.Builder()

        if (payload != null) {
            deserializeDescribeProvisioningArtifactOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeProvisioningArtifactError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ServiceCatalogException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParametersException" -> InvalidParametersExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ServiceCatalogException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeProvisioningArtifactOperationBody(builder: DescribeProvisioningArtifactResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val INFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Info"))
    val PROVISIONINGARTIFACTDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ProvisioningArtifactDetail"))
    val PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProvisioningArtifactParameters"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(INFO_DESCRIPTOR)
        field(PROVISIONINGARTIFACTDETAIL_DESCRIPTOR)
        field(PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                INFO_DESCRIPTOR.index -> builder.info =
                    deserializer.deserializeMap(INFO_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                PROVISIONINGARTIFACTDETAIL_DESCRIPTOR.index -> builder.provisioningArtifactDetail = deserializeProvisioningArtifactDetailDocument(deserializer)
                PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR.index -> builder.provisioningArtifactParameters =
                    deserializer.deserializeList(PROVISIONINGARTIFACTPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ProvisioningArtifactParameter>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProvisioningArtifactParameterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { Status.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
